/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.compiler.PatternCompiler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PatternCompilerImpl<T>
implements PatternCompiler<T> {
    private static final Logger LOG = Logger.getInstance((String)PatternCompilerImpl.class.getName());
    private final Set<Method> myStaticMethods;
    private final StringInterner myStringInterner = new StringInterner();
    private static final Node ERROR_NODE = new Node(null, null, null);
    private static final ElementPattern<?> ALWAYS_FALSE = new FalsePattern();

    public PatternCompilerImpl(List<Class> patternClasses) {
        this.myStaticMethods = PatternCompilerImpl.getStaticMethods(patternClasses);
    }

    public ElementPattern<T> createElementPattern(String text, String displayName) {
        try {
            return this.compileElementPattern(text);
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
            LOG.warn("error processing place: " + displayName + " [" + text + "]", cause);
            return new LazyPresentablePattern(new Node(ERROR_NODE, text, null));
        }
    }

    public synchronized ElementPattern<T> compileElementPattern(String text) {
        Node node = (Node)PatternCompilerImpl.processElementPatternText(text, new Function<Frame, Object>(){

            public Node fun(Frame frame) {
                Object[] args = frame.params.toArray();
                int argsLength = args.length;
                for (int i = 0; i < argsLength; ++i) {
                    args[i] = args[i] instanceof String ? PatternCompilerImpl.this.myStringInterner.intern((Object)((String)args[i])) : args[i];
                }
                return new Node((Node)frame.target, (String)PatternCompilerImpl.this.myStringInterner.intern((Object)frame.methodName), args.length == 0 ? ArrayUtil.EMPTY_OBJECT_ARRAY : args);
            }
        });
        if (node == null) {
            node = new Node(ERROR_NODE, text, null);
        }
        return new LazyPresentablePattern(node);
    }

    private static Set<Method> getStaticMethods(List<Class> patternClasses) {
        return new THashSet((Collection)ContainerUtil.concat(patternClasses, (Function)new Function<Class, Collection<? extends Method>>(){

            public Collection<Method> fun(Class aClass) {
                return ContainerUtil.findAll((Object[])aClass.getMethods(), (Condition)new Condition<Method>(){

                    public boolean value(Method method) {
                        return Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers()) && ElementPattern.class.isAssignableFrom(method.getReturnType());
                    }
                });
            }
        }));
    }

    @Nullable
    private static <T> T processElementPatternText(String text, Function<Frame, Object> executor) {
        Stack stack = new Stack();
        int curPos = 0;
        Frame curFrame = new Frame();
        Object curResult = null;
        StringBuilder curString = new StringBuilder();
        while (curPos <= text.length()) {
            char ch = curPos++ < text.length() ? text.charAt(curPos - 1) : (char)'\u0000';
            switch (curFrame.state) {
                case init: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isJavaIdentifierStart(ch)) {
                        curString.append(ch);
                        curFrame.state = State.name;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "method call expected");
                    break;
                }
                case name: {
                    if (Character.isJavaIdentifierPart(ch)) {
                        curString.append(ch);
                        break;
                    }
                    if (ch == '(' || Character.isWhitespace(ch)) {
                        curFrame.methodName = curString.toString();
                        curString.setLength(0);
                        curFrame.state = ch == '(' ? State.param_start : State.name_end;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "'" + curString + ch + "' method name start is invalid, '(' expected");
                    break;
                }
                case name_end: {
                    if (ch == '(') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    PatternCompilerImpl.throwError(curPos, ch, "'(' expected after '" + curFrame.methodName + "'");
                    break;
                }
                case param_start: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isDigit(ch) || ch == '\"') {
                        curFrame.state = State.literal;
                        curString.append(ch);
                        break;
                    }
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(ch)) {
                        curString.append(ch);
                        stack.push((Object)curFrame);
                        curFrame = new Frame();
                        curFrame.state = State.name;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "expression expected in '" + curFrame.methodName + "' call");
                    break;
                }
                case param_end: {
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (ch == ',') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    PatternCompilerImpl.throwError(curPos, ch, "')' or ',' expected in '" + curFrame.methodName + "' call");
                    break;
                }
                case literal: {
                    if (curString.charAt(0) == '\"') {
                        curString.append(ch);
                        if (ch == '\\') {
                            curFrame.state = State.escape;
                            break;
                        }
                        if (ch != '\"') break;
                        curFrame.params.add(PatternCompilerImpl.makeParam(curString.toString()));
                        curString.setLength(0);
                        curFrame.state = State.param_end;
                        break;
                    }
                    if (Character.isWhitespace(ch) || ch == ',' || ch == ')') {
                        curFrame.params.add(PatternCompilerImpl.makeParam(curString.toString()));
                        curString.setLength(0);
                        curFrame.state = ch == ')' ? State.invoke : (ch == ',' ? State.param_start : State.param_end);
                        break;
                    }
                    curString.append(ch);
                    break;
                }
                case escape: {
                    if (ch != '\u0000') {
                        curString.append(ch);
                        curFrame.state = State.literal;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "unclosed escape sequence");
                    break;
                }
                case invoke: {
                    curResult = executor.fun((Object)curFrame);
                    if (ch == '\u0000' && stack.isEmpty()) {
                        return (T)curResult;
                    }
                    if (ch == '.') {
                        curFrame = new Frame();
                        curFrame.target = curResult;
                        curFrame.state = State.init;
                        curResult = null;
                        break;
                    }
                    if (ch == ',' || ch == ')') {
                        curFrame = (Frame)stack.pop();
                        curFrame.params.add(curResult);
                        curResult = null;
                        curFrame.state = ch == ')' ? State.invoke : State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        curFrame.state = State.invoke_end;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, (stack.isEmpty() ? "'.' or <eof>" : "'.' or ')'") + "expected after '" + curFrame.methodName + "' call");
                    break;
                }
                case invoke_end: {
                    if (ch == '\u0000' && stack.isEmpty()) {
                        return (T)curResult;
                    }
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (ch == ',') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (ch == '.') {
                        curFrame = new Frame();
                        curFrame.target = curResult;
                        curFrame.state = State.init;
                        curResult = null;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    PatternCompilerImpl.throwError(curPos, ch, (stack.isEmpty() ? "'.' or <eof>" : "'.' or ')'") + "expected after '" + curFrame.methodName + "' call");
                }
            }
        }
        return null;
    }

    private static void throwError(int offset, char ch, String message) {
        throw new IllegalStateException(offset + "(" + ch + "): " + message);
    }

    private static Object makeParam(String s) {
        if (s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"")) {
            return StringUtil.unescapeStringCharacters((String)s.substring(1, s.length() - 1));
        }
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException numberFormatException) {
            return s;
        }
    }

    private static Class<?> getNonPrimitiveType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        return type;
    }

    private static Object invokeMethod(@Nullable Object target, String methodName, Object[] arguments, Collection<Method> staticMethods) throws Throwable {
        Ref convertVarArgs;
        Collection<Method> methods = target == null ? staticMethods : Arrays.asList(target.getClass().getMethods());
        Method method = PatternCompilerImpl.findMethod(methodName, arguments, methods, (Ref<Boolean>)(convertVarArgs = Ref.create((Object)Boolean.FALSE)));
        if (method != null) {
            try {
                Object[] newArgs;
                if (!((Boolean)convertVarArgs.get()).booleanValue()) {
                    newArgs = arguments;
                } else {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    newArgs = new Object[parameterTypes.length];
                    System.arraycopy(arguments, 0, newArgs, 0, parameterTypes.length - 1);
                    Object[] varArgs = (Object[])Array.newInstance(parameterTypes[parameterTypes.length - 1].getComponentType(), arguments.length - parameterTypes.length + 1);
                    System.arraycopy(arguments, parameterTypes.length - 1, varArgs, 0, varArgs.length);
                    newArgs[parameterTypes.length - 1] = varArgs;
                }
                return method.invoke(target, newArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        throw new NoSuchMethodException("unknown symbol: " + methodName + "(" + StringUtil.join((Object[])arguments, (Function)new Function<Object, String>(){

            public String fun(Object o) {
                return String.valueOf(o);
            }
        }, (String)", ") + ")");
    }

    @Nullable
    private static Method findMethod(String methodName, Object[] arguments, Collection<Method> methods, Ref<Boolean> convertVarArgs) {
        block0: for (Method method : methods) {
            if (!methodName.equals(method.getName())) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!method.isVarArgs() && parameterTypes.length != arguments.length) continue;
            convertVarArgs.set((Object)false);
            int parameterTypesLength = parameterTypes.length;
            for (int i = 0; i < arguments.length; ++i) {
                Class<?> componentType;
                Class<?> type = PatternCompilerImpl.getNonPrimitiveType(i < parameterTypesLength ? parameterTypes[i] : parameterTypes[parameterTypesLength - 1]);
                Object argument = arguments[i];
                Class<?> clazz = componentType = method.isVarArgs() && i < parameterTypesLength - 1 ? null : parameterTypes[parameterTypesLength - 1].getComponentType();
                if (argument == null || type.isInstance(argument)) continue;
                if (componentType == null || !componentType.isInstance(argument)) continue block0;
                convertVarArgs.set((Object)true);
            }
            if (parameterTypes.length > arguments.length) {
                convertVarArgs.set((Object)true);
            }
            return method;
        }
        return null;
    }

    public String dumpContextDeclarations() {
        StringBuilder sb = new StringBuilder();
        THashMap classes = new THashMap();
        THashSet missingClasses = new THashSet();
        classes.put(Object.class, (Object)missingClasses);
        for (Method method : this.myStaticMethods) {
            for (Class<?> type = method.getReturnType(); type != null && ElementPattern.class.isAssignableFrom(type); type = type.getSuperclass()) {
                Class<?> enclosingClass = type.getEnclosingClass();
                if (enclosingClass != null) {
                    Collection list = (Collection)classes.get(enclosingClass);
                    if (list == null) {
                        list = new THashSet();
                        classes.put(enclosingClass, (Object)list);
                    }
                    list.add(type);
                    continue;
                }
                if (classes.containsKey(type)) continue;
                classes.put(type, null);
            }
        }
        for (Class aClass : classes.keySet()) {
            if (aClass == Object.class) continue;
            PatternCompilerImpl.printClass(aClass, (Map<Class, Collection<Class>>)classes, sb);
        }
        for (Method method : this.myStaticMethods) {
            PatternCompilerImpl.printMethodDeclaration(method, sb, (Map<Class, Collection<Class>>)classes);
        }
        for (Class aClass : missingClasses) {
            sb.append("class ").append(aClass.getSimpleName());
            Class superclass = aClass.getSuperclass();
            if (missingClasses.contains(superclass)) {
                sb.append(" extends ").append(superclass.getSimpleName());
            }
            sb.append("{}\n");
        }
        return sb.toString();
    }

    private static void printClass(Class aClass, Map<Class, Collection<Class>> classes, StringBuilder sb) {
        boolean isInterface = aClass.isInterface();
        sb.append(isInterface ? "interface " : "class ");
        PatternCompilerImpl.dumpType(aClass, aClass, sb, classes);
        Type superClass = aClass.getGenericSuperclass();
        Class rawSuperClass = (Class)(superClass instanceof ParameterizedType ? ((ParameterizedType)superClass).getRawType() : superClass);
        if (superClass != null && classes.containsKey(rawSuperClass)) {
            sb.append(" extends ");
            PatternCompilerImpl.dumpType(null, superClass, sb, classes);
        }
        int implementsIdx = 1;
        for (Type superInterface : aClass.getGenericInterfaces()) {
            Class rawSuperInterface = (Class)(superInterface instanceof ParameterizedType ? ((ParameterizedType)superInterface).getRawType() : superClass);
            if (!classes.containsKey(rawSuperInterface)) continue;
            if (implementsIdx++ == 1) {
                sb.append(isInterface ? " extends " : " implements ");
            } else {
                sb.append(", ");
            }
            PatternCompilerImpl.dumpType(null, superInterface, sb, classes);
        }
        sb.append(" {\n");
        for (Method method : aClass.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || Modifier.isVolatile(method.getModifiers())) continue;
            PatternCompilerImpl.printMethodDeclaration(method, sb.append("  "), classes);
        }
        Collection<Class> innerClasses = classes.get(aClass);
        sb.append("}\n");
        if (innerClasses != null) {
            for (Class innerClass : innerClasses) {
                PatternCompilerImpl.printClass(innerClass, classes, sb);
            }
        }
    }

    private static void dumpType(GenericDeclaration owner, Type type, StringBuilder sb, Map<Class, Collection<Class>> classes) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            Class<?> enclosingClass = aClass.getEnclosingClass();
            if (enclosingClass != null) {
                sb.append(enclosingClass.getSimpleName()).append("_");
            } else if (!(aClass.isArray() || aClass.isPrimitive() || aClass.getName().startsWith("java.") || classes.containsKey(aClass))) {
                classes.get(Object.class).add(aClass);
            }
            sb.append(aClass.getSimpleName());
            if (owner == aClass) {
                PatternCompilerImpl.dumpTypeParametersArray(owner, aClass.getTypeParameters(), sb, "<", ">", classes);
            }
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            sb.append(typeVariable.getName());
            if (typeVariable.getGenericDeclaration() == owner) {
                PatternCompilerImpl.dumpTypeParametersArray(null, typeVariable.getBounds(), sb, " extends ", "", classes);
            }
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            sb.append("?");
            PatternCompilerImpl.dumpTypeParametersArray(owner, wildcardType.getUpperBounds(), sb, " extends ", "", classes);
            PatternCompilerImpl.dumpTypeParametersArray(owner, wildcardType.getLowerBounds(), sb, " super ", "", classes);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type raw = parameterizedType.getRawType();
            PatternCompilerImpl.dumpType(null, raw, sb, classes);
            PatternCompilerImpl.dumpTypeParametersArray(owner, parameterizedType.getActualTypeArguments(), sb, "<", ">", classes);
        } else if (type instanceof GenericArrayType) {
            PatternCompilerImpl.dumpType(owner, ((GenericArrayType)type).getGenericComponentType(), sb, classes);
            sb.append("[]");
        }
    }

    private static void dumpTypeParametersArray(GenericDeclaration owner, Type[] typeVariables, StringBuilder sb, String prefix, String suffix, Map<Class, Collection<Class>> classes) {
        int typeVarIdx = 1;
        for (Type typeVariable : typeVariables) {
            if (typeVariable == Object.class) continue;
            if (typeVarIdx++ == 1) {
                sb.append(prefix);
            } else {
                sb.append(", ");
            }
            PatternCompilerImpl.dumpType(owner, typeVariable, sb, classes);
        }
        if (typeVarIdx > 1) {
            sb.append(suffix);
        }
    }

    private static void printMethodDeclaration(Method method, StringBuilder sb, Map<Class, Collection<Class>> classes) {
        if (Modifier.isStatic(method.getModifiers())) {
            sb.append("static ");
        }
        PatternCompilerImpl.dumpTypeParametersArray(method, method.getTypeParameters(), sb, "<", "> ", classes);
        PatternCompilerImpl.dumpType(null, method.getGenericReturnType(), sb, classes);
        sb.append(" ").append(method.getName()).append("(");
        int paramIdx = 1;
        for (Type parameter : method.getGenericParameterTypes()) {
            if (paramIdx != 1) {
                sb.append(", ");
            }
            PatternCompilerImpl.dumpType(null, parameter, sb, classes);
            sb.append(" ").append("p").append(paramIdx++);
        }
        sb.append(")");
        if (!method.getDeclaringClass().isInterface()) {
            sb.append("{}");
        }
        sb.append("\n");
    }

    public class LazyPresentablePattern<T>
    implements ElementPattern<T> {
        private ElementPattern<T> myCompiledPattern;
        private final Node myNode;
        private final long myHashCode;

        public LazyPresentablePattern(Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/patterns/compiler/PatternCompilerImpl$LazyPresentablePattern", "<init>"));
            }
            this.myNode = node;
            this.myHashCode = StringHash.calc((String)this.toString());
        }

        public boolean accepts(@Nullable Object o) {
            return this.getCompiledPattern().accepts(o, new ProcessingContext());
        }

        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return this.getCompiledPattern().accepts(o, context);
        }

        public ElementPatternCondition<T> getCondition() {
            return this.getCompiledPattern().getCondition();
        }

        public ElementPattern<T> getCompiledPattern() {
            if (this.myCompiledPattern == null) {
                ElementPattern result;
                try {
                    result = this.compile();
                }
                catch (Throwable throwable) {
                    LOG.warn(this.toString(), throwable);
                    result = ALWAYS_FALSE;
                }
                this.myCompiledPattern = result;
            }
            return this.myCompiledPattern;
        }

        public ElementPattern<?> compile() throws Throwable {
            return this.myNode.target == ERROR_NODE ? ALWAYS_FALSE : (ElementPattern)this.execute(this.myNode);
        }

        public String toString() {
            return this.toString(this.myNode, new StringBuilder()).toString();
        }

        private StringBuilder toString(Node node, StringBuilder sb) {
            if (node.target == ERROR_NODE) {
                return sb.append(node.method);
            }
            if (node.target != null) {
                this.toString(node.target, sb);
                sb.append('.');
            }
            sb.append(node.method).append('(');
            boolean first = true;
            for (Object arg : node.args) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',').append(' ');
                }
                if (arg instanceof Node) {
                    this.toString((Node)arg, sb);
                    continue;
                }
                if (arg instanceof String) {
                    sb.append('\"').append(StringUtil.escapeStringCharacters((String)((String)arg))).append('\"');
                    continue;
                }
                if (!(arg instanceof Number)) continue;
                sb.append(arg);
            }
            sb.append(')');
            return sb;
        }

        private Object execute(Node node) throws Throwable {
            Object[] args;
            Object target = node.target != null ? this.execute(node.target) : null;
            String methodName = node.method;
            if (node.args.length == 0) {
                args = node.args;
            } else {
                args = new Object[node.args.length];
                int len = node.args.length;
                for (int i = 0; i < len; ++i) {
                    args[i] = node.args[i] instanceof Node ? this.execute((Node)node.args[i]) : node.args[i];
                }
            }
            return PatternCompilerImpl.invokeMethod(target, methodName, args, PatternCompilerImpl.this.myStaticMethods);
        }

        public int hashCode() {
            return (int)this.myHashCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof LazyPresentablePattern && ((LazyPresentablePattern)obj).myHashCode == this.myHashCode;
        }
    }

    private static class FalsePattern
    extends InitialPatternCondition<Object>
    implements ElementPattern<Object> {
        private final ElementPatternCondition<Object> myCondition = new ElementPatternCondition((InitialPatternCondition)this);

        protected FalsePattern() {
            super(Object.class);
        }

        public boolean accepts(@Nullable Object o) {
            return false;
        }

        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return false;
        }

        public ElementPatternCondition<Object> getCondition() {
            return this.myCondition;
        }
    }

    private static class Node {
        final Node target;
        final String method;
        final Object[] args;

        private Node(Node target, String method, Object[] args) {
            this.target = target;
            this.method = method;
            this.args = args;
        }
    }

    private static class Frame {
        State state = State.init;
        Object target;
        String methodName;
        ArrayList<Object> params = new ArrayList();

        private Frame() {
        }
    }

    private static enum State {
        init,
        name,
        name_end,
        param_start,
        param_end,
        literal,
        escape,
        invoke,
        invoke_end;

    }
}

