/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.element;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.filters.ElementFilter;
import org.jetbrains.annotations.Nullable;

public class ExcludeSillyAssignment
implements ElementFilter {
    @Nullable
    public static PsiReferenceExpression getAssignedReference(PsiElement position) {
        for (PsiElement each = position; each != null && !(each instanceof PsiFile); each = each.getContext()) {
            if (each instanceof PsiExpressionList || each instanceof PsiPrefixExpression || each instanceof PsiPolyadicExpression) {
                return null;
            }
            if (!(each instanceof PsiAssignmentExpression)) continue;
            PsiExpression left = ((PsiAssignmentExpression)each).getLExpression();
            if (left instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)left;
                PsiElement qualifier = referenceExpression.getQualifier();
                if (!(qualifier == null || qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null)) {
                    return null;
                }
                return referenceExpression;
            }
            return null;
        }
        return null;
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (!(element instanceof PsiElement)) {
            return true;
        }
        PsiReferenceExpression referenceExpression = ExcludeSillyAssignment.getAssignedReference(context);
        return referenceExpression == null || !referenceExpression.isReferenceTo((PsiElement)element);
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }
}

