/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.search.MethodUsagesSearcher;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters p, final @NotNull Processor<PsiClass> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        final PsiClass aClass = p.getClassToProcess();
        SearchScope useScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return aClass.getUseScope();
            }
        });
        String qualifiedName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return aClass.getQualifiedName();
            }
        });
        final Project project2 = PsiUtilCore.getProjectInReadAction((PsiElement)aClass);
        if ("java.lang.Object".equals(qualifiedName)) {
            return AllClassesSearch.search((SearchScope)useScope, (Project)project2).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    ProgressManager.checkCanceled();
                    if (psiClass.isInterface()) {
                        return consumer.process((Object)psiClass);
                    }
                    final PsiClass superClass = psiClass.getSuperClass();
                    if (superClass != null && "java.lang.Object".equals(ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                        public String compute() {
                            return superClass.getQualifiedName();
                        }
                    }))) {
                        return consumer.process((Object)psiClass);
                    }
                    return true;
                }
            });
        }
        final GlobalSearchScope scope = useScope instanceof GlobalSearchScope ? (GlobalSearchScope)useScope : new EverythingGlobalScope(project2);
        final String searchKey = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return aClass.getName();
            }
        });
        if (StringUtil.isEmpty((String)searchKey)) {
            return true;
        }
        Collection<PsiReferenceList> candidates = MethodUsagesSearcher.resolveInReadAction(project2, new Computable<Collection<PsiReferenceList>>(){

            public Collection<PsiReferenceList> compute() {
                return JavaSuperClassNameOccurenceIndex.getInstance().get(searchKey, project2, scope);
            }
        });
        HashMap classes = new HashMap();
        for (final PsiReferenceList psiReferenceList : candidates) {
            ProgressManager.checkCanceled();
            final PsiClass psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

                public PsiElement compute() {
                    return psiReferenceList.getParent();
                }
            });
            if (!JavaDirectInheritorsSearcher.checkInheritance(p, aClass, psiClass, project2)) continue;
            String fqn = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return psiClass.getQualifiedName();
                }
            });
            ArrayList<PsiClass> list = (ArrayList<PsiClass>)classes.get(fqn);
            if (list == null) {
                list = new ArrayList<PsiClass>();
                classes.put(fqn, list);
            }
            list.add(psiClass);
        }
        if (!classes.isEmpty()) {
            VirtualFile jarFile = JavaDirectInheritorsSearcher.getJarFile(aClass);
            for (List list : classes.values()) {
                ProgressManager.checkCanceled();
                if (JavaDirectInheritorsSearcher.processSameNamedClasses(consumer, list, jarFile)) continue;
                return false;
            }
        }
        if (p.includeAnonymous()) {
            Collection<PsiAnonymousClass> anonymousCandidates = MethodUsagesSearcher.resolveInReadAction(project2, new Computable<Collection<PsiAnonymousClass>>(){

                public Collection<PsiAnonymousClass> compute() {
                    return JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(searchKey, project2, scope);
                }
            });
            for (PsiAnonymousClass psiAnonymousClass : anonymousCandidates) {
                ProgressManager.checkCanceled();
                if (!JavaDirectInheritorsSearcher.checkInheritance(p, aClass, (PsiClass)psiAnonymousClass, project2) || consumer.process((Object)psiAnonymousClass)) continue;
                return false;
            }
            boolean bl = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return aClass.isEnum();
                }
            });
            if (bl) {
                PsiField[] psiFieldArray;
                for (final PsiField field : psiFieldArray = (PsiField[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiField[]>(){

                    public PsiField[] compute() {
                        return aClass.getFields();
                    }
                })) {
                    PsiEnumConstantInitializer initializingClass;
                    ProgressManager.checkCanceled();
                    if (!(field instanceof PsiEnumConstant) || (initializingClass = (PsiEnumConstantInitializer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiEnumConstantInitializer>(){

                        public PsiEnumConstantInitializer compute() {
                            return ((PsiEnumConstant)field).getInitializingClass();
                        }
                    })) == null || consumer.process((Object)initializingClass)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkInheritance(final DirectClassInheritorsSearch.SearchParameters p, final PsiClass aClass, final PsiClass candidate, Project project2) {
        return MethodUsagesSearcher.resolveInReadAction(project2, new Computable<Boolean>(){

            public Boolean compute() {
                return !p.isCheckInheritance() || candidate.isInheritor(aClass, false);
            }
        });
    }

    private static boolean processSameNamedClasses(Processor<PsiClass> consumer, List<PsiClass> sameNamedClasses, VirtualFile jarFile) {
        boolean sameJarClassFound = false;
        if (jarFile != null && sameNamedClasses.size() > 1) {
            for (PsiClass sameNamedClass : sameNamedClasses) {
                ProgressManager.checkCanceled();
                boolean fromSameJar = Comparing.equal((Object)JavaDirectInheritorsSearcher.getJarFile(sameNamedClass), (Object)jarFile);
                if (!fromSameJar) continue;
                sameJarClassFound = true;
                if (consumer.process((Object)sameNamedClass)) continue;
                return false;
            }
        }
        return sameJarClassFound || ContainerUtil.process(sameNamedClasses, consumer);
    }

    private static VirtualFile getJarFile(final PsiClass aClass) {
        return (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return PsiUtil.getJarFile((PsiElement)aClass);
            }
        });
    }
}

