/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLReference
implements PsiReference,
EmptyResolveMessageProvider {
    @NonNls
    public static final String TARGET_NAMESPACE_ATTR_NAME = "targetNamespace";
    private final PsiElement myElement;
    private final TextRange myRange;
    private final boolean mySoft;
    private boolean myIncorrectResourceMapped;

    public URLReference(PsiElement element) {
        this(element, null, false);
    }

    public URLReference(PsiElement element, @Nullable TextRange range, boolean soft) {
        this.myElement = element;
        this.myRange = range;
        this.mySoft = soft;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRange != null ? this.myRange : ElementManipulators.getValueTextRange((PsiElement)this.myElement);
    }

    @Nullable
    public PsiElement resolve() {
        PsiFile file2;
        this.myIncorrectResourceMapped = false;
        final String canonicalText = this.getCanonicalText();
        if (canonicalText.isEmpty()) {
            XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlAttribute.class);
            if (attr != null && attr.isNamespaceDeclaration() && attr.getNamespacePrefix().isEmpty() || ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(canonicalText)) {
                return this.myElement;
            }
            return null;
        }
        if (ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(canonicalText)) {
            return this.myElement;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
        if (tag != null && canonicalText.equals(tag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME))) {
            return tag;
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        if (tag != null && tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance") == null && (file2 = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, containingFile, tag.getAttributeValue("version"))) != null) {
            return file2;
        }
        if (containingFile instanceof XmlFile) {
            XmlDocument document = ((XmlFile)containingFile).getDocument();
            assert (document != null);
            XmlTag rootTag = document.getRootTag();
            if (rootTag == null) {
                return ExternalResourceManager.getInstance().getResourceLocation(canonicalText, containingFile, null);
            }
            XmlNSDescriptor nsDescriptor = rootTag.getNSDescriptor(canonicalText, true);
            if (nsDescriptor != null) {
                return nsDescriptor.getDescriptorFile();
            }
            String url = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, this.myElement.getProject());
            if (!url.equals(canonicalText)) {
                this.myIncorrectResourceMapped = true;
                return null;
            }
            if (tag == rootTag && (tag.getNamespace().equals("http://www.w3.org/2001/XMLSchema") || tag.getNamespace().equals("http://schemas.xmlsoap.org/wsdl/"))) {
                for (XmlTag t : tag.getSubTags()) {
                    String name = t.getLocalName();
                    if ("import".equals(name)) {
                        if (!canonicalText.equals(t.getAttributeValue("namespace"))) continue;
                        return t;
                    }
                    if (!"include".equals(name) && !"redefine".equals(name) && !"annotation".equals(name)) break;
                }
            }
            final PsiElement[] result = new PsiElement[1];
            URLReference.processWsdlSchemas(rootTag, new Processor<XmlTag>(){

                public boolean process(XmlTag t) {
                    if (canonicalText.equals(t.getAttributeValue(URLReference.TARGET_NAMESPACE_ATTR_NAME))) {
                        result[0] = t;
                        return false;
                    }
                    for (XmlTag anImport : t.findSubTags("import", t.getNamespace())) {
                        XmlAttribute location;
                        if (!canonicalText.equals(anImport.getAttributeValue("namespace")) || (location = anImport.getAttribute("schemaLocation")) == null) continue;
                        result[0] = FileReferenceUtil.findFile((PsiElement)location.getValueElement());
                    }
                    return true;
                }
            });
            return result[0];
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String text = this.myElement.getText();
        if (text.length() > 1) {
            String string = this.myRange == null ? text.substring(1, text.length() - 1) : this.myRange.substring(text);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference", "getCanonicalText"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference", "getCanonicalText"));
        }
        return "";
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        TextRange textRangeInElement = this.getRangeInElement();
        PsiElement elementToChange = this.myElement.findElementAt(textRangeInElement.getStartOffset());
        assert (elementToChange != null);
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)elementToChange);
        assert (manipulator != null);
        int offsetFromStart = this.myElement.getTextRange().getStartOffset() + textRangeInElement.getStartOffset() - elementToChange.getTextOffset();
        manipulator.handleContentChange(elementToChange, new TextRange(offsetFromStart, offsetFromStart + textRangeInElement.getLength()), newElementName);
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference", "bindToElement"));
        }
        assert (element instanceof PsiFile);
        if (!XmlUtil.isUrlText(this.getCanonicalText(), element.getProject())) {
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            assert (virtualFile != null);
            this.handleElementRename(VfsUtilCore.fixIDEAUrl((String)virtualFile.getPresentableUrl()));
        }
        return this.myElement;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    public boolean isSchemaLocation() {
        return false;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = XmlErrorMessages.message(this.myIncorrectResourceMapped ? "registered.resource.is.not.recognized" : "uri.is.not.registered", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    public static void processWsdlSchemas(XmlTag rootTag, Processor<XmlTag> processor2) {
        String nsPrefix;
        String types;
        XmlTag subTag;
        if ("definitions".equals(rootTag.getLocalName()) && (subTag = rootTag.findFirstSubTag(types = (nsPrefix = rootTag.getNamespacePrefix()).isEmpty() ? "types" : nsPrefix + ":types")) != null) {
            for (int i = 0; i < XmlUtil.SCHEMA_URIS.length; ++i) {
                XmlTag[] tags;
                for (XmlTag t : tags = subTag.findSubTags("schema", XmlUtil.SCHEMA_URIS[i])) {
                    if (processor2.process((Object)t)) continue;
                    return;
                }
            }
        }
    }
}

