/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.introduceParameter.InplaceIntroduceParameterUI;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.JavaIntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.ui.JBColor;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceIntroduceParameterPopup
extends AbstractJavaInplaceIntroducer {
    private static final Logger LOG = Logger.getInstance((String)("#" + InplaceIntroduceParameterPopup.class.getName()));
    private final PsiMethod myMethod;
    private final PsiMethod myMethodToSearchFor;
    private final boolean myMustBeFinal;
    private int myParameterIndex = -1;
    private final InplaceIntroduceParameterUI myPanel;

    InplaceIntroduceParameterPopup(Project project2, Editor editor, TypeSelectorManagerImpl typeSelectorManager, PsiExpression expr, PsiLocalVariable localVar, PsiMethod method, PsiMethod methodToSearchFor, PsiExpression[] occurrences, TIntArrayList parametersToRemove, boolean mustBeFinal) {
        super(project2, editor, expr, (PsiVariable)localVar, occurrences, typeSelectorManager, IntroduceParameterHandler.REFACTORING_NAME);
        this.myMethod = method;
        this.myMethodToSearchFor = methodToSearchFor;
        this.myMustBeFinal = mustBeFinal;
        this.myWholePanel.add((Component)this.getPreviewComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.myPanel = new InplaceIntroduceParameterUI(project2, localVar, expr, method, parametersToRemove, typeSelectorManager, (PsiExpression[])this.myOccurrences){

            @Override
            protected PsiParameter getParameter() {
                return InplaceIntroduceParameterPopup.this.getParameter();
            }

            @Override
            protected void updateControls(JCheckBox[] removeParamsCb) {
                super.updateControls(removeParamsCb);
                if (InplaceIntroduceParameterPopup.this.myParameterIndex < 0) {
                    return;
                }
                InplaceIntroduceParameterPopup.this.restartInplaceIntroduceTemplate();
            }

            @Override
            protected TIntArrayList getParametersToRemove() {
                TIntArrayList parameters = new TIntArrayList();
                if (this.myCbReplaceAllOccurences == null || this.myCbReplaceAllOccurences.isSelected()) {
                    for (int i = 0; i < this.myParametersToRemove.length; ++i) {
                        if (this.myParametersToRemove[i] == null) continue;
                        parameters.add(i);
                    }
                }
                return parameters;
            }
        };
        this.myPanel.appendOccurrencesDelegate(this.myWholePanel);
    }

    @Override
    protected PsiVariable createFieldToStartTemplateOn(final String[] names, final PsiType defaultType) {
        final PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject());
        return (PsiVariable)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiParameter>(){

            public PsiParameter compute() {
                PsiParameter anchor = JavaIntroduceParameterMethodUsagesProcessor.getAnchorParameter(InplaceIntroduceParameterPopup.this.myMethod);
                PsiParameter psiParameter = (PsiParameter)InplaceIntroduceParameterPopup.this.myMethod.getParameterList().addAfter((PsiElement)elementFactory.createParameter(InplaceIntroduceParameterPopup.this.chooseName(names, InplaceIntroduceParameterPopup.this.myMethod.getLanguage()), defaultType), (PsiElement)anchor);
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiParameter, (String)"final", (boolean)InplaceIntroduceParameterPopup.this.myPanel.hasFinalModifier());
                InplaceIntroduceParameterPopup.this.myParameterIndex = InplaceIntroduceParameterPopup.this.myMethod.getParameterList().getParameterIndex(psiParameter);
                return psiParameter;
            }
        });
    }

    @Override
    protected PsiElement checkLocalScope() {
        return this.myMethod;
    }

    @Override
    protected SearchScope getReferencesSearchScope(VirtualFile file2) {
        return new LocalSearchScope((PsiElement)this.myMethod);
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.PARAMETER;
    }

    @Override
    protected String[] suggestNames(PsiType defaultType, String propName) {
        return IntroduceParameterHandler.createNameSuggestionGenerator((PsiExpression)((PsiExpression)this.myExpr), (String)propName, (Project)this.myProject, null).getSuggestedNameInfo((PsiType)defaultType).names;
    }

    @Nullable
    private PsiParameter getParameter() {
        if (!this.myMethod.isValid()) {
            return null;
        }
        PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
        return parameters.length > this.myParameterIndex && this.myParameterIndex >= 0 ? parameters[this.myParameterIndex] : null;
    }

    @Override
    protected JComponent getComponent() {
        return this.myWholePanel;
    }

    @Override
    public boolean isReplaceAllOccurrences() {
        return this.myPanel.isReplaceAllOccurences();
    }

    @Override
    protected PsiVariable getVariable() {
        return this.getParameter();
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler2, PsiElement element) {
        return handler2 instanceof IntroduceParameterHandler && super.startsOnTheSameElement(handler2, element);
    }

    @Override
    protected void saveSettings(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/introduceParameter/InplaceIntroduceParameterPopup", "saveSettings"));
        }
        this.myPanel.saveSettings(JavaRefactoringSettings.getInstance());
    }

    @Override
    protected void performIntroduce() {
        boolean isDeleteLocalVariable = false;
        PsiExpression parameterInitializer = (PsiExpression)this.myExpr;
        if (this.getLocalVariable() != null) {
            if (this.myPanel.isUseInitializer()) {
                parameterInitializer = ((PsiVariable)this.getLocalVariable()).getInitializer();
            }
            isDeleteLocalVariable = this.myPanel.isDeleteLocalVariable();
        }
        final TIntArrayList parametersToRemove = this.myPanel.getParametersToRemove();
        final IntroduceParameterProcessor processor2 = new IntroduceParameterProcessor(this.myProject, this.myMethod, this.myMethodToSearchFor, parameterInitializer, (PsiExpression)this.myExpr, (PsiLocalVariable)this.getLocalVariable(), isDeleteLocalVariable, this.getInputName(), this.myPanel.isReplaceAllOccurences(), this.myPanel.getReplaceFieldsWithGetters(), this.myMustBeFinal || this.myPanel.isGenerateFinal(), this.isGenerateDelegate(), this.getType(), parametersToRemove);
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                Runnable performRefactoring = new Runnable(){

                    @Override
                    public void run() {
                        processor2.setPrepareSuccessfulSwingThreadCallback(new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                        processor2.run();
                        InplaceIntroduceParameterPopup.this.normalizeParameterIdxAccordingToRemovedParams(parametersToRemove);
                        PsiParameter parameter = InplaceIntroduceParameterPopup.this.getParameter();
                        if (parameter != null) {
                            InplaceIntroduceParameterPopup.super.saveSettings((PsiVariable)parameter);
                        }
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    performRefactoring.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(performRefactoring);
                }
            }
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, this.getCommandName(), null);
    }

    public boolean isGenerateDelegate() {
        return this.myPanel.isGenerateDelegate();
    }

    @Override
    protected void updateTitle(@Nullable PsiVariable variable) {
        if (variable == null) {
            return;
        }
        this.updateTitle(variable, variable.getName());
    }

    @Override
    protected void updateTitle(@Nullable PsiVariable variable, String value) {
        PsiElement declarationScope;
        PsiElement psiElement = declarationScope = variable != null ? ((PsiParameter)variable).getDeclarationScope() : null;
        if (declarationScope instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)declarationScope;
            StringBuilder buf = new StringBuilder();
            buf.append(psiMethod.getName()).append(" (");
            boolean frst = true;
            ArrayList<TextRange> ranges2Remove = new ArrayList<TextRange>();
            TextRange addedRange = null;
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                if (frst) {
                    frst = false;
                } else {
                    buf.append(", ");
                }
                int startOffset = buf.length();
                if (this.myMustBeFinal || this.myPanel.isGenerateFinal()) {
                    buf.append("final ");
                }
                buf.append(parameter.getType().getPresentableText()).append(" ").append(variable == parameter ? value : parameter.getName());
                int endOffset = buf.length();
                if (variable == parameter) {
                    addedRange = new TextRange(startOffset, endOffset);
                    continue;
                }
                if (!this.myPanel.isParamToRemove(parameter)) continue;
                ranges2Remove.add(new TextRange(startOffset, endOffset));
            }
            buf.append(")");
            this.setPreviewText(buf.toString());
            MarkupModel markupModel = DocumentMarkupModel.forDocument(this.getPreviewEditor().getDocument(), this.myProject, true);
            markupModel.removeAllHighlighters();
            for (TextRange textRange : ranges2Remove) {
                markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 0, InplaceIntroduceParameterPopup.getTestAttributesForRemoval(), HighlighterTargetArea.EXACT_RANGE);
            }
            markupModel.addRangeHighlighter(addedRange.getStartOffset(), addedRange.getEndOffset(), 0, InplaceIntroduceParameterPopup.getTextAttributesForAdd(), HighlighterTargetArea.EXACT_RANGE);
            this.revalidate();
        }
    }

    private static TextAttributes getTextAttributesForAdd() {
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setEffectType(EffectType.ROUNDED_BOX);
        textAttributes.setEffectColor((Color)JBColor.RED);
        return textAttributes;
    }

    private static TextAttributes getTestAttributesForRemoval() {
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setEffectType(EffectType.STRIKEOUT);
        textAttributes.setEffectColor(Color.BLACK);
        return textAttributes;
    }

    @Override
    protected String getActionName() {
        return "IntroduceParameter";
    }

    private void normalizeParameterIdxAccordingToRemovedParams(TIntArrayList parametersToRemove) {
        parametersToRemove.forEach(new TIntProcedure(){

            public boolean execute(int value) {
                if (InplaceIntroduceParameterPopup.this.myParameterIndex >= value) {
                    InplaceIntroduceParameterPopup.this.myParameterIndex--;
                }
                return true;
            }
        });
    }

    @Override
    public void setReplaceAllOccurrences(boolean replaceAll) {
        this.myPanel.setReplaceAllOccurrences(replaceAll);
    }

    public PsiMethod getMethodToIntroduceParameter() {
        return this.myMethod;
    }

    public PsiMethod getMethodToSearchFor() {
        return this.myMethodToSearchFor;
    }
}

