/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;

public class FinalListener {
    private final Editor myEditor;
    private static final Logger LOG = Logger.getInstance((String)("#" + FinalListener.class.getName()));

    public FinalListener(Editor editor) {
        this.myEditor = editor;
    }

    public void perform(boolean generateFinal, PsiVariable variable) {
        this.perform(generateFinal, "final", variable);
    }

    public void perform(final boolean generateFinal, final String modifier, final PsiVariable variable) {
        final Document document = this.myEditor.getDocument();
        LOG.assertTrue(variable != null);
        final PsiModifierList modifierList = variable.getModifierList();
        LOG.assertTrue(modifierList != null);
        final int textOffset = modifierList.getTextOffset();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (generateFinal) {
                    PsiTypeElement typeElement = variable.getTypeElement();
                    int typeOffset = typeElement != null ? typeElement.getTextOffset() : textOffset;
                    document.insertString(typeOffset, (CharSequence)(modifier + " "));
                } else {
                    int idx = modifierList.getText().indexOf(modifier);
                    document.deleteString(textOffset + idx, textOffset + idx + modifier.length() + 1);
                }
            }
        };
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
        if (lookup != null) {
            lookup.performGuardedChange(runnable2);
        } else {
            runnable2.run();
        }
        PsiDocumentManager.getInstance((Project)variable.getProject()).commitDocument(document);
    }
}

