/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject.usageInfo;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;

public class BeanClassVisibilityUsageInfo
extends FixableUsageInfo {
    private final PsiClass existingClass;
    private final UsageInfo[] usages;
    private final String myNewVisibility;
    private final PsiMethod myExistingClassCompatibleConstructor;

    public BeanClassVisibilityUsageInfo(PsiClass existingClass, UsageInfo[] usages, String newVisibility, PsiMethod existingClassCompatibleConstructor) {
        super((PsiElement)existingClass);
        this.existingClass = existingClass;
        this.usages = usages;
        this.myNewVisibility = newVisibility;
        this.myExistingClassCompatibleConstructor = existingClassCompatibleConstructor;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        VisibilityUtil.fixVisibility((PsiElement[])UsageViewUtil.toElements(this.usages), (PsiMember)this.existingClass, (String)this.myNewVisibility);
        if (this.myExistingClassCompatibleConstructor != null) {
            VisibilityUtil.fixVisibility((PsiElement[])UsageViewUtil.toElements(this.usages), (PsiMember)this.myExistingClassCompatibleConstructor, (String)this.myNewVisibility);
        }
    }
}

