/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.Condition;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServersTreeAction<T extends ServersTreeNode>
extends AnAction {
    protected ServersTreeAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        boolean visible;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServersTreeAction", "update"));
        }
        Presentation presentation = e.getPresentation();
        List<T> targetNodes = this.getTargetNodes(e);
        if (targetNodes == null) {
            visible = false;
            enabled = false;
        } else {
            visible = true;
            enabled = true;
            for (ServersTreeNode targetNode : targetNodes) {
                enabled &= (visible &= this.isVisible4(targetNode)) && this.isEnabled4(targetNode);
            }
        }
        presentation.setVisible(visible);
        presentation.setEnabled(enabled);
        this.updatePresentation(presentation, (ServersTreeNode)ContainerUtil.getFirstItem(targetNodes));
    }

    private List<T> getTargetNodes(AnActionEvent e) {
        ServersToolWindowContent content = ServersTreeAction.getContent(e);
        if (content == null) {
            return null;
        }
        Set selectedElements = content.getBuilder().getSelectedElements();
        int selectionCount = selectedElements.size();
        if (selectionCount == 0 || selectionCount > 1 && !this.isMultiSelectionAllowed()) {
            return null;
        }
        Class<T> targetNodeClass = this.getTargetNodeClass();
        ArrayList<T> result = new ArrayList<T>();
        for (Object selectedElement : selectedElements) {
            ServersTreeNode node = (ServersTreeNode)selectedElement;
            if (!targetNodeClass.isInstance(node)) {
                return null;
            }
            result.add(targetNodeClass.cast(node));
        }
        return result;
    }

    private static ServersToolWindowContent getContent(AnActionEvent e) {
        return (ServersToolWindowContent)e.getData(ServersToolWindowContent.KEY);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServersTreeAction", "actionPerformed"));
        }
        List<T> targetNodes = this.getTargetNodes(e);
        if (targetNodes == null) {
            return;
        }
        List verifiedTargetNodes = ContainerUtil.filter(targetNodes, (Condition)new Condition<T>(){

            public boolean value(T targetNode) {
                return ServersTreeAction.this.isVisible4(targetNode) && ServersTreeAction.this.isEnabled4(targetNode);
            }
        });
        this.doActionPerformed(ServersTreeAction.getContent(e), e, (T)verifiedTargetNodes);
    }

    protected boolean isMultiSelectionAllowed() {
        return false;
    }

    protected boolean isVisible4(T node) {
        return true;
    }

    protected boolean isEnabled4(T node) {
        return true;
    }

    protected void updatePresentation(@NotNull Presentation presentation, @Nullable T node) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServersTreeAction", "updatePresentation"));
        }
    }

    protected void doActionPerformed(@NotNull ServersToolWindowContent content, AnActionEvent e, List<T> nodes) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServersTreeAction", "doActionPerformed"));
        }
        for (ServersTreeNode node : nodes) {
            this.doActionPerformed(content, e, node);
        }
    }

    protected void doActionPerformed(@NotNull ServersToolWindowContent content, AnActionEvent e, T node) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServersTreeAction", "doActionPerformed"));
        }
        this.doActionPerformed(node);
    }

    protected void doActionPerformed(T node) {
        throw new UnsupportedOperationException();
    }

    protected abstract Class<T> getTargetNodeClass();
}

