/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.actions.HighlightUsagesAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.TestActionEvent;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JList;
import junit.framework.ComparisonFailure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CodeInsightTestFixtureImpl
extends BaseFixture
implements CodeInsightTestFixture {
    private static final Function<IntentionAction, String> INTENTION_NAME_FUN = new Function<IntentionAction, String>(){

        public String fun(IntentionAction intentionAction) {
            return "\"" + intentionAction.getText() + "\"";
        }
    };
    private static final String START_FOLD = "<fold\\stext='[^']*'(\\sexpand='[^']*')*>";
    private static final String END_FOLD = "</fold>";
    private final IdeaProjectTestFixture myProjectFixture;
    private final TempDirTestFixture myTempDirFixture;
    private PsiManagerImpl myPsiManager;
    private VirtualFile myFile;
    private Editor myEditor;
    private String myTestDataPath;
    private boolean myEmptyLookup;
    private VirtualFileFilter myVirtualFileFilter;
    private boolean myAllowDirt;
    private boolean myCaresAboutInjection;

    public CodeInsightTestFixtureImpl(@NotNull IdeaProjectTestFixture projectFixture, @NotNull TempDirTestFixture tempDirTestFixture) {
        if (projectFixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFixture", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "<init>"));
        }
        if (tempDirTestFixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDirTestFixture", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "<init>"));
        }
        this.myVirtualFileFilter = new FileTreeAccessFilter();
        this.myCaresAboutInjection = true;
        this.myProjectFixture = projectFixture;
        this.myTempDirFixture = tempDirTestFixture;
    }

    @NotNull
    public static GlobalInspectionContextForTests createGlobalContextForTool(@NotNull AnalysisScope scope, final @NotNull Project project2, @NotNull InspectionManagerEx inspectionManager, final InspectionToolWrapper ... toolWrappers) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createGlobalContextForTool"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createGlobalContextForTool"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createGlobalContextForTool"));
        }
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createGlobalContextForTool"));
        }
        final InspectionProfileImpl profile = InspectionProfileImpl.createSimple("test", project2, toolWrappers);
        GlobalInspectionContextForTests context = new GlobalInspectionContextForTests(project2, inspectionManager.getContentManager()){

            @Override
            @NotNull
            protected List<Tools> getUsedTools() {
                List<Tools> list = InspectionProfileImpl.initAndDo(new Computable<List<Tools>>(){

                    public List<Tools> compute() {
                        for (InspectionToolWrapper tool : toolWrappers) {
                            profile.enableTool(tool.getShortName(), project2);
                        }
                        return profile.getAllEnabledInspectionTools(project2);
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$2", "getUsedTools"));
                }
                return list;
            }
        };
        context.setCurrentScope(scope);
        GlobalInspectionContextForTests globalInspectionContextForTests = context;
        if (globalInspectionContextForTests == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createGlobalContextForTool"));
        }
        return globalInspectionContextForTests;
    }

    private static void addGutterIconRenderer(GutterMark renderer, int offset, @NotNull SortedMap<Integer, List<GutterMark>> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "addGutterIconRenderer"));
        }
        if (renderer == null) {
            return;
        }
        List renderers = (List)result.get(offset);
        if (renderers == null) {
            renderers = new SmartList();
            result.put(offset, renderers);
        }
        renderers.add(renderer);
    }

    public static void configureInspections(@NotNull InspectionProfileEntry[] tools, final @NotNull Project project2, @NotNull Collection<String> disabledInspections, @NotNull Disposable parentDisposable) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureInspections"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureInspections"));
        }
        if (disabledInspections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledInspections", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureInspections"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureInspections"));
        }
        InspectionToolWrapper[] wrapped = (InspectionToolWrapper[])ContainerUtil.map2Array((Object[])tools, InspectionToolWrapper.class, (Function)new Function<InspectionProfileEntry, InspectionToolWrapper>(){

            public InspectionToolWrapper fun(InspectionProfileEntry tool) {
                return InspectionToolRegistrar.wrapTool(tool);
            }
        });
        final InspectionProfileImpl profile = InspectionProfileImpl.createSimple("Configurable", project2, wrapped);
        profile.disableToolByDefault(new ArrayList<String>(disabledInspections), project2);
        final InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        final Profile oldRootProfile = inspectionProfileManager.getRootProfile();
        inspectionProfileManager.addProfile(profile);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                inspectionProfileManager.deleteProfile(profile.getName());
                inspectionProfileManager.setRootProfile(oldRootProfile.getName());
                CodeInsightTestFixtureImpl.clearAllToolsIn(InspectionProfileImpl.getDefaultProfile(), project2);
            }
        });
        inspectionProfileManager.setRootProfile(profile.getName());
        InspectionProfileImpl.initAndDo(new Computable(){

            public Object compute() {
                InspectionProjectProfileManager.getInstance(project2).updateProfile(profile);
                InspectionProjectProfileManager.getInstance(project2).setProjectProfile(profile.getName());
                return null;
            }
        });
    }

    private static void clearAllToolsIn(@NotNull InspectionProfileImpl profile, @NotNull Project project2) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "clearAllToolsIn"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "clearAllToolsIn"));
        }
        List<ScopeToolState> tools = profile.getAllTools(project2);
        for (ScopeToolState state : tools) {
            InspectionToolWrapper wrapper = state.getTool();
            if (wrapper.getExtension() == null) continue;
            ReflectionUtil.resetField((Object)wrapper, InspectionProfileEntry.class, (String)"myTool");
        }
    }

    private static void removeDuplicatedRangesForInjected(@NotNull List<HighlightInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "removeDuplicatedRangesForInjected"));
        }
        Collections.sort(infos, new Comparator<HighlightInfo>(){

            @Override
            public int compare(@NotNull HighlightInfo o1, @NotNull HighlightInfo o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$6", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$6", "compare"));
                }
                int i = o2.startOffset - o1.startOffset;
                return i != 0 ? i : o1.getSeverity().myVal - o2.getSeverity().myVal;
            }
        });
        HighlightInfo prevInfo = null;
        Iterator<HighlightInfo> it = infos.iterator();
        while (it.hasNext()) {
            HighlightInfo info = it.next();
            if (prevInfo != null && info.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY && info.getDescription() == null && info.startOffset == prevInfo.startOffset && info.endOffset == prevInfo.endOffset) {
                it.remove();
            }
            prevInfo = info.type == HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT ? info : null;
        }
    }

    @NotNull
    public static List<HighlightInfo> instantiateAndRun(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull int[] toIgnore, boolean canChangeDocument) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "instantiateAndRun"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "instantiateAndRun"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "instantiateAndRun"));
        }
        Project project2 = file2.getProject();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project2);
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project2);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        ProcessCanceledException exception = null;
        for (int i = 0; i < 1000; ++i) {
            List<HighlightInfo> list;
            try {
                List<HighlightInfo> infos = codeAnalyzer.runPasses(file2, editor.getDocument(), textEditor, toIgnore, canChangeDocument, null);
                infos.addAll(DaemonCodeAnalyzerEx.getInstanceEx(project2).getFileLevelHighlights(project2, file2));
                list = infos;
            }
            catch (ProcessCanceledException e) {
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                UIUtil.dispatchAllInvocationEvents();
                exception = e;
                continue;
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "instantiateAndRun"));
            }
            return list;
        }
        throw exception;
    }

    public static void ensureIndexesUpToDate(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "ensureIndexesUpToDate"));
        }
        if (!DumbService.isDumb((Project)project2)) {
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project2, null);
            FileBasedIndex.getInstance().ensureUpToDate(TodoIndex.NAME, project2, null);
        }
    }

    @NotNull
    public static List<IntentionAction> getAvailableIntentions(final @NotNull Editor editor, final @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntentions"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntentions"));
        }
        List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<IntentionAction>>(){

            public List<IntentionAction> compute() {
                return CodeInsightTestFixtureImpl.doGetAvailableIntentions(editor, file2);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntentions"));
        }
        return list;
    }

    @NotNull
    private static List<IntentionAction> doGetAvailableIntentions(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "doGetAvailableIntentions"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "doGetAvailableIntentions"));
        }
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(editor, file2, intentions, -1);
        ArrayList<HighlightInfo.IntentionActionDescriptor> descriptors = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        descriptors.addAll(intentions.intentionsToShow);
        descriptors.addAll(intentions.errorFixesToShow);
        descriptors.addAll(intentions.inspectionFixesToShow);
        descriptors.addAll(intentions.guttersToShow);
        int fileOffset = editor.getCaretModel().getOffset();
        PsiElement hostElement = file2.getViewProvider().findElementAt(fileOffset, file2.getLanguage());
        PsiElement injectedElement = InjectedLanguageUtil.findElementAtNoCommit(file2, fileOffset);
        PsiFile injectedFile = injectedElement != null ? injectedElement.getContainingFile() : null;
        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        List<HighlightInfo> infos = DaemonCodeAnalyzerEx.getInstanceEx(file2.getProject()).getFileLevelHighlights(file2.getProject(), file2);
        for (HighlightInfo info : infos) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
                IntentionAction action = actionInGroup.getAction();
                if (!ShowIntentionActionsHandler.availableFor(file2, editor, action) && (injectedElement == null || hostElement == injectedElement || !ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action))) continue;
                descriptors.add(actionInGroup);
            }
        }
        for (HighlightInfo.IntentionActionDescriptor descriptor : descriptors) {
            List<IntentionAction> options;
            result.add(descriptor.getAction());
            if (injectedElement != null && injectedElement != hostElement && (options = descriptor.getOptions(injectedElement, injectedEditor)) != null) {
                for (IntentionAction option : options) {
                    if (!ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, option)) continue;
                    result.add(option);
                }
            }
            if (hostElement == null || (options = descriptor.getOptions(hostElement, editor)) == null) continue;
            for (IntentionAction option : options) {
                if (!ShowIntentionActionsHandler.availableFor(file2, editor, option)) continue;
                result.add(option);
            }
        }
        ArrayList<IntentionAction> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "doGetAvailableIntentions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string = this.myTempDirFixture.getTempDirPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getTempDirPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public TempDirTestFixture getTempDirFixture() {
        TempDirTestFixture tempDirTestFixture = this.myTempDirFixture;
        if (tempDirTestFixture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getTempDirFixture"));
        }
        return tempDirTestFixture;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath) {
        if (sourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "copyFileToProject"));
        }
        VirtualFile virtualFile = this.copyFileToProject(sourcePath, sourcePath);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "copyFileToProject"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        if (sourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "copyFileToProject"));
        }
        if (targetPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "copyFileToProject"));
        }
        String testDataPath = this.getTestDataPath();
        File sourceFile = FileUtil.findFirstThatExist((String[])new String[]{testDataPath + '/' + sourcePath, sourcePath});
        VirtualFile targetFile = this.myTempDirFixture.getFile(targetPath);
        if (sourceFile == null && targetFile != null && targetPath.equals(sourcePath)) {
            VirtualFile virtualFile = targetFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "copyFileToProject"));
            }
            return virtualFile;
        }
        Assert.assertNotNull((String)("Cannot find source file: " + sourcePath + "; test data path: " + testDataPath), (Object)sourceFile);
        Assert.assertTrue((String)("Not a file: " + sourceFile), (boolean)sourceFile.isFile());
        if (targetFile == null) {
            targetFile = this.myTempDirFixture.createFile(targetPath);
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(targetFile, sourcePath);
            targetFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, (Object)sourceFile.getAbsolutePath());
        }
        final File _source = sourceFile;
        final VirtualFile _target = targetFile;
        new WriteAction(){

            protected void run(@NotNull Result result) throws IOException {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$8", "run"));
                }
                _target.setBinaryContent(FileUtil.loadFileBytes((File)_source));
            }
        }.execute();
        VirtualFile virtualFile = targetFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "copyFileToProject"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyDirectoryToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        if (sourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "copyDirectoryToProject"));
        }
        if (targetPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "copyDirectoryToProject"));
        }
        String testDataPath = this.getTestDataPath();
        File fromFile = new File(testDataPath + "/" + sourcePath);
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            VirtualFile virtualFile = this.myTempDirFixture.copyAll(fromFile.getPath(), targetPath);
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "copyDirectoryToProject"));
            }
            return virtualFile;
        }
        File targetFile = new File(this.getTempDirPath() + "/" + targetPath);
        try {
            FileUtil.copyDir((File)fromFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(targetFile);
        Assert.assertNotNull((Object)file2);
        file2.refresh(false, true);
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "copyDirectoryToProject"));
        }
        return virtualFile;
    }

    @Override
    public void enableInspections(InspectionProfileEntry ... inspections) {
        if (inspections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspections", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "enableInspections"));
        }
        this.assertInitialized();
        for (InspectionProfileEntry inspection : inspections) {
            LightPlatformTestCase.enableInspectionTool(this.getProject(), InspectionToolRegistrar.wrapTool(inspection));
        }
    }

    @Override
    public void enableInspections(Class<? extends LocalInspectionTool> ... inspections) {
        if (inspections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspections", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "enableInspections"));
        }
        this.enableInspections(Arrays.asList(inspections));
    }

    @Override
    public void enableInspections(@NotNull Collection<Class<? extends LocalInspectionTool>> inspections) {
        if (inspections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspections", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "enableInspections"));
        }
        ArrayList<LocalInspectionTool> tools = new ArrayList<LocalInspectionTool>();
        for (Class<? extends LocalInspectionTool> clazz : inspections) {
            try {
                LocalInspectionTool inspection = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                tools.add(inspection);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instantiate " + clazz);
            }
        }
        this.enableInspections((InspectionProfileEntry[])tools.toArray(new LocalInspectionTool[tools.size()]));
    }

    @Override
    public void disableInspections(InspectionProfileEntry ... inspections) {
        if (inspections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspections", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "disableInspections"));
        }
        InspectionProfileImpl profile = (InspectionProfileImpl)InspectionProjectProfileManager.getInstance(this.getProject()).getInspectionProfile();
        for (InspectionProfileEntry inspection : inspections) {
            profile.disableTool(inspection.getShortName(), this.getProject());
        }
    }

    @Override
    public void enableInspections(InspectionToolProvider ... providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "enableInspections"));
        }
        ArrayList<LocalInspectionTool> tools = new ArrayList<LocalInspectionTool>();
        for (InspectionToolProvider provider : providers) {
            for (Class clazz : provider.getInspectionClasses()) {
                try {
                    Object o = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!(o instanceof LocalInspectionTool)) continue;
                    LocalInspectionTool inspection = (LocalInspectionTool)o;
                    tools.add(inspection);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate " + clazz, e);
                }
            }
        }
        this.enableInspections((InspectionProfileEntry[])tools.toArray(new LocalInspectionTool[tools.size()]));
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testHighlighting"));
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        try {
            return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testHighlightingAllFiles"));
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String path : filePaths) {
            files.add(this.copyFileToProject(path));
        }
        return this.testHighlightingAllFiles(checkWarnings, checkInfos, checkWeakWarnings, VfsUtilCore.toVirtualFileArray(files));
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testHighlightingAllFiles"));
        }
        return this.collectAndCheckHighlightings(checkWarnings, checkInfos, checkWeakWarnings, files);
    }

    private long collectAndCheckHighlightings(final boolean checkWarnings, final boolean checkInfos, final boolean checkWeakWarnings, @NotNull VirtualFile[] files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "collectAndCheckHighlightings"));
        }
        List datas = ContainerUtil.map2List((Object[])files, (Function)new Function<VirtualFile, Trinity<PsiFile, Editor, ExpectedHighlightingData>>(){

            public Trinity<PsiFile, Editor, ExpectedHighlightingData> fun(VirtualFile file2) {
                PsiFile psiFile = CodeInsightTestFixtureImpl.this.myPsiManager.findFile(file2);
                Assert.assertNotNull((Object)psiFile);
                Document document = PsiDocumentManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject()).getDocument(psiFile);
                Assert.assertNotNull((Object)document);
                ExpectedHighlightingData data = new ExpectedHighlightingData(document, checkWarnings, checkWeakWarnings, checkInfos, psiFile);
                data.init();
                return Trinity.create((Object)psiFile, (Object)CodeInsightTestFixtureImpl.this.createEditor(file2), (Object)data);
            }
        });
        long elapsed = 0L;
        for (Trinity trinity : datas) {
            this.myEditor = (Editor)trinity.second;
            this.myFile = ((PsiFile)trinity.first).getVirtualFile();
            elapsed += this.collectAndCheckHighlighting((ExpectedHighlightingData)trinity.third);
        }
        return elapsed;
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.checkHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        try {
            return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, ignoreExtraHighlighting);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long checkHighlighting() {
        return this.checkHighlighting(true, false, true);
    }

    @Override
    public long testHighlighting(String ... filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testHighlighting"));
        }
        return this.testHighlighting(true, false, true, filePaths);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testHighlighting"));
        }
        this.openFileInEditor(file2);
        try {
            return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public HighlightTestInfo testFile(String ... filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testFile"));
        }
        HighlightTestInfo highlightTestInfo = new HighlightTestInfo(this.getTestRootDisposable(), filePath){

            @Override
            public HighlightTestInfo doTest() {
                CodeInsightTestFixtureImpl.this.configureByFiles(this.filePaths);
                ExpectedHighlightingData data = new ExpectedHighlightingData(CodeInsightTestFixtureImpl.this.myEditor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos, CodeInsightTestFixtureImpl.this.getFile());
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                data.init();
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlighting(data);
                return this;
            }
        };
        if (highlightTestInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testFile"));
        }
        return highlightTestInfo;
    }

    @Override
    public void openFileInEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "openFileInEditor"));
        }
        this.myFile = file2;
        this.myEditor = this.createEditor(file2);
    }

    @Override
    public void testInspection(@NotNull String testDir, @NotNull InspectionToolWrapper toolWrapper) {
        if (testDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testDir", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testInspection"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testInspection"));
        }
        VirtualFile sourceDir = this.copyDirectoryToProject(new File(testDir, "src").getPath(), "src");
        PsiDirectory psiDirectory = this.getPsiManager().findDirectory(sourceDir);
        Assert.assertNotNull((Object)psiDirectory);
        AnalysisScope scope = new AnalysisScope(psiDirectory);
        scope.invalidate();
        InspectionManagerEx inspectionManager = (InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject());
        GlobalInspectionContextForTests globalContext = CodeInsightTestFixtureImpl.createGlobalContextForTool(scope, this.getProject(), inspectionManager, toolWrapper);
        InspectionTestUtil.runTool(toolWrapper, scope, globalContext);
        InspectionTestUtil.compareToolResults(globalContext, toolWrapper, false, new File(this.getTestDataPath(), testDir).getPath());
    }

    @Override
    @Nullable
    public PsiReference getReferenceAtCaretPosition(String ... filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getReferenceAtCaretPosition"));
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.getFile().findReferenceAt(this.myEditor.getCaretModel().getOffset());
    }

    @Override
    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String ... filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getReferenceAtCaretPositionWithAssertion"));
        }
        PsiReference reference = this.getReferenceAtCaretPosition(filePaths);
        Assert.assertNotNull((String)("no reference found at " + this.myEditor.getCaretModel().getLogicalPosition()), (Object)reference);
        PsiReference psiReference = reference;
        if (psiReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getReferenceAtCaretPositionWithAssertion"));
        }
        return psiReference;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions(String ... filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntentions"));
        }
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        List<IntentionAction> list = this.getAvailableIntentions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntentions"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAllQuickFixes(String ... filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAllQuickFixes"));
        }
        if (filePaths.length != 0) {
            this.configureByFilesInner(filePaths);
        }
        List<HighlightInfo> infos = this.doHighlighting();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (HighlightInfo info : infos) {
            if (info.quickFixActionRanges == null) continue;
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                actions.add(((HighlightInfo.IntentionActionDescriptor)pair.getFirst()).getAction());
            }
        }
        ArrayList<IntentionAction> arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAllQuickFixes"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions() {
        this.doHighlighting();
        PsiFile file2 = this.getFile();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageUtil.getTopLevelFile((PsiElement)file2);
        }
        Assert.assertNotNull((Object)file2);
        List<IntentionAction> list = CodeInsightTestFixtureImpl.getAvailableIntentions(editor, file2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntentions"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<IntentionAction> filterAvailableIntentions(final @NotNull String hint) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "filterAvailableIntentions"));
        }
        List<IntentionAction> availableIntentions = this.getAvailableIntentions();
        List list = ContainerUtil.findAll(availableIntentions, (Condition)new Condition<IntentionAction>(){

            public boolean value(IntentionAction intentionAction) {
                return intentionAction.getText().startsWith(hint);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "filterAvailableIntentions"));
        }
        return list;
    }

    @Override
    public IntentionAction findSingleIntention(@NotNull String hint) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findSingleIntention"));
        }
        List<IntentionAction> list = this.filterAvailableIntentions(hint);
        if (list.isEmpty()) {
            Assert.fail((String)("\"" + hint + "\" not in [" + StringUtil.join(this.getAvailableIntentions(), INTENTION_NAME_FUN, (String)", ") + "]"));
        } else if (list.size() > 1) {
            Assert.fail((String)("Too many intentions found for \"" + hint + "\": [" + StringUtil.join(list, INTENTION_NAME_FUN, (String)", ") + "]"));
        }
        return UsefulTestCase.assertOneElement(list);
    }

    @Override
    public IntentionAction getAvailableIntention(@NotNull String intentionName, String ... filePaths) {
        if (intentionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntention"));
        }
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntention"));
        }
        List<IntentionAction> intentions = this.getAvailableIntentions(filePaths);
        IntentionAction action = CodeInsightTestUtil.findIntentionByText(intentions, intentionName);
        if (action == null) {
            System.out.println(intentionName + " not found among " + StringUtil.join(intentions, (Function)new Function<IntentionAction, String>(){

                public String fun(IntentionAction action) {
                    return action.getText();
                }
            }, (String)","));
        }
        return action;
    }

    @Override
    public void launchAction(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "launchAction"));
        }
        ShowIntentionActionsHandler.chooseActionAndInvoke(this.getFile(), this.getEditor(), action, action.getText());
        UIUtil.dispatchAllInvocationEvents();
    }

    @Override
    public void testCompletion(@NotNull String[] filesBefore, @NotNull String fileAfter) {
        if (filesBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesBefore", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletion"));
        }
        if (fileAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAfter", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletion"));
        }
        this.testCompletionTyping(filesBefore, "", fileAfter);
    }

    @Override
    public void testCompletionTyping(@NotNull String[] filesBefore, @NotNull String toType, @NotNull String fileAfter) {
        if (filesBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesBefore", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletionTyping"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletionTyping"));
        }
        if (fileAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAfter", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletionTyping"));
        }
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        this.complete(CompletionType.BASIC);
        this.type(toType);
        try {
            this.checkResultByFile(fileAfter);
        }
        catch (RuntimeException e) {
            System.out.println("LookupElementStrings = " + this.getLookupElementStrings());
            throw e;
        }
    }

    protected void assertInitialized() {
        Assert.assertNotNull((String)"setUp() hasn't been called", (Object)((Object)this.myPsiManager));
    }

    @Override
    public void testCompletion(@NotNull String fileBefore, @NotNull String fileAfter, String ... additionalFiles) {
        if (fileBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBefore", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletion"));
        }
        if (fileAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAfter", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletion"));
        }
        if (additionalFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalFiles", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletion"));
        }
        this.testCompletionTyping(fileBefore, "", fileAfter, additionalFiles);
    }

    @Override
    public void testCompletionTyping(@NotNull String fileBefore, @NotNull String toType, @NotNull String fileAfter, String ... additionalFiles) {
        if (fileBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBefore", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletionTyping"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletionTyping"));
        }
        if (fileAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAfter", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletionTyping"));
        }
        if (additionalFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalFiles", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletionTyping"));
        }
        this.testCompletionTyping((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore)), toType, fileAfter);
    }

    @Override
    public void testCompletionVariants(@NotNull String fileBefore, String ... expectedItems) {
        if (fileBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBefore", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletionVariants"));
        }
        if (expectedItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedItems", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testCompletionVariants"));
        }
        this.assertInitialized();
        List<String> result = this.getCompletionVariants(fileBefore);
        Assert.assertNotNull(result);
        UsefulTestCase.assertSameElements(result, expectedItems);
    }

    @Override
    public List<String> getCompletionVariants(String ... filesBefore) {
        if (filesBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesBefore", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getCompletionVariants"));
        }
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        LookupElement[] items = this.complete(CompletionType.BASIC);
        Assert.assertNotNull((String)"No lookup was shown, probably there was only one lookup element that was inserted automatically", (Object)items);
        return this.getLookupElementStrings();
    }

    @Override
    @Nullable
    public List<String> getLookupElementStrings() {
        this.assertInitialized();
        Object[] elements = this.getLookupElements();
        if (elements == null) {
            return null;
        }
        return ContainerUtil.map((Object[])elements, (Function)new Function<LookupElement, String>(){

            public String fun(LookupElement lookupItem) {
                return lookupItem.getLookupString();
            }
        });
    }

    @Override
    public void finishLookup(final char completionChar) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), new Runnable(){

            @Override
            public void run() {
                ((LookupImpl)LookupManager.getActiveLookup(CodeInsightTestFixtureImpl.this.getEditor())).finishLookup(completionChar);
            }
        }, null, null);
    }

    @Override
    public void testRename(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName, String ... additionalFiles) {
        if (fileBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBefore", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testRename"));
        }
        if (fileAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAfter", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testRename"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testRename"));
        }
        if (additionalFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalFiles", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testRename"));
        }
        this.assertInitialized();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore)));
        this.testRename(fileAfter, newName);
    }

    @Override
    public void testRename(@NotNull String fileAfter, @NotNull String newName) {
        if (fileAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAfter", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testRename"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testRename"));
        }
        this.renameElementAtCaret(newName);
        this.checkResultByFile(fileAfter);
    }

    @Override
    @NotNull
    public PsiElement getElementAtCaret() {
        this.assertInitialized();
        Editor editor = this.getCompletionEditor();
        int findTargetFlags = 3;
        PsiElement element = TargetElementUtil.findTargetElement(editor, findTargetFlags);
        if (element == null && editor instanceof EditorWindow) {
            element = TargetElementUtil.findTargetElement(((EditorWindow)editor).getDelegate(), findTargetFlags);
        }
        if (element == null) {
            Assert.fail((String)("element not found in file " + this.myFile.getName() + " at caret position offset " + this.myEditor.getCaretModel().getOffset() + "," + " psi structure:\n" + DebugUtil.psiToString((PsiElement)this.getFile(), true, true)));
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getElementAtCaret"));
        }
        return psiElement;
    }

    @Override
    public void renameElementAtCaret(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "renameElementAtCaret"));
        }
        this.renameElement(this.getElementAtCaret(), newName);
    }

    @Override
    public void renameElementAtCaretUsingHandler(final @NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "renameElementAtCaretUsingHandler"));
        }
        final DataContext editorContext = ((EditorEx)this.myEditor).getDataContext();
        DataContext context = new DataContext(){

            public Object getData(String dataId) {
                return PsiElementRenameHandler.DEFAULT_NAME.getName().equals(dataId) ? newName : editorContext.getData(dataId);
            }
        };
        RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(context);
        Assert.assertNotNull((String)"No handler for this context", (Object)renameHandler);
        renameHandler.invoke(this.getProject(), this.myEditor, this.getFile(), context);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "renameElement"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "renameElement"));
        }
        boolean searchInComments = false;
        boolean searchTextOccurrences = false;
        this.renameElement(element, newName, false, false);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, boolean searchInComments, boolean searchTextOccurrences) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "renameElement"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "renameElement"));
        }
        PsiElement substitution = RenamePsiElementProcessor.forElement(element).substituteElementToRename(element, this.myEditor);
        if (substitution == null) {
            return;
        }
        new RenameProcessor(this.getProject(), substitution, newName, searchInComments, searchTextOccurrences).run();
    }

    @Override
    public <T extends PsiElement> T findElementByText(@NotNull String text, @NotNull Class<T> elementClass) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findElementByText"));
        }
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findElementByText"));
        }
        int pos = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(this.getFile()).getText().indexOf(text);
        Assert.assertTrue((String)text, (pos >= 0 ? 1 : 0) != 0);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)this.getFile().findElementAt(pos), elementClass);
    }

    @Override
    public void type(final char c) {
        this.assertInitialized();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                final EditorActionManager actionManager = EditorActionManager.getInstance();
                if (c == '\b') {
                    CodeInsightTestFixtureImpl.this.performEditorAction("EditorBackSpace");
                    return;
                }
                if (c == '\n') {
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("EditorChooseLookupItem")) {
                        return;
                    }
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("NextTemplateVariable")) {
                        return;
                    }
                    CodeInsightTestFixtureImpl.this.performEditorAction("EditorEnter");
                    return;
                }
                if (c == '\t') {
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("EditorChooseLookupItemReplace")) {
                        return;
                    }
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("ExpandLiveTemplateByTab")) {
                        return;
                    }
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("NextTemplateVariable")) {
                        return;
                    }
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("EditorTab")) {
                        return;
                    }
                }
                if (c == '\r' && CodeInsightTestFixtureImpl.this._performEditorAction("EditorChooseLookupItemCompleteStatement")) {
                    return;
                }
                CommandProcessor.getInstance().executeCommand(CodeInsightTestFixtureImpl.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().setCurrentCommandGroupId((Object)CodeInsightTestFixtureImpl.this.myEditor.getDocument());
                        ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, CodeInsightTestFixtureImpl.this.getEditorDataContext());
                        actionManager.getTypedAction().actionPerformed(CodeInsightTestFixtureImpl.this.getEditor(), c, CodeInsightTestFixtureImpl.this.getEditorDataContext());
                    }
                }, null, (Object)DocCommandGroupId.noneGroupId((Document)CodeInsightTestFixtureImpl.this.myEditor.getDocument()));
            }
        });
    }

    @NotNull
    private DataContext getEditorDataContext() {
        DataContext dataContext = ((EditorEx)this.myEditor).getDataContext();
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getEditorDataContext"));
        }
        return dataContext;
    }

    @Override
    public void type(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "type"));
        }
        for (int i = 0; i < s.length(); ++i) {
            this.type(s.charAt(i));
        }
    }

    @Override
    public void performEditorAction(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "performEditorAction"));
        }
        this.assertInitialized();
        this._performEditorAction(actionId);
    }

    private boolean _performEditorAction(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "_performEditorAction"));
        }
        final DataContext dataContext = this.getEditorDataContext();
        final ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        final AnAction action = managerEx.getAction(actionId);
        final AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(), (ActionManager)managerEx, 0);
        return (Boolean)WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (Computable)new Computable<Boolean>(){

            public Boolean compute() {
                action.update(event);
                if (!event.getPresentation().isEnabled()) {
                    return false;
                }
                managerEx.fireBeforeActionPerformed(action, dataContext, event);
                action.actionPerformed(event);
                managerEx.fireAfterActionPerformed(action, dataContext, event);
                return true;
            }
        });
    }

    @Override
    @NotNull
    public Presentation testAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testAction"));
        }
        TestActionEvent e = new TestActionEvent(action);
        action.beforeActionPerformedUpdate((AnActionEvent)e);
        if (e.getPresentation().isEnabled() && e.getPresentation().isVisible()) {
            action.actionPerformed((AnActionEvent)e);
        }
        Presentation presentation = e.getPresentation();
        if (presentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testAction"));
        }
        return presentation;
    }

    @Override
    @NotNull
    public Collection<UsageInfo> testFindUsages(String ... fileNames) {
        if (fileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testFindUsages"));
        }
        this.assertInitialized();
        this.configureByFiles(fileNames);
        PsiElement targetElement = TargetElementUtil.findTargetElement(this.getEditor(), 3);
        Assert.assertNotNull((String)"Cannot find referenced element", (Object)targetElement);
        Collection<UsageInfo> collection = this.findUsages(targetElement);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testFindUsages"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findUsages"));
        }
        Collection<UsageInfo> collection = this.findUsages(targetElement, null);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findUsages"));
        }
        return collection;
    }

    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement, @Nullable SearchScope scope) {
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findUsages"));
        }
        Project project2 = this.getProject();
        FindUsagesHandler handler2 = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager().getFindUsagesHandler(targetElement, false);
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        Assert.assertNotNull((String)("Cannot find handler for: " + targetElement), (Object)handler2);
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler2.getPrimaryElements(), (Object[])handler2.getSecondaryElements());
        FindUsagesOptions options = handler2.getFindUsagesOptions(null);
        if (scope != null) {
            options.searchScope = scope;
        }
        for (PsiElement psiElement : psiElements) {
            handler2.processElementUsages(psiElement, (Processor<UsageInfo>)processor2, options);
        }
        Collection collection = processor2.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findUsages"));
        }
        return collection;
    }

    @Override
    @NotNull
    public RangeHighlighter[] testHighlightUsages(String ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testHighlightUsages"));
        }
        this.configureByFiles(files);
        this.testAction(new HighlightUsagesAction());
        Editor editor = this.getEditor();
        RangeHighlighter[] rangeHighlighterArray = editor.getMarkupModel().getAllHighlighters();
        if (rangeHighlighterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testHighlightUsages"));
        }
        return rangeHighlighterArray;
    }

    @Override
    public void moveFile(final @NotNull String filePath, final @NotNull String to, final String ... additionalFiles) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "moveFile"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "moveFile"));
        }
        if (additionalFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalFiles", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "moveFile"));
        }
        this.assertInitialized();
        final Project project2 = this.getProject();
        new WriteCommandAction.Simple(project2, new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)filePath)));
                VirtualFile file2 = CodeInsightTestFixtureImpl.this.findFileInTempDir(to);
                Assert.assertNotNull((String)("Directory " + to + " not found"), (Object)file2);
                Assert.assertTrue((String)(to + " is not a directory"), (boolean)file2.isDirectory());
                PsiDirectory directory = CodeInsightTestFixtureImpl.this.myPsiManager.findDirectory(file2);
                new MoveFilesOrDirectoriesProcessor(project2, new PsiElement[]{CodeInsightTestFixtureImpl.this.getFile()}, directory, false, false, null, null).run();
            }
        }.execute().throwException();
    }

    @Override
    @Nullable
    public GutterMark findGutter(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findGutter"));
        }
        this.configureByFilesInner(filePath);
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        this.findGutters((Processor<GutterMark>)processor2);
        return (GutterMark)processor2.getFoundValue();
    }

    @Override
    @NotNull
    public List<GutterMark> findGuttersAtCaret() {
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        this.findGutters((Processor<GutterMark>)processor2);
        ArrayList<GutterMark> arrayList = new ArrayList<GutterMark>(processor2.getResults());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findGuttersAtCaret"));
        }
        return arrayList;
    }

    private void findGutters(Processor<GutterMark> processor2) {
        RangeHighlighter[] highlighters;
        int offset = this.myEditor.getCaretModel().getOffset();
        List<HighlightInfo> infos = this.doHighlighting();
        for (HighlightInfo info : infos) {
            GutterMark renderer;
            if (info.endOffset < offset || info.startOffset > offset || (renderer = info.getGutterIconRenderer()) == null || processor2.process((Object)renderer)) continue;
            return;
        }
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getProject(), true).getAllHighlighters()) {
            GutterIconRenderer renderer;
            if (highlighter.getEndOffset() < offset || highlighter.getStartOffset() > offset || (renderer = highlighter.getGutterIconRenderer()) == null || processor2.process((Object)renderer)) continue;
            return;
        }
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findAllGutters"));
        }
        this.configureByFilesInner(filePath);
        List<GutterMark> list = this.findAllGutters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findAllGutters"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters() {
        RangeHighlighter[] highlighters;
        Project project2 = this.getProject();
        TreeMap<Integer, List<GutterMark>> result = new TreeMap<Integer, List<GutterMark>>();
        List<HighlightInfo> infos = this.doHighlighting();
        for (HighlightInfo info : infos) {
            CodeInsightTestFixtureImpl.addGutterIconRenderer(info.getGutterIconRenderer(), info.startOffset, result);
        }
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), project2, true).getAllHighlighters()) {
            if (!highlighter.isValid()) continue;
            CodeInsightTestFixtureImpl.addGutterIconRenderer((GutterMark)highlighter.getGutterIconRenderer(), highlighter.getStartOffset(), result);
        }
        List list = ContainerUtil.concat(result.values());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findAllGutters"));
        }
        return list;
    }

    @Override
    public PsiFile addFileToProject(@NotNull String relativePath, @NotNull String fileText) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "addFileToProject"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "addFileToProject"));
        }
        this.assertInitialized();
        return this.addFileToProject(this.getTempDirPath(), relativePath, fileText);
    }

    protected PsiFile addFileToProject(final @NotNull String rootPath, final @NotNull String relativePath, final @NotNull String fileText) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "addFileToProject"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "addFileToProject"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "addFileToProject"));
        }
        return (PsiFile)new WriteCommandAction<PsiFile>(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<PsiFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$19", "run"));
                }
                try {
                    if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                        VirtualFile file2 = CodeInsightTestFixtureImpl.this.myTempDirFixture.createFile(relativePath, fileText);
                        result.setResult((Object)PsiManager.getInstance((Project)this.getProject()).findFile(file2));
                    } else {
                        result.setResult((Object)((HeavyIdeaTestFixture)CodeInsightTestFixtureImpl.this.myProjectFixture).addFileToProject(rootPath, relativePath, fileText));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)this.getProject()).getModificationTracker()).incCounter();
                }
            }
        }.execute().getResultObject();
    }

    public <T> void registerExtension(ExtensionsArea area, ExtensionPointName<T> epName, final T extension) {
        this.assertInitialized();
        final ExtensionPoint extensionPoint = area.getExtensionPoint(epName);
        extensionPoint.registerExtension(extension);
        Disposer.register((Disposable)this.getTestRootDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        PsiManagerImpl psiManagerImpl = this.myPsiManager;
        if (psiManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getPsiManager"));
        }
        return psiManagerImpl;
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "complete"));
        }
        return this.complete(type, 1);
    }

    @Override
    public LookupElement[] complete(final @NotNull CompletionType type, final int invocationCount) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "complete"));
        }
        this.assertInitialized();
        this.myEmptyLookup = false;
        return (LookupElement[])UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<LookupElement[]>(){

            public LookupElement[] compute() {
                CommandProcessor.getInstance().executeCommand(CodeInsightTestFixtureImpl.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        CodeCompletionHandlerBase handler2 = new CodeCompletionHandlerBase(type){

                            @Override
                            protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
                                CodeInsightTestFixtureImpl.this.myEmptyLookup = indicator.getLookup().getItems().isEmpty();
                                super.completionFinished(indicator, hasModifiers);
                            }
                        };
                        Editor editor = CodeInsightTestFixtureImpl.this.getCompletionEditor();
                        handler2.invokeCompletion(CodeInsightTestFixtureImpl.this.getProject(), editor, invocationCount);
                        PsiDocumentManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject()).commitAllDocuments();
                    }
                }, null, null);
                return CodeInsightTestFixtureImpl.this.getLookupElements();
            }
        });
    }

    @Nullable
    protected Editor getCompletionEditor() {
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.getFile());
    }

    @Override
    @Nullable
    public LookupElement[] completeBasic() {
        return this.complete(CompletionType.BASIC);
    }

    @Override
    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeAfterCompletion) {
        CaretModel caretModel = this.myEditor.getCaretModel();
        List carets = caretModel.getAllCarets();
        ArrayList<Integer> originalOffsets = new ArrayList<Integer>(carets.size());
        for (Caret caret : carets) {
            originalOffsets.add(caret.getOffset());
        }
        caretModel.removeSecondaryCarets();
        Collections.reverse(originalOffsets);
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        Iterator iterator = originalOffsets.iterator();
        while (iterator.hasNext()) {
            int originalOffset = (Integer)iterator.next();
            caretModel.moveToOffset(originalOffset);
            LookupElement[] lookupElements = this.completeBasic();
            if (charToTypeAfterCompletion != null) {
                this.type(charToTypeAfterCompletion.charValue());
            }
            if (lookupElements == null) continue;
            result.addAll(Arrays.asList(lookupElements));
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "completeBasicAllCarets"));
        }
        return arrayList;
    }

    @Override
    public void saveText(final @NotNull VirtualFile file2, final @NotNull String text) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "saveText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "saveText"));
        }
        new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$22", "run"));
                }
                VfsUtil.saveText((VirtualFile)file2, (String)text);
            }
        }.execute().throwException();
    }

    @Override
    @Nullable
    public LookupElement[] getLookupElements() {
        LookupImpl lookup = this.getLookup();
        if (lookup == null) {
            return this.myEmptyLookup ? LookupElement.EMPTY_ARRAY : null;
        }
        List<LookupElement> list = lookup.getItems();
        return list.toArray(new LookupElement[list.size()]);
    }

    @Override
    public void checkResult(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResult"));
        }
        this.checkResult(text, false);
    }

    @Override
    public void checkResult(final @NotNull String text, final boolean stripTrailingSpaces) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResult"));
        }
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$23", "run"));
                }
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                EditorUtil.fillVirtualSpaceUntilCaret(CodeInsightTestFixtureImpl.this.myEditor);
                CodeInsightTestFixtureImpl.this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(text), CodeInsightTestFixtureImpl.this.getHostFile().getText());
            }
        }.execute();
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile) {
        if (expectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFile", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResultByFile"));
        }
        this.checkResultByFile(expectedFile, false);
    }

    @Override
    public void checkResultByFile(final @NotNull String expectedFile, final boolean ignoreTrailingWhitespaces) {
        if (expectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFile", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResultByFile"));
        }
        this.assertInitialized();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    CodeInsightTestFixtureImpl.this.checkResultByFile(expectedFile, CodeInsightTestFixtureImpl.this.getHostFile(), ignoreTrailingWhitespaces);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void checkResultByFile(final @NotNull String filePath, final @NotNull String expectedFile, final boolean ignoreTrailingWhitespaces) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResultByFile"));
        }
        if (expectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFile", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResultByFile"));
        }
        this.assertInitialized();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String path = filePath.replace(File.separatorChar, '/');
                VirtualFile copy = CodeInsightTestFixtureImpl.this.findFileInTempDir(path);
                if (copy == null) {
                    throw new IllegalArgumentException("could not find results file " + path);
                }
                PsiFile psiFile = CodeInsightTestFixtureImpl.this.myPsiManager.findFile(copy);
                Assert.assertNotNull((String)copy.getPath(), (Object)psiFile);
                try {
                    CodeInsightTestFixtureImpl.this.checkResultByFile(expectedFile, psiFile, ignoreTrailingWhitespaces);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestRunnerUtil.replaceIdeEventQueueSafely();
        EdtTestUtil.runInEdtAndWait(new ThrowableRunnable<Throwable>(){

            public void run() throws Throwable {
                CodeInsightTestFixtureImpl.this.myProjectFixture.setUp();
                CodeInsightTestFixtureImpl.this.myTempDirFixture.setUp();
                VirtualFile tempDir = CodeInsightTestFixtureImpl.this.myTempDirFixture.getFile("");
                PlatformTestCase.synchronizeTempDirVfs(tempDir);
                CodeInsightTestFixtureImpl.this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject());
                CodeInsightTestFixtureImpl.configureInspections((InspectionProfileEntry[])LocalInspectionTool.EMPTY_ARRAY, CodeInsightTestFixtureImpl.this.getProject(), Collections.emptyList(), CodeInsightTestFixtureImpl.this.getTestRootDisposable());
                DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject());
                daemonCodeAnalyzer.prepareForTest();
                DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
                CodeInsightTestFixtureImpl.ensureIndexesUpToDate(CodeInsightTestFixtureImpl.this.getProject());
                ((StartupManagerImpl)StartupManagerEx.getInstanceEx(CodeInsightTestFixtureImpl.this.getProject())).runPostStartupActivities();
            }
        });
    }

    @Override
    public void tearDown() throws Exception {
        try {
            EdtTestUtil.runInEdtAndWait(new ThrowableRunnable<Throwable>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws Throwable {
                    try {
                        VirtualFile[] openFiles;
                        DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(true);
                        FileEditorManager editorManager = FileEditorManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject());
                        PsiDocumentManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject()).commitAllDocuments();
                        for (VirtualFile openFile : openFiles = editorManager.getOpenFiles()) {
                            editorManager.closeFile(openFile);
                        }
                    }
                    finally {
                        CodeInsightTestFixtureImpl.this.myEditor = null;
                        CodeInsightTestFixtureImpl.this.myFile = null;
                        CodeInsightTestFixtureImpl.this.myPsiManager = null;
                        try {
                            CodeInsightTestFixtureImpl.this.myProjectFixture.tearDown();
                        }
                        finally {
                            CodeInsightTestFixtureImpl.this.myTempDirFixture.tearDown();
                        }
                    }
                }
            });
        }
        finally {
            super.tearDown();
        }
    }

    @NotNull
    private PsiFile[] configureByFilesInner(String ... filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByFilesInner"));
        }
        this.assertInitialized();
        this.myFile = null;
        this.myEditor = null;
        PsiFile[] psiFiles = new PsiFile[filePaths.length];
        for (int i = filePaths.length - 1; i >= 0; --i) {
            psiFiles[i] = this.configureByFileInner(filePaths[i]);
        }
        if (psiFiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByFilesInner"));
        }
        return psiFiles;
    }

    @Override
    public PsiFile configureByFile(@NotNull String file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByFile"));
        }
        this.configureByFilesInner(file2);
        return this.getFile();
    }

    @Override
    @NotNull
    public PsiFile[] configureByFiles(String ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByFiles"));
        }
        PsiFile[] psiFileArray = this.configureByFilesInner(files);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByFiles"));
        }
        return psiFileArray;
    }

    @Override
    public PsiFile configureByText(final @NotNull FileType fileType, @NotNull String text) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByText"));
        }
        this.assertInitialized();
        final String extension = fileType.getDefaultExtension();
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager.getFileTypeByExtension(extension) != fileType) {
            new WriteCommandAction(this.getProject(), new PsiFile[0]){

                protected void run(@NotNull Result result) throws Exception {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$28", "run"));
                    }
                    fileTypeManager.associateExtension(fileType, extension);
                }
            }.execute();
        }
        String fileName = "aaa." + extension;
        return this.configureByText(fileName, text);
    }

    @Override
    public PsiFile configureByText(final @NotNull String fileName, final @NotNull String text) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByText"));
        }
        this.assertInitialized();
        return (PsiFile)new WriteCommandAction<PsiFile>(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<PsiFile> result) throws Throwable {
                VirtualFile vFile;
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$29", "run"));
                }
                if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                    VirtualFile root = LightPlatformTestCase.getSourceRoot();
                    root.refresh(false, false);
                    vFile = root.findOrCreateChildData((Object)this, fileName);
                    Assert.assertNotNull((String)(fileName + " not found in " + root.getPath()), (Object)vFile);
                } else if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof TempDirTestFixtureImpl) {
                    File tempFile2 = ((TempDirTestFixtureImpl)CodeInsightTestFixtureImpl.this.myTempDirFixture).createTempFile(fileName);
                    vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile2);
                    Assert.assertNotNull((String)(tempFile2 + " not found"), (Object)vFile);
                } else {
                    vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(CodeInsightTestFixtureImpl.this.getTempDirPath(), fileName));
                    Assert.assertNotNull((String)(fileName + " not found in " + CodeInsightTestFixtureImpl.this.getTempDirPath()), (Object)vFile);
                }
                CodeInsightTestFixtureImpl.this.prepareVirtualFile(vFile);
                Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
                if (document != null) {
                    PsiDocumentManager.getInstance((Project)this.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                VfsUtil.saveText((VirtualFile)vFile, (String)text);
                CodeInsightTestFixtureImpl.this.configureInner(vFile, SelectionAndCaretMarkupLoader.fromFile(vFile));
                result.setResult((Object)CodeInsightTestFixtureImpl.this.getFile());
            }
        }.execute().getResultObject();
    }

    @Override
    public Document getDocument(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getDocument"));
        }
        this.assertInitialized();
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    private PsiFile configureByFileInner(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByFileInner"));
        }
        this.assertInitialized();
        VirtualFile file2 = this.copyFileToProject(filePath);
        return this.configureByFileInner(file2);
    }

    @Override
    public PsiFile configureFromTempProjectFile(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureFromTempProjectFile"));
        }
        VirtualFile fileInTempDir = this.findFileInTempDir(filePath);
        if (fileInTempDir == null) {
            throw new IllegalArgumentException("Could not find file in temp dir: " + filePath);
        }
        return this.configureByFileInner(fileInTempDir);
    }

    @Override
    public void configureFromExistingVirtualFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureFromExistingVirtualFile"));
        }
        this.configureByFileInner(virtualFile);
    }

    private PsiFile configureByFileInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureByFileInner"));
        }
        return this.configureInner(copy, SelectionAndCaretMarkupLoader.fromFile(copy));
    }

    private PsiFile configureInner(final @NotNull VirtualFile copy, final @NotNull SelectionAndCaretMarkupLoader loader) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureInner"));
        }
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureInner"));
        }
        this.assertInitialized();
        EdtTestUtil.runInEdtAndWait(new ThrowableRunnable<Throwable>(){

            public void run() {
                if (!copy.getFileType().isBinary()) {
                    AccessToken token = WriteAction.start();
                    try {
                        copy.setBinaryContent(loader.newFileText.getBytes(copy.getCharset()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        token.finish();
                    }
                }
                CodeInsightTestFixtureImpl.this.myFile = copy;
                CodeInsightTestFixtureImpl.this.myEditor = CodeInsightTestFixtureImpl.this.createEditor(copy);
                if (CodeInsightTestFixtureImpl.this.myEditor == null) {
                    Assert.fail((String)("editor couldn't be created for: " + copy.getPath() + ", use copyFileToProject() instead of configureByFile()"));
                }
                EditorTestUtil.setCaretsAndSelection(CodeInsightTestFixtureImpl.this.myEditor, loader.caretState);
                Module module2 = CodeInsightTestFixtureImpl.this.getModule();
                if (module2 != null) {
                    for (Facet facet : FacetManager.getInstance((Module)module2).getAllFacets()) {
                        ((FacetManagerListener)module2.getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged(facet);
                    }
                }
                PsiDocumentManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject()).commitAllDocuments();
                if (CodeInsightTestFixtureImpl.this.myCaresAboutInjection) {
                    CodeInsightTestFixtureImpl.this.setupEditorForInjectedLanguage();
                }
            }
        });
        return this.getFile();
    }

    protected void prepareVirtualFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "prepareVirtualFile"));
        }
    }

    private void setupEditorForInjectedLanguage() {
        Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.getFile());
        if (editor instanceof EditorWindow) {
            this.myFile = ((EditorWindow)editor).getInjectedFile().getViewProvider().getVirtualFile();
            this.myEditor = editor;
        }
    }

    @Override
    public VirtualFile findFileInTempDir(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findFileInTempDir"));
        }
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.getFile(filePath);
        }
        String fullPath = this.getTempDirPath() + "/" + filePath;
        VirtualFile copy = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
        Assert.assertNotNull((String)("file " + fullPath + " not found"), (Object)copy);
        VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(copy, filePath);
        return copy;
    }

    @Nullable
    protected Editor createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createEditor"));
        }
        Project project2 = this.getProject();
        FileEditorManager instance = FileEditorManager.getInstance((Project)project2);
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        Editor editor = instance.openTextEditor(new OpenFileDescriptor(project2, file2), false);
        if (editor != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
        }
        return editor;
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) throws Exception {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) throws Exception {
        ExpectedHighlightingData data = new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, ignoreExtraHighlighting, this.getHostFile());
        data.init();
        return this.collectAndCheckHighlighting(data);
    }

    private PsiFile getHostFile() {
        return InjectedLanguageUtil.getTopLevelFile((PsiElement)this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long collectAndCheckHighlighting(@NotNull ExpectedHighlightingData data) {
        List<HighlightInfo> infos;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "collectAndCheckHighlighting"));
        }
        Project project2 = this.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiFileImpl file2 = (PsiFileImpl)this.getHostFile();
        FileElement hardRefToFileElement = file2.calcTreeElement();
        if (!DumbService.isDumb((Project)project2)) {
            CacheManager.SERVICE.getInstance(project2).getFilesWithWord("XXX", (short)2, GlobalSearchScope.allScope((Project)project2), true);
        }
        long start = System.currentTimeMillis();
        VirtualFileFilter fileTreeAccessFilter = this.myVirtualFileFilter;
        Disposable disposable = Disposer.newDisposable();
        if (fileTreeAccessFilter != null) {
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).setAssertOnFileLoadingFilter(fileTreeAccessFilter, disposable);
        }
        try {
            infos = this.doHighlighting();
            CodeInsightTestFixtureImpl.removeDuplicatedRangesForInjected(infos);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        long elapsed = System.currentTimeMillis() - start;
        data.checkResult(infos, file2.getText());
        hardRefToFileElement.hashCode();
        return elapsed;
    }

    public void setVirtualFileFilter(@Nullable VirtualFileFilter filter) {
        this.myVirtualFileFilter = filter;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting() {
        Project project2 = this.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiFile file2 = this.getFile();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageUtil.getTopLevelFile((PsiElement)file2);
        }
        List<HighlightInfo> list = CodeInsightTestFixtureImpl.instantiateAndRun(file2, editor, ArrayUtil.EMPTY_INT_ARRAY, this.myAllowDirt);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "doHighlighting"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting(final @NotNull HighlightSeverity minimalSeverity) {
        if (minimalSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimalSeverity", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "doHighlighting"));
        }
        List list = ContainerUtil.filter(this.doHighlighting(), (Condition)new Condition<HighlightInfo>(){

            public boolean value(HighlightInfo info) {
                return info.getSeverity().compareTo(minimalSeverity) >= 0;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "doHighlighting"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getTestDataPath() {
        String string = this.myTestDataPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getTestDataPath"));
        }
        return string;
    }

    @Override
    public void setTestDataPath(@NotNull String dataPath) {
        if (dataPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPath", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "setTestDataPath"));
        }
        this.myTestDataPath = dataPath;
    }

    @Override
    public Project getProject() {
        return this.myProjectFixture.getProject();
    }

    @Override
    public Module getModule() {
        return this.myProjectFixture.getModule();
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public int getCaretOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @Override
    public PsiFile getFile() {
        return this.myFile == null ? null : (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                return PsiManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject()).findFile(CodeInsightTestFixtureImpl.this.myFile);
            }
        });
    }

    @Override
    public void allowTreeAccessForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "allowTreeAccessForFile"));
        }
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForFile(file2);
    }

    @Override
    public void allowTreeAccessForAllFiles() {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForAllFiles();
    }

    private void checkResultByFile(@NotNull String expectedFile, @NotNull PsiFile originalFile, boolean stripTrailingSpaces) throws IOException {
        if (expectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFile", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResultByFile"));
        }
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResultByFile"));
        }
        if (!stripTrailingSpaces) {
            EditorUtil.fillVirtualSpaceUntilCaret(this.myEditor);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        String fileText = originalFile.getText();
        String path = this.getTestDataPath() + "/" + expectedFile;
        VirtualFile virtualFile = originalFile.getVirtualFile();
        String charset = virtualFile == null ? null : virtualFile.getCharset().name();
        this.checkResult(expectedFile, stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromFile(path, charset), fileText);
    }

    private void checkResult(@NotNull String expectedFile, boolean stripTrailingSpaces, @NotNull SelectionAndCaretMarkupLoader loader, @NotNull String actualText) {
        if (expectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFile", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResult"));
        }
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResult"));
        }
        if (actualText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualText", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResult"));
        }
        this.assertInitialized();
        Project project2 = this.getProject();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        UsefulTestCase.doPostponedFormatting(this.getProject());
        if (stripTrailingSpaces) {
            actualText = this.stripTrailingSpaces(actualText);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        String newFileText1 = loader.newFileText;
        if (stripTrailingSpaces) {
            newFileText1 = this.stripTrailingSpaces(newFileText1);
        }
        if (!Comparing.equal((String)newFileText1, (String)(actualText = StringUtil.convertLineSeparators((String)actualText)))) {
            if (loader.filePath != null) {
                throw new FileComparisonFailure(expectedFile, newFileText1, actualText, loader.filePath);
            }
            throw new ComparisonFailure(expectedFile, newFileText1, actualText);
        }
        EditorTestUtil.verifyCaretAndSelectionState(editor, loader.caretState, expectedFile);
    }

    @NotNull
    private String stripTrailingSpaces(@NotNull String actualText) {
        if (actualText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualText", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "stripTrailingSpaces"));
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)actualText);
        ((DocumentImpl)document).stripTrailingSpaces(this.getProject());
        String string = actualText = document.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "stripTrailingSpaces"));
        }
        return string;
    }

    public void canChangeDocumentDuringHighlighting(boolean canI) {
        this.myAllowDirt = canI;
    }

    @NotNull
    public String getFoldingDescription(boolean withCollapseStatus) {
        CodeFoldingManager.getInstance(this.getProject()).buildInitialFoldings(this.myEditor);
        FoldingModel model = this.myEditor.getFoldingModel();
        FoldRegion[] foldingRegions = model.getAllFoldRegions();
        LinkedList<Border> borders = new LinkedList<Border>();
        for (FoldRegion region : foldingRegions) {
            borders.add(new Border(true, region.getStartOffset(), region.getPlaceholderText(), region.isExpanded()));
            borders.add(new Border(false, region.getEndOffset(), "", region.isExpanded()));
        }
        Collections.sort(borders);
        StringBuilder result = new StringBuilder(this.myEditor.getDocument().getText());
        for (Border border : borders) {
            result.insert(border.getOffset(), border.isSide() ? "<fold text='" + border.getText() + "'" + (withCollapseStatus ? " expand='" + border.isExpanded() + "'" : "") + ">" : END_FOLD);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getFoldingDescription"));
        }
        return string;
    }

    private void testFoldingRegions(@NotNull String verificationFileName, boolean doCheckCollapseStatus) {
        String expectedContent;
        if (verificationFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verificationFileName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testFoldingRegions"));
        }
        try {
            expectedContent = FileUtil.loadFile((File)new File(verificationFileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertNotNull((Object)expectedContent);
        expectedContent = StringUtil.replace((String)expectedContent, (String)"\r", (String)"");
        String cleanContent = expectedContent.replaceAll(START_FOLD, "").replaceAll(END_FOLD, "");
        this.configureByText(FileTypeManager.getInstance().getFileTypeByFileName(verificationFileName), cleanContent);
        String actual = this.getFoldingDescription(doCheckCollapseStatus);
        Assert.assertEquals((Object)expectedContent, (Object)actual);
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName) {
        if (verificationFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verificationFileName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testFoldingWithCollapseStatus"));
        }
        this.testFoldingRegions(verificationFileName, true);
    }

    @Override
    public void testFolding(@NotNull String verificationFileName) {
        if (verificationFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verificationFileName", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testFolding"));
        }
        this.testFoldingRegions(verificationFileName, false);
    }

    @Override
    public void assertPreferredCompletionItems(int selected, String ... expected) {
        if (expected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expected", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "assertPreferredCompletionItems"));
        }
        LookupImpl lookup = this.getLookup();
        Assert.assertNotNull((String)"No lookup is shown", (Object)lookup);
        JList list = lookup.getList();
        List<String> strings = this.getLookupElementStrings();
        Assert.assertNotNull(strings);
        List<String> actual = strings.subList(0, Math.min(expected.length, strings.size()));
        if (!actual.equals(Arrays.asList(expected))) {
            UsefulTestCase.assertOrderedEquals(DumpLookupElementWeights.getLookupElementWeights(lookup, false), expected);
        }
        if (selected != list.getSelectedIndex()) {
            System.out.println(DumpLookupElementWeights.getLookupElementWeights(lookup, false));
        }
        Assert.assertEquals((long)selected, (long)list.getSelectedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void testStructureView(@NotNull Consumer<StructureViewComponent> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testStructureView"));
        }
        Assert.assertNotNull((String)"configure first", (Object)this.myFile);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(this.myFile);
        Assert.assertNotNull((String)("editor not opened for " + this.myFile), (Object)this.myFile);
        StructureViewBuilder builder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(this.getFile());
        Assert.assertNotNull((String)("no builder for " + this.myFile), (Object)this.myFile);
        StructureViewComponent component = null;
        try {
            component = (StructureViewComponent)builder.createStructureView(fileEditor, this.myProjectFixture.getProject());
            consumer.consume((Object)component);
            if (component == null) return;
        }
        catch (Throwable throwable) {
            if (component == null) throw throwable;
            Disposer.dispose(component);
            throw throwable;
        }
        Disposer.dispose((Disposable)component);
    }

    @Override
    public void setCaresAboutInjection(boolean caresAboutInjection) {
        this.myCaresAboutInjection = caresAboutInjection;
    }

    @Override
    public LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
    }

    protected void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (this.myEditor instanceof EditorWindow) {
            Document document = ((DocumentWindow)this.myEditor.getDocument()).getDelegate();
            this.myFile = FileDocumentManager.getInstance().getFile(document);
            this.myEditor = ((EditorWindow)this.myEditor).getDelegate();
        }
    }

    private static class Border
    implements Comparable<Border> {
        private static final boolean LEFT = true;
        private static final boolean RIGHT = false;
        private final boolean mySide;
        private final int myOffset;
        private final String myText;
        private final boolean myIsExpanded;

        private Border(boolean side, int offset, String text, boolean isExpanded) {
            this.mySide = side;
            this.myOffset = offset;
            this.myText = text;
            this.myIsExpanded = isExpanded;
        }

        public boolean isExpanded() {
            return this.myIsExpanded;
        }

        public boolean isSide() {
            return this.mySide;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public String getText() {
            return this.myText;
        }

        @Override
        public int compareTo(@NotNull Border o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$Border", "compareTo"));
            }
            return this.getOffset() < o.getOffset() ? 1 : -1;
        }
    }

    private static class SelectionAndCaretMarkupLoader {
        private final String filePath;
        private final String newFileText;
        private final EditorTestUtil.CaretAndSelectionState caretState;

        private SelectionAndCaretMarkupLoader(@NotNull String fileText, String filePath) {
            if (fileText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader", "<init>"));
            }
            this.filePath = filePath;
            Document document = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            this.caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            this.newFileText = document.getText();
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull String path, String charset) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader", "fromFile"));
            }
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader = new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)new File(path), (String)charset)), path);
            if (selectionAndCaretMarkupLoader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader", "fromFile"));
            }
            return selectionAndCaretMarkupLoader;
        }

        @NotNull
        static SelectionAndCaretMarkupLoader fromFile(@NotNull VirtualFile file2) {
            String text;
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader", "fromFile"));
            }
            try {
                text = VfsUtilCore.loadText((VirtualFile)file2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader = new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators((String)text), file2.getPath());
            if (selectionAndCaretMarkupLoader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader", "fromFile"));
            }
            return selectionAndCaretMarkupLoader;
        }

        @NotNull
        static SelectionAndCaretMarkupLoader fromText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader", "fromText"));
            }
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader = new SelectionAndCaretMarkupLoader(text, null);
            if (selectionAndCaretMarkupLoader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader", "fromText"));
            }
            return selectionAndCaretMarkupLoader;
        }
    }
}

