/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;

class TestInfo {
    private final Date runDate;
    private final String url;
    private final TestStateInfo.Magnitude magnitude;

    public TestInfo(String url, TestStateInfo.Magnitude magnitude, Date runDate) {
        this.url = url;
        this.magnitude = magnitude;
        this.runDate = runDate;
    }

    public Date getRunDate() {
        return this.runDate;
    }

    public String getUrl() {
        return this.url;
    }

    public TestStateInfo.Magnitude getMagnitude() {
        return this.magnitude;
    }

    public static <T extends TestInfo> List<T> select(Collection<T> infos, final TestStateInfo.Magnitude ... magnitudes) {
        return ContainerUtil.filter(infos, (Condition)new Condition<T>(){

            public boolean value(T t) {
                for (TestStateInfo.Magnitude magnitude : magnitudes) {
                    if (((TestInfo)t).getMagnitude() != magnitude) continue;
                    return true;
                }
                return false;
            }
        });
    }
}

