/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ui.BalloonImpl;
import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NotificationBalloonShadowBorderProvider
implements BalloonImpl.ShadowBorderProvider {
    private static final Insets INSETS = new JBInsets(4, 6, 8, 6);
    private final Color myFillColor;
    private final Color myBorderColor;

    public NotificationBalloonShadowBorderProvider(@NotNull Color fillColor, @NotNull Color borderColor) {
        if (fillColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fillColor", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "<init>"));
        }
        if (borderColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "borderColor", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "<init>"));
        }
        this.myFillColor = fillColor;
        this.myBorderColor = borderColor;
    }

    @Override
    @NotNull
    public Insets getInsets() {
        Insets insets = INSETS;
        if (insets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "getInsets"));
        }
        return insets;
    }

    @Override
    public void paintShadow(@NotNull JComponent component, @NotNull Graphics g) {
        int y;
        int x;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintShadow"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintShadow"));
        }
        int width = component.getWidth();
        int height = component.getHeight();
        int topLeftWidth = AllIcons.Ide.Notification.Shadow.Top_left.getIconWidth();
        int topLeftHeight = AllIcons.Ide.Notification.Shadow.Top_left.getIconHeight();
        int topRightWidth = AllIcons.Ide.Notification.Shadow.Top_right.getIconWidth();
        int topRightHeight = AllIcons.Ide.Notification.Shadow.Top_right.getIconHeight();
        int bottomLeftWidth = AllIcons.Ide.Notification.Shadow.Bottom_left.getIconWidth();
        int bottomLeftHeight = AllIcons.Ide.Notification.Shadow.Bottom_left.getIconHeight();
        int bottomRightWidth = AllIcons.Ide.Notification.Shadow.Bottom_right.getIconWidth();
        int bottomRightHeight = AllIcons.Ide.Notification.Shadow.Bottom_right.getIconHeight();
        int topWidth = AllIcons.Ide.Notification.Shadow.Top.getIconWidth();
        int bottomWidth = AllIcons.Ide.Notification.Shadow.Bottom.getIconWidth();
        int bottomHeight = AllIcons.Ide.Notification.Shadow.Bottom.getIconHeight();
        int leftHeight = AllIcons.Ide.Notification.Shadow.Left.getIconHeight();
        int rightWidth = AllIcons.Ide.Notification.Shadow.Right.getIconWidth();
        int rightHeight = AllIcons.Ide.Notification.Shadow.Right.getIconHeight();
        Rectangle clipBounds = g.getClipBounds();
        g.setClip(topLeftWidth, 0, width - topLeftWidth - topRightWidth, AllIcons.Ide.Notification.Shadow.Top.getIconHeight());
        for (x = topLeftWidth; x < width; x += topWidth) {
            AllIcons.Ide.Notification.Shadow.Top.paintIcon(component, g, x, 0);
        }
        g.setClip(bottomLeftWidth, height - bottomHeight, width - bottomLeftWidth - bottomRightWidth, bottomHeight);
        for (x = bottomLeftWidth; x < width; x += bottomWidth) {
            AllIcons.Ide.Notification.Shadow.Bottom.paintIcon(component, g, x, height - bottomHeight);
        }
        g.setClip(0, topLeftHeight, AllIcons.Ide.Notification.Shadow.Left.getIconWidth(), height - topLeftHeight - bottomLeftHeight);
        for (y = topLeftHeight; y < height; y += leftHeight) {
            AllIcons.Ide.Notification.Shadow.Left.paintIcon(component, g, 0, y);
        }
        g.setClip(width - rightWidth, topRightHeight, rightWidth, height - topRightHeight - bottomRightHeight);
        for (y = topRightHeight; y < height; y += rightHeight) {
            AllIcons.Ide.Notification.Shadow.Right.paintIcon(component, g, width - rightWidth, y);
        }
        if (clipBounds == null) {
            g.setClip(null);
        } else {
            g.setClip(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        }
        AllIcons.Ide.Notification.Shadow.Top_left.paintIcon(component, g, 0, 0);
        AllIcons.Ide.Notification.Shadow.Top_right.paintIcon(component, g, width - topRightWidth, 0);
        AllIcons.Ide.Notification.Shadow.Bottom_right.paintIcon(component, g, width - bottomRightWidth, height - bottomRightHeight);
        AllIcons.Ide.Notification.Shadow.Bottom_left.paintIcon(component, g, 0, height - bottomLeftHeight);
    }

    @Override
    public void paintBorder(@NotNull Rectangle bounds, @NotNull Graphics2D g) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintBorder"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintBorder"));
        }
        g.setColor(this.myFillColor);
        g.fill(new Rectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height));
        g.setColor(this.myBorderColor);
        g.draw(new RoundRectangle2D.Double((double)bounds.x + 0.5, (double)bounds.y + 0.5, bounds.width - 1, bounds.height - 1, 3.0, 3.0));
    }
}

