/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalPathCellEditor
extends AbstractTableCellEditor {
    private final String myTitle;
    private final Project myProject;
    private FileChooserDescriptor myFileChooserDescriptor;
    private boolean myNormalizePath;
    protected CellEditorComponentWithBrowseButton<JTextField> myComponent;

    public LocalPathCellEditor(@Nullable String title, @Nullable Project project2) {
        this.myTitle = title;
        this.myProject = project2;
    }

    public LocalPathCellEditor(@Nullable Project project2) {
        this(null, project2);
    }

    public LocalPathCellEditor() {
        this(null, null);
    }

    public LocalPathCellEditor fileChooserDescriptor(@NotNull FileChooserDescriptor value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/ui/LocalPathCellEditor", "fileChooserDescriptor"));
        }
        this.myFileChooserDescriptor = value;
        return this;
    }

    public LocalPathCellEditor normalizePath(boolean value) {
        this.myNormalizePath = value;
        return this;
    }

    public Object getCellEditorValue() {
        String value = this.myComponent.getChildComponent().getText();
        return this.myNormalizePath ? PathUtil.toSystemDependentName((String)StringUtil.nullize((String)value)) : value;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.myComponent = new CellEditorComponentWithBrowseButton(new TextFieldWithBrowseButton(this.createActionListener(table)), (TableCellEditor)((Object)this));
        this.myComponent.getChildComponent().setText((String)value);
        return this.myComponent;
    }

    protected ActionListener createActionListener(final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String initial = (String)LocalPathCellEditor.this.getCellEditorValue();
                VirtualFile initialFile = StringUtil.isNotEmpty((String)initial) ? LocalFileSystem.getInstance().findFileByPath(initial) : null;
                FileChooser.chooseFile((FileChooserDescriptor)LocalPathCellEditor.this.getFileChooserDescriptor(), (Project)LocalPathCellEditor.this.myProject, (Component)table, (VirtualFile)initialFile, (Consumer)new Consumer<VirtualFile>(){

                    public void consume(VirtualFile file2) {
                        String path = file2.getPresentableUrl();
                        if (SystemInfo.isWindows && path.length() == 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
                            path = path + "\\";
                        }
                        LocalPathCellEditor.this.myComponent.getChildComponent().setText(path);
                    }
                });
            }
        };
    }

    public FileChooserDescriptor getFileChooserDescriptor() {
        if (this.myFileChooserDescriptor == null) {
            this.myFileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            if (this.myTitle != null) {
                this.myFileChooserDescriptor.setTitle(this.myTitle);
            }
            this.myFileChooserDescriptor.setShowFileSystemRoots(true);
        }
        return this.myFileChooserDescriptor;
    }
}

