/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.ConverterManagerImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.GenericDomValueReference;
import com.intellij.xml.util.XmlEnumeratedValueReferenceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenericValueReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.GenericValueReferenceProvider");

    @NotNull
    public final PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
        Object converter;
        DomInvocationHandler handler2;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
        }
        DomManagerImpl domManager = DomManagerImpl.getDomManager(psiElement.getProject());
        if (psiElement instanceof XmlTag) {
            handler2 = domManager.getDomHandler((XmlElement)((XmlTag)psiElement));
        } else if (psiElement instanceof XmlAttributeValue && psiElement.getParent() instanceof XmlAttribute) {
            handler2 = domManager.getDomHandler((XmlElement)((XmlAttribute)psiElement.getParent()));
        } else {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (handler2 == null || !GenericDomValue.class.isAssignableFrom(handler2.getRawType())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiElement instanceof XmlTag) {
            for (XmlText text : ((XmlTag)psiElement).getValue().getTextElements()) {
                if (!InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)text)) continue;
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        } else if (InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)psiElement)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GenericDomValue domValue = (GenericDomValue)handler2.getProxy();
        Referencing referencing = handler2.getAnnotation(Referencing.class);
        if (referencing == null) {
            converter = WrappingConverter.getDeepestConverter((Converter)domValue.getConverter(), (GenericDomValue)domValue);
        } else {
            Class clazz = referencing.value();
            converter = ((ConverterManagerImpl)domManager.getConverterManager()).getInstance(clazz);
        }
        PsiReference[] references = GenericValueReferenceProvider.createReferences(domValue, (XmlElement)psiElement, converter, handler2, domManager);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (PsiReference reference : references) {
                if (reference.isSoft()) continue;
                LOG.error("dom reference should be soft: " + reference + " (created by " + converter + ")");
            }
        }
        if (references.length > 0) {
            if (converter instanceof EnumConverter && !((EnumConverter)((Object)converter)).isExhaustive()) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            context.put(XmlEnumeratedValueReferenceProvider.SUPPRESS, (Object)Boolean.TRUE);
        }
        if (references == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "getReferencesByElement"));
        }
        return references;
    }

    private static PsiReference[] createReferences(GenericDomValue domValue, XmlElement psiElement, Object converter, DomInvocationHandler handler2, DomManager domManager) {
        XmlFile file2 = handler2.getFile();
        DomFileDescription description = domManager.getDomFileDescription(file2);
        if (description == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList();
        ConvertContext context = ConvertContextFactory.createConvertContext((DomElement)domValue);
        List injectors = description.getReferenceInjectors();
        if (!injectors.isEmpty()) {
            String unresolvedText = ElementManipulators.getValueText((PsiElement)psiElement);
            for (DomReferenceInjector each : injectors) {
                Collections.addAll(result, each.inject(unresolvedText, (PsiElement)psiElement, context));
            }
        }
        Collections.addAll(result, GenericValueReferenceProvider.doCreateReferences(domValue, psiElement, converter, context));
        return result.toArray(new PsiReference[result.size()]);
    }

    @NotNull
    private static PsiReference[] doCreateReferences(GenericDomValue domValue, XmlElement psiElement, Object converter, ConvertContext context) {
        PsiReference[] references;
        if (converter instanceof CustomReferenceConverter && ((references = ((CustomReferenceConverter)converter).createReferences(domValue, (PsiElement)psiElement, context)).length != 0 || !(converter instanceof ResolvingConverter))) {
            if (references == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
            }
            return references;
        }
        if (converter instanceof ResolvingConverter) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GenericDomValueReference(domValue)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/GenericValueReferenceProvider", "doCreateReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

