/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TimedVcsCommitImpl
implements TimedVcsCommit {
    @NotNull
    private final Hash myHash;
    @NotNull
    private final List<Hash> myParents;
    private final long myTime;

    public TimedVcsCommitImpl(@NotNull Hash hash, @NotNull List<Hash> parents, long timeStamp) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/impl/TimedVcsCommitImpl", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/vcs/log/impl/TimedVcsCommitImpl", "<init>"));
        }
        this.myHash = hash;
        this.myParents = parents;
        this.myTime = timeStamp;
    }

    @NotNull
    public final Hash getId() {
        Hash hash = this.myHash;
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/TimedVcsCommitImpl", "getId"));
        }
        return hash;
    }

    @NotNull
    public final List<Hash> getParents() {
        List<Hash> list = this.myParents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/TimedVcsCommitImpl", "getParents"));
        }
        return list;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimedVcsCommitImpl)) {
            return false;
        }
        return this.myHash.equals(((TimedVcsCommitImpl)obj).myHash);
    }

    public final int hashCode() {
        return this.myHash.hashCode();
    }

    public String toString() {
        return this.myHash.toShortString() + "|-" + StringUtil.join((Collection)ContainerUtil.map(this.myParents, (Function)new Function<Hash, String>(){

            public String fun(Hash hash) {
                return hash.toShortString();
            }
        }), (String)",") + ":" + this.myTime;
    }

    public final long getTimestamp() {
        return this.myTime;
    }
}

