/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUtil {
    public static final int MAX_SELECTED_COMMITS = 1000;

    @NotNull
    public static MultiMap<VirtualFile, VcsRef> groupRefsByRoot(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/impl/VcsLogUtil", "groupRefsByRoot"));
        }
        MultiMap<VirtualFile, VcsRef> multiMap = VcsLogUtil.groupByRoot(refs, new Function<VcsRef, VirtualFile>(){

            @NotNull
            public VirtualFile fun(@NotNull VcsRef ref) {
                if (ref == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/impl/VcsLogUtil$1", "fun"));
                }
                VirtualFile virtualFile = ref.getRoot();
                if (virtualFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil$1", "fun"));
                }
                return virtualFile;
            }
        });
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "groupRefsByRoot"));
        }
        return multiMap;
    }

    @NotNull
    public static <T extends VcsShortCommitDetails> MultiMap<VirtualFile, T> groupByRoot(@NotNull Collection<T> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/impl/VcsLogUtil", "groupByRoot"));
        }
        MultiMap<VirtualFile, T> multiMap = VcsLogUtil.groupByRoot(commits, new Function<T, VirtualFile>(){

            @NotNull
            public VirtualFile fun(@NotNull T commit) {
                if (commit == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/impl/VcsLogUtil$2", "fun"));
                }
                VirtualFile virtualFile = commit.getRoot();
                if (virtualFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil$2", "fun"));
                }
                return virtualFile;
            }
        });
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "groupByRoot"));
        }
        return multiMap;
    }

    @NotNull
    private static <T> MultiMap<VirtualFile, T> groupByRoot(@NotNull Collection<T> items, @NotNull Function<T, VirtualFile> rootGetter) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/vcs/log/impl/VcsLogUtil", "groupByRoot"));
        }
        if (rootGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootGetter", "com/intellij/vcs/log/impl/VcsLogUtil", "groupByRoot"));
        }
        MultiMap map = new MultiMap<VirtualFile, T>(){

            @NotNull
            protected Map<VirtualFile, Collection<T>> createMap() {
                TreeMap treeMap = new TreeMap(new Comparator<VirtualFile>(){

                    @Override
                    public int compare(@NotNull VirtualFile o1, @NotNull VirtualFile o2) {
                        if (o1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/vcs/log/impl/VcsLogUtil$3$1", "compare"));
                        }
                        if (o2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/vcs/log/impl/VcsLogUtil$3$1", "compare"));
                        }
                        return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
                    }
                });
                if (treeMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil$3", "createMap"));
                }
                return treeMap;
            }
        };
        for (T item : items) {
            map.putValue(rootGetter.fun(item), item);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "groupByRoot"));
        }
        return multiMap;
    }

    @NotNull
    public static List<Integer> getVisibleCommits(final @NotNull VisibleGraph<Integer> visibleGraph) {
        if (visibleGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleCommits"));
        }
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return (Integer)visibleGraph.getRowInfo(index).getCommit();
            }

            @Override
            public int size() {
                return visibleGraph.getVisibleCommitCount();
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleCommits"));
        }
        return abstractList;
    }

    public static int compareRoots(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
        if (root1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root1", "com/intellij/vcs/log/impl/VcsLogUtil", "compareRoots"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root2", "com/intellij/vcs/log/impl/VcsLogUtil", "compareRoots"));
        }
        return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
    }

    @NotNull
    private static Set<VirtualFile> collectRoots(@NotNull Collection<FilePath> files, @NotNull Set<VirtualFile> roots) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/impl/VcsLogUtil", "collectRoots"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogUtil", "collectRoots"));
        }
        HashSet<VirtualFile> selectedRoots = new HashSet<VirtualFile>();
        List sortedRoots = ContainerUtil.sorted(roots, (Comparator)new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile root1, VirtualFile root2) {
                return root1.getPath().compareTo(root2.getPath());
            }
        });
        for (FilePath filePath : files) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile != null && roots.contains(virtualFile)) {
                selectedRoots.add(virtualFile);
            } else {
                VirtualFile candidateAncestorRoot = null;
                for (VirtualFile root : sortedRoots) {
                    if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false)) continue;
                    candidateAncestorRoot = root;
                }
                if (candidateAncestorRoot != null) {
                    selectedRoots.add(candidateAncestorRoot);
                }
            }
            if (virtualFile == null) continue;
            for (VirtualFile root : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)root, (boolean)false)) continue;
                selectedRoots.add(root);
            }
        }
        HashSet<VirtualFile> hashSet = selectedRoots;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "collectRoots"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogUtil", "getAllVisibleRoots"));
        }
        if (rootFilter == null && structureFilter == null) {
            HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(roots);
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getAllVisibleRoots"));
            }
            return hashSet;
        }
        Set<VirtualFile> fromRootFilter = rootFilter != null ? rootFilter.getRoots() : roots;
        Set<VirtualFile> fromStructureFilter = structureFilter != null ? VcsLogUtil.collectRoots(structureFilter.getFiles(), new HashSet<VirtualFile>(roots)) : roots;
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(ContainerUtil.intersection((Collection)fromRootFilter, (Collection)fromStructureFilter));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getAllVisibleRoots"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<FilePath> getFilteredFilesForRoot(final @NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
        }
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
        }
        if (filterCollection.getStructureFilter() == null) {
            Set<FilePath> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
            }
            return set;
        }
        Collection files = filterCollection.getStructureFilter().getFiles();
        HashSet<FilePath> hashSet = new HashSet<FilePath>(ContainerUtil.filter((Collection)files, (Condition)new Condition<FilePath>(){

            public boolean value(FilePath filePath) {
                VirtualFile virtualFile = filePath.getVirtualFile();
                return root.equals(virtualFile) || FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false);
            }
        }));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
        }
        return hashSet;
    }

    @NotNull
    public static List<VcsFullCommitDetails> collectFirstPackOfLoadedSelectedDetails(@NotNull VcsLog log) {
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "com/intellij/vcs/log/impl/VcsLogUtil", "collectFirstPackOfLoadedSelectedDetails"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (VcsFullCommitDetails next : log.getSelectedDetails()) {
            if (next instanceof LoadingDetails) {
                List<VcsFullCommitDetails> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "collectFirstPackOfLoadedSelectedDetails"));
                }
                return list;
            }
            result.add(next);
            if (result.size() < 1000) continue;
            break;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "collectFirstPackOfLoadedSelectedDetails"));
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> collectFirstPack(@NotNull List<T> list, int max) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/vcs/log/impl/VcsLogUtil", "collectFirstPack"));
        }
        List<T> list2 = list.subList(0, Math.min(list.size(), max));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "collectFirstPack"));
        }
        return list2;
    }

    @NotNull
    public static Collection<VcsRef> getVisibleBranches(@NotNull VcsLog log, final @NotNull Set<VirtualFile> visibleRoots) {
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleBranches"));
        }
        if (visibleRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleRoots", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleBranches"));
        }
        List list = ContainerUtil.filter((Collection)log.getAllReferences(), (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return visibleRoots.contains(ref.getRoot());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleBranches"));
        }
        return list;
    }

    @NotNull
    public static Set<VirtualFile> getVisibleRoots(@NotNull VcsLogUiImpl logUi) {
        if (logUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logUi", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleRoots"));
        }
        VcsLogFilterCollection filters = logUi.getFilterUi().getFilters();
        Set<VirtualFile> roots = logUi.getDataPack().getLogProviders().keySet();
        Set<VirtualFile> set = VcsLogUtil.getAllVisibleRoots(roots, filters.getRootFilter(), filters.getStructureFilter());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleRoots"));
        }
        return set;
    }

    @Nullable
    public static String getSingleFilteredBranch(@NotNull VcsLogBranchFilter filter, @NotNull VcsLogRefs refs) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/impl/VcsLogUtil", "getSingleFilteredBranch"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/impl/VcsLogUtil", "getSingleFilteredBranch"));
        }
        String branchName = null;
        HashSet checkedRoots = ContainerUtil.newHashSet();
        for (VcsRef branch : refs.getBranches()) {
            if (!filter.matches(branch.getName())) continue;
            if (branchName == null) {
                branchName = branch.getName();
            } else if (!branch.getName().equals(branchName)) {
                return null;
            }
            if (checkedRoots.contains(branch.getRoot())) {
                return null;
            }
            checkedRoots.add(branch.getRoot());
        }
        return branchName;
    }
}

