/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import org.jetbrains.annotations.NotNull;

public class QuickEvaluateAction
extends XDebuggerActionBase {
    public QuickEvaluateAction() {
        super(true);
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        if (debuggerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerSupport", "com/intellij/xdebugger/impl/actions/QuickEvaluateAction", "getHandler"));
        }
        QuickEvaluateHandlerWrapper quickEvaluateHandlerWrapper = new QuickEvaluateHandlerWrapper(debuggerSupport.getQuickEvaluateHandler());
        if (quickEvaluateHandlerWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/QuickEvaluateAction", "getHandler"));
        }
        return quickEvaluateHandlerWrapper;
    }

    private static class QuickEvaluateHandlerWrapper
    extends DebuggerActionHandler {
        private final QuickEvaluateHandler myHandler;

        public QuickEvaluateHandlerWrapper(QuickEvaluateHandler handler2) {
            this.myHandler = handler2;
        }

        @Override
        public void perform(@NotNull Project project2, AnActionEvent event) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/QuickEvaluateAction$QuickEvaluateHandlerWrapper", "perform"));
            }
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
                ValueLookupManager.getInstance(project2).showHint(this.myHandler, editor, editor.logicalPositionToXY(logicalPosition), ValueHintType.MOUSE_CLICK_HINT);
            }
        }

        @Override
        public boolean isEnabled(@NotNull Project project2, AnActionEvent event) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/QuickEvaluateAction$QuickEvaluateHandlerWrapper", "isEnabled"));
            }
            if (!this.myHandler.isEnabled(project2)) {
                return false;
            }
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                return false;
            }
            return EditorGutter.KEY.getData(event.getDataContext()) == null;
        }
    }
}

