/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class RenameParameterFix
extends InspectionGadgetsFix {
    private final String m_targetName;

    public RenameParameterFix(String targetName) {
        this.m_targetName = targetName;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("renameto.quickfix", this.m_targetName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/RenameParameterFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Rename" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/RenameParameterFix", "getFamilyName"));
        }
        return "Rename";
    }

    @Override
    public void doFix(Project project2, ProblemDescriptor descriptor) {
        PsiElement nameIdentifier = descriptor.getPsiElement();
        PsiElement elementToRename = nameIdentifier.getParent();
        RefactoringFactory factory = RefactoringFactory.getInstance((Project)project2);
        RenameRefactoring renameRefactoring = factory.createRename(elementToRename, this.m_targetName);
        renameRefactoring.setSearchInComments(false);
        renameRefactoring.setSearchInNonJavaFiles(false);
        renameRefactoring.run();
    }
}

