/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class VariableAccessVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final Map<PsiField, Integer> m_accessCounts = new HashMap<PsiField, Integer>(2);
    private final Set<PsiField> m_overAccessedFields = new HashSet<PsiField>(2);

    VariableAccessVisitor() {
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
        Map<PsiField, Integer> accessCounts;
        Integer count;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/j2me/VariableAccessVisitor", "visitReferenceExpression"));
        }
        super.visitReferenceExpression(referenceExpression);
        PsiExpression qualifier = referenceExpression.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
            return;
        }
        PsiElement element = referenceExpression.resolve();
        if (!(element instanceof PsiField)) {
            return;
        }
        Set<PsiField> overAccessedFields = this.m_overAccessedFields;
        PsiField field = (PsiField)element;
        if (overAccessedFields.contains(field)) {
            return;
        }
        if (ControlFlowUtils.isInLoop((PsiElement)referenceExpression)) {
            overAccessedFields.add(field);
        }
        if ((count = (accessCounts = this.m_accessCounts).get(field)) == null) {
            accessCounts.put(field, 1);
        } else if (count == 1) {
            accessCounts.put(field, 2);
        } else {
            overAccessedFields.add(field);
        }
    }

    Set<PsiField> getOveraccessedFields() {
        return Collections.unmodifiableSet(this.m_overAccessedFields);
    }
}

