/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsReplaceableByObjectsCallInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EqualsReplaceableByObjectsCallFix((String)infos[0], (String)infos[1], (Boolean)infos[2]);
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsReplaceableByObjectsCallVisitor();
    }

    private static class EqualsReplaceableByObjectsCallVisitor
    extends BaseInspectionVisitor {
        private EqualsReplaceableByObjectsCallVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(expression.getLOperand(), false);
                if (variable == null) {
                    return;
                }
                PsiVariable otherVariable = EqualsReplaceableByObjectsCallVisitor.getArgumentFromEqualsCallOn(expression.getROperand(), variable);
                if (otherVariable == null) {
                    return;
                }
                this.checkEqualityBefore((PsiExpression)expression, true, variable, otherVariable);
            } else if (JavaTokenType.OROR.equals(tokenType)) {
                PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(expression.getLOperand(), true);
                if (variable == null) {
                    return;
                }
                PsiExpression rhs = ParenthesesUtils.stripParentheses(expression.getROperand());
                if (!(rhs instanceof PsiPrefixExpression)) {
                    return;
                }
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)rhs;
                if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                    return;
                }
                PsiVariable otherVariable = EqualsReplaceableByObjectsCallVisitor.getArgumentFromEqualsCallOn(prefixExpression.getOperand(), variable);
                if (otherVariable == null) {
                    return;
                }
                this.checkEqualityBefore((PsiExpression)expression, false, variable, otherVariable);
            }
        }

        private void checkEqualityBefore(PsiExpression expression, boolean equals, PsiVariable variable1, PsiVariable variable2) {
            PsiExpression lhs;
            PsiBinaryExpression binaryExpression;
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (parent instanceof PsiBinaryExpression && PsiTreeUtil.isAncestor((PsiElement)(binaryExpression = (PsiBinaryExpression)parent).getROperand(), (PsiElement)expression, (boolean)false) && EqualsReplaceableByObjectsCallVisitor.isEquality(lhs = binaryExpression.getLOperand(), equals, variable1, variable2)) {
                this.registerError((PsiElement)binaryExpression, variable1.getName(), variable2.getName(), equals);
                return;
            }
            this.registerError((PsiElement)expression, variable1.getName(), variable2.getName(), equals);
        }

        private static boolean isEquality(PsiExpression expression, boolean equals, PsiVariable variable1, PsiVariable variable2) {
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            if (equals ? !JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType()) : !JavaTokenType.NE.equals(binaryExpression.getOperationTokenType())) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            return VariableAccessUtils.evaluatesToVariable(lhs, variable1) && VariableAccessUtils.evaluatesToVariable(rhs, variable2) || VariableAccessUtils.evaluatesToVariable(lhs, variable2) && VariableAccessUtils.evaluatesToVariable(rhs, variable1);
        }

        private static PsiVariable getArgumentFromEqualsCallOn(PsiExpression expression, @NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor", "getArgumentFromEqualsCallOn"));
            }
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return null;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!VariableAccessUtils.evaluatesToVariable(qualifier, variable)) {
                return null;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 1) {
                return null;
            }
            return ExpressionUtils.getVariable(expressions[0]);
        }
    }

    private static class EqualsReplaceableByObjectsCallFix
    extends InspectionGadgetsFix {
        private final String myName1;
        private final String myName2;
        private final Boolean myEquals;

        public EqualsReplaceableByObjectsCallFix(String name1, String name2, Boolean equals) {
            this.myName1 = name1;
            this.myName2 = name2;
            this.myEquals = equals;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression expression = (PsiBinaryExpression)element;
            if (this.myEquals.booleanValue()) {
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression, "java.util.Objects.equals(" + this.myName1 + "," + this.myName2 + ")");
            } else {
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression, "!java.util.Objects.equals(" + this.myName1 + "," + this.myName2 + ")");
            }
        }
    }
}

