/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class IndexedForEachLoopPredicate
implements PsiElementPredicate {
    IndexedForEachLoopPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        IElementType tokenType = token.getTokenType();
        if (!JavaTokenType.FOR_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiForeachStatement)) {
            return false;
        }
        PsiForeachStatement foreachStatement = (PsiForeachStatement)parent;
        PsiExpression iteratedValue = foreachStatement.getIteratedValue();
        if (iteratedValue == null) {
            return false;
        }
        PsiType type = iteratedValue.getType();
        if (!(type instanceof PsiArrayType)) {
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return false;
            }
            Project project2 = element.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiClass listInterface = psiFacade.findClass("java.util.List", GlobalSearchScope.allScope((Project)project2));
            if (listInterface == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)listInterface, (boolean)true)) {
                return false;
            }
        }
        return !ErrorUtil.containsError(parent);
    }
}

