/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.intellij.images.ImagesBundle;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.ExternalEditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.options.impl.OptionsImpl;

final class OptionsUIForm {
    private JPanel contentPane;
    private JCheckBox showGrid;
    private JLabel gridLineZoomFactorlLabel;
    private JSpinner gridLineZoomFactor;
    private JLabel gridLineSpanLabel;
    private JSpinner gridLineSpan;
    private JCheckBox showChessboard;
    private JSpinner chessboardSize;
    private JLabel chessboardSizeLabel;
    private JCheckBox wheelZooming;
    private JCheckBox smartZooming;
    private JSpinner smartZoomingWidth;
    private JLabel smartZoomingWidthLabel;
    private JSpinner smartZoomingHeight;
    private JLabel smartZoomingHeightLabel;
    private JLabel gridLineColorLabel;
    private ColorPanel gridLineColor;
    private JLabel chessboardWhiteColorLabel;
    private JLabel chessboardBlackColorLabel;
    private ColorPanel chessboardBlackColor;
    private ColorPanel chessboardWhiteColor;
    private JLabel externalEditorLabel;
    private TextFieldWithBrowseButton externalEditorPath;
    private final Options options;

    OptionsUIForm() {
        this.$$$setupUI$$$();
        this.options = new OptionsImpl();
        this.wheelZooming.setText(ImagesBundle.message("enable.mousewheel.zooming", SystemInfo.isMac ? "Cmd" : "Ctrl"));
        this.gridLineZoomFactorlLabel.setLabelFor(this.gridLineZoomFactor);
        this.gridLineSpanLabel.setLabelFor(this.gridLineSpan);
        this.chessboardSizeLabel.setLabelFor(this.chessboardSize);
        this.smartZoomingWidthLabel.setLabelFor(this.smartZoomingWidth);
        this.smartZoomingHeightLabel.setLabelFor(this.smartZoomingHeight);
        this.gridLineColorLabel.setLabelFor((Component)this.gridLineColor);
        this.chessboardWhiteColorLabel.setLabelFor((Component)this.chessboardWhiteColor);
        this.chessboardBlackColorLabel.setLabelFor((Component)this.chessboardBlackColor);
        this.externalEditorLabel.setLabelFor((Component)this.externalEditorPath);
        this.smartZooming.addItemListener(new LinkEnabledListener(new JComponent[]{this.smartZoomingHeightLabel, this.smartZoomingHeight, this.smartZoomingWidthLabel, this.smartZoomingWidth}));
        this.gridLineZoomFactor.setModel(new SpinnerNumberModel(3, 2, 8, 1));
        this.gridLineSpan.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.chessboardSize.setModel(new SpinnerNumberModel(5, 1, 100, 1));
        this.smartZoomingWidth.setModel(new SpinnerNumberModel(ZoomOptions.DEFAULT_PREFFERED_SIZE.width, 1, 9999, 1));
        this.smartZoomingHeight.setModel(new SpinnerNumberModel(ZoomOptions.DEFAULT_PREFFERED_SIZE.height, 1, 9999, 1));
        this.showGrid.addItemListener(new CheckboxOptionsListener("Editor.Grid.showDefault"));
        this.gridLineZoomFactor.addChangeListener(new SpinnerOptionsListener("Editor.Grid.lineZoomFactor"));
        this.gridLineSpan.addChangeListener(new SpinnerOptionsListener("Editor.Grid.lineSpan"));
        this.showChessboard.addItemListener(new CheckboxOptionsListener("Editor.TransparencyChessboard.showDefault"));
        this.chessboardSize.addChangeListener(new SpinnerOptionsListener("Editor.TransparencyChessboard.cellSize"));
        this.wheelZooming.addItemListener(new CheckboxOptionsListener("Editor.Zoom.wheelZooming"));
        this.smartZooming.addItemListener(new CheckboxOptionsListener("Editor.Zoom.smartZooming"));
        this.smartZoomingWidth.addChangeListener(new SpinnerOptionsListener("Editor.Zoom.prefferedWidth"));
        this.smartZoomingHeight.addChangeListener(new SpinnerOptionsListener("Editor.Zoom.prefferedHeight"));
        this.gridLineColor.addActionListener((ActionListener)new ColorOptionsListener("Editor.Grid.lineColor"));
        this.chessboardWhiteColor.addActionListener((ActionListener)new ColorOptionsListener("Editor.TransparencyChessboard.whiteColor"));
        this.chessboardBlackColor.addActionListener((ActionListener)new ColorOptionsListener("Editor.TransparencyChessboard.blackColor"));
        this.externalEditorPath.getTextField().getDocument().addDocumentListener((DocumentListener)((Object)new TextDocumentOptionsListener("ExternalEditor.executablePath")));
        this.externalEditorPath.addActionListener((ActionListener)new ExternalEditorPathActionListener());
        this.updateUI();
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public Options getOptions() {
        return this.options;
    }

    public void updateUI() {
        EditorOptions editorOptions = this.options.getEditorOptions();
        ExternalEditorOptions externalEditorOptions = this.options.getExternalEditorOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        this.showGrid.setSelected(gridOptions.isShowDefault());
        this.gridLineZoomFactor.setValue(gridOptions.getLineZoomFactor());
        this.gridLineSpan.setValue(gridOptions.getLineSpan());
        this.gridLineColor.setSelectedColor(gridOptions.getLineColor());
        TransparencyChessboardOptions transparencyChessboardOptions = editorOptions.getTransparencyChessboardOptions();
        this.showChessboard.setSelected(transparencyChessboardOptions.isShowDefault());
        this.chessboardSize.setValue(transparencyChessboardOptions.getCellSize());
        this.chessboardWhiteColor.setSelectedColor(transparencyChessboardOptions.getWhiteColor());
        this.chessboardBlackColor.setSelectedColor(transparencyChessboardOptions.getBlackColor());
        ZoomOptions zoomOptions = editorOptions.getZoomOptions();
        this.wheelZooming.setSelected(zoomOptions.isWheelZooming());
        this.smartZooming.setSelected(zoomOptions.isSmartZooming());
        Dimension prefferedSize = zoomOptions.getPrefferedSize();
        this.smartZoomingWidth.setValue(prefferedSize.width);
        this.smartZoomingHeight.setValue(prefferedSize.height);
        this.externalEditorPath.setText(externalEditorOptions.getExecutablePath());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        ColorPanel colorPanel;
        JLabel jLabel2;
        ColorPanel colorPanel2;
        ColorPanel colorPanel3;
        JLabel jLabel3;
        JLabel jLabel4;
        JSpinner jSpinner;
        JLabel jLabel5;
        JSpinner jSpinner2;
        JLabel jLabel6;
        JSpinner jSpinner3;
        JSpinner jSpinner4;
        JSpinner jSpinner5;
        JLabel jLabel7;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JLabel jLabel8;
        JLabel jLabel9;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(12, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(true);
        ((Component)jPanel2).setEnabled(true);
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("main.page.border.title"), (int)0, (int)0, null, null));
        this.smartZoomingWidthLabel = jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("settings.preffered.smart.zoom.width"));
        jPanel2.add((Component)jLabel9, new GridConstraints(10, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.smartZoomingHeightLabel = jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("settings.preffered.smart.zoom.height"));
        jPanel2.add((Component)jLabel8, new GridConstraints(11, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.showGrid = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("show.grid.lines"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.showChessboard = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("show.transparency.chessboard"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(4, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.wheelZooming = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("enable.mousewheel.zooming"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(8, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.smartZooming = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("smart.zoom"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(9, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.chessboardSizeLabel = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("chessboard.cell.size"));
        jPanel2.add((Component)jLabel7, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.chessboardSize = jSpinner5 = new JSpinner();
        jPanel2.add((Component)jSpinner5, new GridConstraints(5, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        this.smartZoomingWidth = jSpinner4 = new JSpinner();
        jPanel2.add((Component)jSpinner4, new GridConstraints(10, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        this.smartZoomingHeight = jSpinner3 = new JSpinner();
        jPanel2.add((Component)jSpinner3, new GridConstraints(11, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        this.gridLineSpanLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("show.grid.every"));
        jPanel2.add((Component)jLabel6, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.gridLineSpan = jSpinner2 = new JSpinner();
        jPanel2.add((Component)jSpinner2, new GridConstraints(2, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        this.gridLineZoomFactorlLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("show.grid.zoom.limit"));
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.gridLineZoomFactor = jSpinner = new JSpinner();
        jPanel2.add((Component)jSpinner, new GridConstraints(1, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("");
        jPanel2.add((Component)jLabel10, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 1, new Dimension(22, -1), null, new Dimension(22, -1)));
        this.chessboardWhiteColorLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("white.cell.color"));
        jPanel2.add((Component)jLabel4, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.chessboardBlackColorLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("black.cell.color"));
        jPanel2.add((Component)jLabel3, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.chessboardWhiteColor = colorPanel3 = new ColorPanel();
        jPanel2.add((Component)colorPanel3, new GridConstraints(6, 2, 1, 2, 8, 0, 0, 0, null, null, null));
        this.chessboardBlackColor = colorPanel2 = new ColorPanel();
        jPanel2.add((Component)colorPanel2, new GridConstraints(7, 2, 1, 2, 8, 0, 0, 0, null, null, null));
        this.gridLineColorLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("grid.line.color"));
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.gridLineColor = colorPanel = new ColorPanel();
        jPanel2.add((Component)colorPanel, new GridConstraints(3, 2, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("external.editor.border.title"), (int)0, (int)0, null, null));
        this.externalEditorLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/intellij/images/ImagesBundle").getString("external.editor.executable.path"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.externalEditorPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 2, 1, 1, 0, 1, 7, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, new Dimension(22, -1), null, new Dimension(22, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private final class ExternalEditorPathActionListener
    implements ActionListener {
        private ExternalEditorPathActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Application application = ApplicationManager.getApplication();
            VirtualFile previous = (VirtualFile)application.runWriteAction((Computable)new NullableComputable<VirtualFile>(){

                public VirtualFile compute() {
                    String path = FileUtil.toSystemIndependentName((String)OptionsUIForm.this.externalEditorPath.getText());
                    return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                }
            });
            FileChooserDescriptor fileDescriptor = new FileChooserDescriptor(true, SystemInfo.isMac, false, false, false, false);
            fileDescriptor.setShowFileSystemRoots(true);
            fileDescriptor.setTitle(ImagesBundle.message("select.external.executable.title", new Object[0]));
            fileDescriptor.setDescription(ImagesBundle.message("select.external.executable.message", new Object[0]));
            FileChooser.chooseFiles((FileChooserDescriptor)fileDescriptor, null, (VirtualFile)previous, (Consumer)new Consumer<List<VirtualFile>>(){

                public void consume(List<VirtualFile> files) {
                    String path = files.get(0).getPath();
                    OptionsUIForm.this.externalEditorPath.setText(path);
                }
            });
        }
    }

    private final class TextDocumentOptionsListener
    extends DocumentAdapter {
        private final String name;

        public TextDocumentOptionsListener(String name) {
            this.name = name;
        }

        protected void textChanged(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            Position startPosition = document.getStartPosition();
            try {
                OptionsUIForm.this.options.setOption(this.name, document.getText(startPosition.getOffset(), document.getLength()));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private final class ColorOptionsListener
    implements ActionListener {
        private final String name;

        private ColorOptionsListener(String name) {
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorPanel source = (ColorPanel)e.getSource();
            OptionsUIForm.this.options.setOption(this.name, source.getSelectedColor());
        }
    }

    private final class SpinnerOptionsListener
    implements ChangeListener {
        private final String name;

        private SpinnerOptionsListener(String name) {
            this.name = name;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSpinner source = (JSpinner)e.getSource();
            OptionsUIForm.this.options.setOption(this.name, source.getValue());
        }
    }

    private final class CheckboxOptionsListener
    implements ItemListener {
        private final String name;

        private CheckboxOptionsListener(String name) {
            this.name = name;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            OptionsUIForm.this.options.setOption(this.name, 1 == e.getStateChange());
        }
    }

    private static class LinkEnabledListener
    implements ItemListener {
        private final JComponent[] children;

        LinkEnabledListener(JComponent[] children2) {
            this.children = (JComponent[])children2.clone();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.setSelected(e.getStateChange() == 1);
        }

        private void setSelected(boolean selected) {
            for (JComponent component : this.children) {
                component.setEnabled(selected);
            }
        }
    }
}

