/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u000e\u001a\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0011H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"ARRAY_DESCRIPTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "VariableView", "Lorg/jetbrains/debugger/VariableView;", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "createNumberPresentation", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "value", "", "getClassName", "Lorg/jetbrains/debugger/values/ObjectValue;", "getObjectValueDescription", "trimFunctionDescription", "Lorg/jetbrains/debugger/values/Value;", "script-debugger-ui"})
public final class VariableViewKt {
    private static final Pattern ARRAY_DESCRIPTION_PATTERN = Pattern.compile("^[a-zA-Z\\d]+\\[\\d+\\]$");

    @NotNull
    public static final VariableView VariableView(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = variable.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name");
        return new VariableView(string, variable, context);
    }

    @NotNull
    public static final String getClassName(@NotNull ObjectValue value) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String className = value.getClassName();
        CharSequence $receiver$iv = className;
        if ($receiver$iv == null || $receiver$iv.length() == 0) {
            string = "Object";
        } else {
            string = className;
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        return string;
    }

    @NotNull
    public static final String getObjectValueDescription(@NotNull ObjectValue value) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String description = value.getValueString();
        CharSequence $receiver$iv = description;
        if ($receiver$iv == null || $receiver$iv.length() == 0) {
            string = VariableViewKt.getClassName(value);
        } else {
            string = description;
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String trimFunctionDescription(@NotNull Value value) {
        void startIndex$iv;
        void $receiver$iv;
        int endIndex;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value.getValueString();
        if (string == null) {
            return "";
        }
        String presentableValue = string;
        for (endIndex = 0; endIndex < presentableValue.length() && !StringUtil.isLineBreak((char)presentableValue.charAt(endIndex)); ++endIndex) {
        }
        while (endIndex > 0 && Character.isWhitespace(presentableValue.charAt(endIndex - 1))) {
            --endIndex;
        }
        String string2 = presentableValue;
        boolean bl = false;
        void v1 = $receiver$iv;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)v1).substring((int)startIndex$iv, endIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    private static final XValuePresentation createNumberPresentation(String value) {
        return Intrinsics.areEqual((Object)value, (Object)"NaN") || Intrinsics.areEqual((Object)value, (Object)"Infinity") ? (XValuePresentation)new XKeywordValuePresentation(value) : (XValuePresentation)new XNumericValuePresentation(value);
    }

    @NotNull
    public static final /* synthetic */ XValuePresentation access$createNumberPresentation(@NotNull String value) {
        return VariableViewKt.createNumberPresentation(value);
    }

    public static final /* synthetic */ Pattern access$getARRAY_DESCRIPTION_PATTERN$p() {
        return ARRAY_DESCRIPTION_PATTERN;
    }
}

