/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class JavaFxEventHandlerReference
extends PsiReferenceBase<XmlAttributeValue> {
    private final PsiClass myCurrentTagClass;
    private final PsiMethod myEventHandler;
    private final PsiClass myController;

    public JavaFxEventHandlerReference(XmlAttributeValue element, PsiClass currentTagClass, PsiMethod method, PsiClass controller) {
        super((PsiElement)element);
        this.myCurrentTagClass = currentTagClass;
        this.myEventHandler = method;
        this.myController = controller;
    }

    @Nullable
    public PsiElement resolve() {
        return this.myEventHandler;
    }

    @NotNull
    public Object[] getVariants() {
        if (this.myController == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiMethod> availableHandlers = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : this.myController.getMethods()) {
            if (!JavaFxEventHandlerReference.isHandlerMethod(psiMethod)) continue;
            availableHandlers.add(psiMethod);
        }
        Object[] objectArray = availableHandlers.isEmpty() ? EMPTY_ARRAY : ArrayUtil.toObjectArray(availableHandlers);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference", "getVariants"));
        }
        return objectArray;
    }

    public static boolean isHandlerMethod(PsiMethod psiMethod) {
        if (!psiMethod.hasModifierProperty("static") && PsiType.VOID.equals((Object)psiMethod.getReturnType())) {
            PsiType parameterType;
            PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
            if (parameters.length == 1 && InheritanceUtil.isInheritor((PsiType)(parameterType = parameters[0].getType()), (String)"javafx.event.Event")) {
                return true;
            }
            return parameters.length == 0;
        }
        return false;
    }

    public TextRange getRangeInElement() {
        TextRange range = super.getRangeInElement();
        return new TextRange(range.getStartOffset() + 1, range.getEndOffset());
    }

    public static class JavaFxUnresolvedReferenceHandlerQuickfixProvider
    extends UnresolvedReferenceQuickFixProvider<JavaFxEventHandlerReference> {
        public void registerFixes(@NotNull JavaFxEventHandlerReference ref, @NotNull QuickFixActionRegistrar registrar) {
            CreateMethodQuickFix quickFix;
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference$JavaFxUnresolvedReferenceHandlerQuickfixProvider", "registerFixes"));
            }
            if (registrar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference$JavaFxUnresolvedReferenceHandlerQuickfixProvider", "registerFixes"));
            }
            if (ref.myController != null && ref.myEventHandler == null && (quickFix = CreateMethodQuickFix.createFix((PsiClass)ref.myController, (String)JavaFxUnresolvedReferenceHandlerQuickfixProvider.getHandlerSignature(ref), (String)"")) != null) {
                registrar.register((IntentionAction)quickFix);
            }
        }

        private static String getHandlerSignature(JavaFxEventHandlerReference ref) {
            XmlAttributeValue element = (XmlAttributeValue)ref.getElement();
            String canonicalText = "javafx.event.Event";
            PsiElement parent = element.getParent();
            if (parent instanceof XmlAttribute) {
                PsiClassType classType;
                XmlAttribute xmlAttribute = (XmlAttribute)parent;
                Project project = element.getProject();
                PsiField handlerField = ref.myCurrentTagClass.findFieldByName(xmlAttribute.getName(), true);
                if (handlerField != null && (classType = JavaFxPsiUtil.getPropertyClassType((PsiElement)handlerField)) != null) {
                    PsiTypeParameter[] typeParameters;
                    PsiClass eventHandlerClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.event.EventHandler", GlobalSearchScope.allScope((Project)project));
                    PsiTypeParameter[] psiTypeParameterArray = typeParameters = eventHandlerClass != null ? eventHandlerClass.getTypeParameters() : null;
                    if (typeParameters != null && typeParameters.length == 1) {
                        PsiTypeParameter typeParameter = typeParameters[0];
                        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)eventHandlerClass, (PsiClassType)classType);
                        PsiType eventType = substitutor.substitute(typeParameter);
                        if (eventType != null) {
                            canonicalText = eventType.getCanonicalText();
                        }
                    }
                }
            }
            return "public void " + element.getValue().substring(1) + "(" + canonicalText + " e)";
        }

        @NotNull
        public Class<JavaFxEventHandlerReference> getReferenceClass() {
            if (JavaFxEventHandlerReference.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference$JavaFxUnresolvedReferenceHandlerQuickfixProvider", "getReferenceClass"));
            }
            return JavaFxEventHandlerReference.class;
        }
    }
}

