/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Deque;

public final class UniformStreamByteDistributor
implements StreamByteDistributor {
    static final int DEFAULT_MIN_ALLOCATION_CHUNK = 1024;
    private final Http2Connection.PropertyKey stateKey;
    private final Deque<State> queue = new ArrayDeque<State>(4);
    private int minAllocationChunk = 1024;
    private long totalStreamableBytes;

    public UniformStreamByteDistributor(Http2Connection connection) {
        ObjectUtil.checkNotNull(connection, "connection");
        this.stateKey = connection.newKey();
        Http2Stream connectionStream = connection.connectionStream();
        connectionStream.setProperty(this.stateKey, new State(connectionStream));
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream stream) {
                stream.setProperty(UniformStreamByteDistributor.this.stateKey, new State(stream));
            }

            @Override
            public void onStreamClosed(Http2Stream stream) {
                UniformStreamByteDistributor.this.state(stream).close();
            }
        });
    }

    public void minAllocationChunk(int minAllocationChunk) {
        if (minAllocationChunk <= 0) {
            throw new IllegalArgumentException("minAllocationChunk must be > 0");
        }
        this.minAllocationChunk = minAllocationChunk;
    }

    @Override
    public void updateStreamableBytes(StreamByteDistributor.StreamState streamState) {
        State state = this.state(streamState.stream());
        state.updateStreamableBytes(streamState.streamableBytes(), streamState.hasFrame());
    }

    @Override
    public boolean distribute(int maxBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
        ObjectUtil.checkNotNull(writer, "writer");
        int size = this.queue.size();
        if (size == 0) {
            return this.totalStreamableBytes > 0L;
        }
        int chunkSize = Math.max(this.minAllocationChunk, maxBytes / size);
        State state = this.queue.pollFirst();
        do {
            state.enqueued = false;
            if (state.streamableBytes > 0 && maxBytes == 0) {
                this.queue.addFirst(state);
                state.enqueued = true;
                break;
            }
            int chunk = Math.min(chunkSize, Math.min(maxBytes, state.streamableBytes));
            maxBytes -= chunk;
            state.write(chunk, writer);
        } while ((state = this.queue.pollFirst()) != null);
        return this.totalStreamableBytes > 0L;
    }

    private State state(Http2Stream stream) {
        return (State)ObjectUtil.checkNotNull(stream, "stream").getProperty(this.stateKey);
    }

    private final class State {
        final Http2Stream stream;
        int streamableBytes;
        boolean enqueued;

        State(Http2Stream stream) {
            this.stream = stream;
        }

        void updateStreamableBytes(int newStreamableBytes, boolean hasFrame) {
            assert (hasFrame || newStreamableBytes == 0);
            int delta = newStreamableBytes - this.streamableBytes;
            if (delta != 0) {
                this.streamableBytes = newStreamableBytes;
                UniformStreamByteDistributor.this.totalStreamableBytes += delta;
            }
            if (hasFrame) {
                this.addToQueue();
            }
        }

        void write(int numBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
            int newStreamableBytes;
            this.updateStreamableBytes(newStreamableBytes, (newStreamableBytes = this.streamableBytes - numBytes) > 0);
            try {
                writer.write(this.stream, numBytes);
            }
            catch (Throwable t) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, t, "byte distribution write error", new Object[0]);
            }
        }

        void addToQueue() {
            if (!this.enqueued) {
                this.enqueued = true;
                UniformStreamByteDistributor.this.queue.addLast(this);
            }
        }

        void removeFromQueue() {
            if (this.enqueued) {
                this.enqueued = false;
                UniformStreamByteDistributor.this.queue.remove(this);
            }
        }

        void close() {
            this.removeFromQueue();
            this.updateStreamableBytes(0, false);
        }
    }
}

