/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.core;

import java.lang.reflect.Method;
import javax.swing.JComponent;

public final class SupportCode {
    public static TextWithMnemonic parseText(String textWithMnemonic) {
        if (textWithMnemonic == null) {
            throw new IllegalArgumentException("textWithMnemonic cannot be null");
        }
        int index2 = -1;
        StringBuffer plainText = new StringBuffer();
        for (int i = 0; i < textWithMnemonic.length(); ++i) {
            char ch = textWithMnemonic.charAt(i);
            if (ch == '&') {
                if (++i >= textWithMnemonic.length()) break;
                ch = textWithMnemonic.charAt(i);
                if (ch != '&') {
                    index2 = plainText.length();
                }
            }
            plainText.append(ch);
        }
        return new TextWithMnemonic(plainText.toString(), index2);
    }

    public static void setDisplayedMnemonicIndex(JComponent component, int index2) {
        try {
            Method method = component.getClass().getMethod("setDisplayedMnemonicIndex", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)component, new Integer(index2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final class TextWithMnemonic {
        public final String myText;
        public final int myMnemonicIndex;

        private TextWithMnemonic(String text2, int index2) {
            if (text2 == null) {
                throw new IllegalArgumentException("text cannot be null");
            }
            if (index2 != -1 && (index2 < 0 || index2 >= text2.length())) {
                throw new IllegalArgumentException("wrong index: " + index2 + "; text = '" + text2 + "'");
            }
            this.myText = text2;
            this.myMnemonicIndex = index2;
        }

        public char getMnemonicChar() {
            if (this.myMnemonicIndex == -1) {
                throw new IllegalStateException("text doesn't contain mnemonic");
            }
            return Character.toUpperCase(this.myText.charAt(this.myMnemonicIndex));
        }
    }
}

