/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.KotlinOutputParserHelper;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u001a \u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u001a,\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0001H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0001H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0006*\u00020\u0001H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"COLON", "", "POSITION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "addMessage", "", "message", "", "messages", "", "parse", "line", "reader", "Lcom/android/ide/common/blame/parser/util/OutputLineReader;", "logger", "Lcom/android/utils/ILogger;", "amendNextLinesIfNeeded", "colon", "", "isNextMessage", "skipDriveOnWin", "startsWithSeverityPrefix", "substringAfterAndTrim", "index", "substringBeforeAndTrim", "kotlin-android-plugin"})
public final class KotlinOutputParserHelperKt {
    private static final String COLON = ":";
    private static final Pattern POSITION_PATTERN;

    public static final boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Object> messages, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        int colonIndex1 = KotlinOutputParserHelperKt.colon(line);
        if (colonIndex1 < 0) {
            return false;
        }
        String severity = KotlinOutputParserHelperKt.substringBeforeAndTrim(line, colonIndex1);
        if (!KotlinOutputParserHelperKt.startsWithSeverityPrefix(severity)) {
            return false;
        }
        String lineWoSeverity = KotlinOutputParserHelperKt.substringAfterAndTrim(line, colonIndex1);
        int colonIndex2 = KotlinOutputParserHelperKt.skipDriveOnWin(KotlinOutputParserHelperKt.colon(lineWoSeverity), lineWoSeverity);
        if (colonIndex2 >= 0) {
            String path = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoSeverity, colonIndex2);
            File file = new File(path);
            if (!file.isFile() && Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)file.getName()), (Object)"kt") ^ true) {
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelper.createMessage$default(KotlinOutputParserHelper.INSTANCE, logger, severity, KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader), null, null, null, null, 120, null), messages);
            }
            String lineWoPath = KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoSeverity, colonIndex2);
            int colonIndex3 = KotlinOutputParserHelperKt.colon(lineWoPath);
            if (colonIndex3 >= 0) {
                String position = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoPath, colonIndex3);
                Matcher matcher2 = POSITION_PATTERN.matcher(position);
                String message2 = KotlinOutputParserHelperKt.amendNextLinesIfNeeded(KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoPath, colonIndex3), reader);
                if (matcher2.matches()) {
                    String lineNumber = matcher2.group(1);
                    String symbolNumber = matcher2.group(2);
                    if (lineNumber != null && symbolNumber != null) {
                        try {
                            String $receiver$iv;
                            String string = lineNumber;
                            String string2 = path;
                            String string3 = message2;
                            String string4 = severity;
                            ILogger iLogger = logger;
                            KotlinOutputParserHelper kotlinOutputParserHelper = KotlinOutputParserHelper.INSTANCE;
                            int n = Integer.parseInt($receiver$iv);
                            $receiver$iv = symbolNumber;
                            Integer n2 = n;
                            int n3 = Integer.parseInt($receiver$iv);
                            $receiver$iv = symbolNumber;
                            Integer n4 = n3;
                            int n5 = Integer.parseInt($receiver$iv);
                            return KotlinOutputParserHelperKt.addMessage(kotlinOutputParserHelper.createMessage(iLogger, string4, string3, string2, n2, n4, n5), messages);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelper.createMessage$default(KotlinOutputParserHelper.INSTANCE, logger, severity, message2, null, null, null, null, 120, null), messages);
            }
            return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelper.createMessage$default(KotlinOutputParserHelper.INSTANCE, logger, severity, KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader), null, null, null, null, 120, null), messages);
        }
        return false;
    }

    private static final String amendNextLinesIfNeeded(String $receiver, OutputLineReader reader) {
        String nextLine = reader.readLine();
        StringBuilder builder = new StringBuilder($receiver);
        while (nextLine != null && !KotlinOutputParserHelperKt.isNextMessage(nextLine)) {
            builder.append("\n").append(nextLine);
            if (!reader.hasNextLine()) break;
            nextLine = reader.readLine();
        }
        if (nextLine != null) {
            Field field2;
            try {
                field2 = reader.getClass().getDeclaredField("myPosition");
            }
            catch (Throwable e) {
                field2 = null;
            }
            Field positionField = field2;
            if (positionField != null) {
                positionField.setAccessible(true);
                positionField.setInt(reader, positionField.getInt(reader) - 1);
            }
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNextMessage(String $receiver) {
        int colonIndex1 = StringsKt.indexOf$default((CharSequence)$receiver, (String)COLON, (int)0, (boolean)false, (int)6, null);
        if (colonIndex1 == 0) return true;
        if (colonIndex1 >= 0) {
            void $receiver$iv;
            String string = $receiver;
            int startIndex$iv = 0;
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)v0).substring(startIndex$iv, colonIndex1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (KotlinOutputParserHelperKt.startsWithSeverityPrefix(string2)) return true;
        }
        if (StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILURE")) return true;
        if (!StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILED")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean startsWithSeverityPrefix(String $receiver) {
        String $receiver$iv = $receiver;
        String string = $receiver$iv;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        switch (string2.hashCode()) {
            case 119: {
                if (!string2.equals("w")) return false;
                return true;
            }
            case 118: {
                if (!string2.equals("v")) return false;
                return true;
            }
            case 101: {
                if (!string2.equals("e")) return false;
                return true;
            }
            case 105: {
                if (!string2.equals("i")) return false;
                return true;
            }
        }
        return false;
    }

    private static final String substringAfterAndTrim(String $receiver, int index2) {
        String $receiver$iv;
        String string = $receiver;
        int startIndex$iv = index2 + 1;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)v0).substring(startIndex$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        $receiver$iv = string2;
        String string3 = $receiver$iv;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    private static final String substringBeforeAndTrim(String $receiver, int index2) {
        String $receiver$iv;
        String string = $receiver;
        int startIndex$iv = 0;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)v0).substring(startIndex$iv, index2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        $receiver$iv = string2;
        String string3 = $receiver$iv;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    private static final int colon(String $receiver) {
        return StringsKt.indexOf$default((CharSequence)$receiver, (String)COLON, (int)0, (boolean)false, (int)6, null);
    }

    private static final int skipDriveOnWin(int $receiver, String line) {
        return $receiver == 1 ? StringsKt.indexOf$default((CharSequence)line, (String)COLON, (int)($receiver + 1), (boolean)false, (int)4, null) : $receiver;
    }

    private static final boolean addMessage(Object message2, List<Object> messages) {
        if (message2 == null) {
            return false;
        }
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            Object lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = Intrinsics.areEqual((Object)lastMessage, (Object)message2);
        }
        if (!duplicatesPrevious) {
            messages.add(message2);
        }
        return true;
    }

    static {
        COLON = COLON;
        POSITION_PATTERN = Pattern.compile("\\(([0-9]*), ([0-9]*)\\)");
    }
}

