/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.builtins.BuiltinsPackageFragment;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u000bH\u0002J.\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u000b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u000bJ$\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u000bH\u0002J\f\u0010\u001a\u001a\u00020\r*\u00020\u0012H\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/AllClassesCompletion;", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "kotlinIndicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "kindFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;Lcom/intellij/codeInsight/completion/PrefixMatcher;Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;Lkotlin/jvm/functions/Function1;)V", "addAdaptedJavaCompletion", "", "collector", "Lcom/intellij/psi/PsiClass;", "collect", "classDescriptorCollector", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "javaClassCollector", "collectClassesFromScope", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "isSyntheticKotlinClass", "idea-completion"})
public final class AllClassesCompletion {
    private final CompletionParameters parameters;
    private final KotlinIndicesHelper kotlinIndicesHelper;
    private final PrefixMatcher prefixMatcher;
    private final ResolutionFacade resolutionFacade;
    private final Function1<ClassKind, Boolean> kindFilter;

    public final void collect(@NotNull Function1<? super ClassDescriptor, Unit> classDescriptorCollector, @NotNull Function1<? super PsiClass, Unit> javaClassCollector) {
        Intrinsics.checkParameterIsNotNull(classDescriptorCollector, (String)"classDescriptorCollector");
        Intrinsics.checkParameterIsNotNull(javaClassCollector, (String)"javaClassCollector");
        for (BuiltinsPackageFragment builtinPackage : this.resolutionFacade.getModuleDescriptor().getBuiltIns().getBuiltinsPackageFragments()) {
            this.collectClassesFromScope(builtinPackage.getMemberScope(), (Function1<? super ClassDescriptor, Unit>)((Function1)new Function1<ClassDescriptor, Unit>(classDescriptorCollector){
                final /* synthetic */ Function1 $classDescriptorCollector;

                public final void invoke(@NotNull ClassDescriptor it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (it.getContainingDeclaration() instanceof ClassDescriptor) {
                        this.$classDescriptorCollector.invoke((Object)it);
                    }
                }
                {
                    this.$classDescriptorCollector = function1;
                    super(1);
                }
            }));
        }
        Iterable $receiver$iv = this.kotlinIndicesHelper.getKotlinClasses((Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ AllClassesCompletion this$0;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return AllClassesCompletion.access$getPrefixMatcher$p(this.this$0).prefixMatches(it);
            }
            {
                this.this$0 = allClassesCompletion;
                super(1);
            }
        }), this.kindFilter);
        for (BuiltinsPackageFragment element$iv : $receiver$iv) {
            ClassDescriptor it = (ClassDescriptor)((Object)element$iv);
            classDescriptorCollector.invoke((Object)it);
        }
        PsiFile psiFile = this.parameters.getOriginalFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        if (!ProjectStructureUtil.isJsKotlinModule((KtFile)psiFile)) {
            this.addAdaptedJavaCompletion(javaClassCollector);
        }
    }

    private final void collectClassesFromScope(MemberScope scope2, Function1<? super ClassDescriptor, Unit> collector2) {
        for (DeclarationDescriptor descriptor2 : MemberScopeKt.getDescriptorsFiltered$default(scope2, DescriptorKindFilter.CLASSIFIERS, null, 2, null)) {
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            ClassKind classKind = ((ClassDescriptor)descriptor2).getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)classKind), (String)"descriptor.kind");
            if (((Boolean)this.kindFilter.invoke((Object)classKind)).booleanValue() && this.prefixMatcher.prefixMatches(((ClassDescriptor)descriptor2).getName().asString())) {
                collector2.invoke((Object)descriptor2);
            }
            MemberScope memberScope2 = ((ClassDescriptor)descriptor2).getUnsubstitutedInnerClassesScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)memberScope2, (String)"descriptor.unsubstitutedInnerClassesScope");
            this.collectClassesFromScope(memberScope2, collector2);
        }
    }

    private final void addAdaptedJavaCompletion(Function1<? super PsiClass, Unit> collector2) {
        AllClassesGetter.processJavaClasses((CompletionParameters)this.parameters, (PrefixMatcher)this.prefixMatcher, (boolean)true, (Consumer)((Consumer)new Consumer<PsiClass>(this, collector2){
            final /* synthetic */ AllClassesCompletion this$0;
            final /* synthetic */ Function1 $collector;

            public final void consume(PsiClass psiClass) {
                PsiClass psiClass2 = psiClass;
                if (psiClass2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!(psiClass2 instanceof KtLightClass)) {
                    ClassKind kind2;
                    if (AllClassesCompletion.access$isSyntheticKotlinClass(this.this$0, psiClass)) {
                        return;
                    }
                    ClassKind classKind = psiClass.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : (psiClass.isInterface() ? ClassKind.INTERFACE : (kind2 = psiClass.isEnum() ? ClassKind.ENUM_CLASS : ClassKind.CLASS));
                    if (((Boolean)AllClassesCompletion.access$getKindFilter$p(this.this$0).invoke((Object)((Object)kind2))).booleanValue()) {
                        this.$collector.invoke((Object)psiClass);
                    }
                }
            }
            {
                this.this$0 = allClassesCompletion;
                this.$collector = function1;
            }
        }));
    }

    private final boolean isSyntheticKotlinClass(PsiClass $receiver) {
        PsiAnnotation metadata;
        String string = $receiver.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.contains$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null) ^ true) {
            return false;
        }
        PsiModifierList psiModifierList = $receiver.getModifierList();
        PsiAnnotation psiAnnotation = metadata = psiModifierList != null ? psiModifierList.findAnnotation(JvmAnnotationNames.METADATA_FQ_NAME.asString()) : null;
        Object object = psiAnnotation != null ? psiAnnotation.findAttributeValue("k") : null;
        if (!(object instanceof PsiLiteral)) {
            object = null;
        }
        PsiLiteral psiLiteral = (PsiLiteral)object;
        return Intrinsics.areEqual((Object)(psiLiteral != null ? psiLiteral.getValue() : null), (Object)KotlinClassHeader.Kind.SYNTHETIC_CLASS.getId());
    }

    public AllClassesCompletion(@NotNull CompletionParameters parameters2, @NotNull KotlinIndicesHelper kotlinIndicesHelper, @NotNull PrefixMatcher prefixMatcher, @NotNull ResolutionFacade resolutionFacade2, @NotNull Function1<? super ClassKind, Boolean> kindFilter) {
        Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)kotlinIndicesHelper, (String)"kotlinIndicesHelper");
        Intrinsics.checkParameterIsNotNull((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade2, (String)"resolutionFacade");
        Intrinsics.checkParameterIsNotNull(kindFilter, (String)"kindFilter");
        this.parameters = parameters2;
        this.kotlinIndicesHelper = kotlinIndicesHelper;
        this.prefixMatcher = prefixMatcher;
        this.resolutionFacade = resolutionFacade2;
        this.kindFilter = kindFilter;
    }

    @NotNull
    public static final /* synthetic */ PrefixMatcher access$getPrefixMatcher$p(AllClassesCompletion $this) {
        return $this.prefixMatcher;
    }

    public static final /* synthetic */ boolean access$isSyntheticKotlinClass(AllClassesCompletion $this, PsiClass $receiver) {
        return $this.isSyntheticKotlinClass($receiver);
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getKindFilter$p(AllClassesCompletion $this) {
        return $this.kindFilter;
    }
}

