/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.OverridingUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a,\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0005\u001a6\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019\u00a8\u0006\u001a"}, d2={"compareDescriptors", "", "project", "Lcom/intellij/openapi/project/Project;", "currentDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "originalDescriptor", "compareDescriptorsText", "d1", "d2", "isVisible", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "context", "Lcom/intellij/psi/PsiElement;", "receiverExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "from", "resolutionScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "toKeywordToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "idea-core"})
public final class DescriptorUtilsKt {
    public static final boolean isVisible(DeclarationDescriptorWithVisibility $receiver, @NotNull DeclarationDescriptor from) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return DescriptorUtilsKt.isVisible$default($receiver, from, null, null, null, 12, null);
    }

    public static final boolean isVisible(DeclarationDescriptorWithVisibility $receiver, @NotNull PsiElement context, @Nullable KtExpression receiverExpression, @NotNull BindingContext bindingContext2, @NotNull ResolutionFacade resolutionFacade2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade2, (String)"resolutionFacade");
        LexicalScope resolutionScope = ScopeUtils.getResolutionScope(context, bindingContext2, resolutionFacade2);
        DeclarationDescriptor from = resolutionScope.getOwnerDescriptor();
        return DescriptorUtilsKt.isVisible($receiver, from, receiverExpression, bindingContext2, resolutionScope);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isVisible(DeclarationDescriptorWithVisibility $receiver, DeclarationDescriptor from, KtExpression receiverExpression, BindingContext bindingContext2, LexicalScope resolutionScope) {
        boolean bl;
        block5: {
            void $receiver$iv;
            if (Visibilities.isVisibleWithIrrelevantReceiver($receiver, from)) {
                return true;
            }
            if (bindingContext2 == null || resolutionScope == null) {
                return false;
            }
            if (receiverExpression != null) {
                KotlinType receiverType;
                KotlinType kotlinType = bindingContext2.getType(receiverExpression);
                if (kotlinType == null) {
                    return false;
                }
                KotlinType kotlinType2 = receiverType = kotlinType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"receiverType");
                ExpressionReceiver explicitReceiver = ExpressionReceiver.Companion.create(receiverExpression, kotlinType2, bindingContext2);
                return Visibilities.isVisible(explicitReceiver, $receiver, from);
            }
            Iterable receiverType = ScopeUtilsKt.getImplicitReceiversHierarchy(resolutionScope);
            for (Object element$iv : $receiver$iv) {
                ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv;
                if (!Visibilities.isVisible(it.getValue(), $receiver, from)) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    static /* bridge */ /* synthetic */ boolean isVisible$default(DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility, DeclarationDescriptor declarationDescriptor, KtExpression ktExpression, BindingContext bindingContext2, LexicalScope lexicalScope, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isVisible");
        }
        if ((n & 4) != 0) {
            bindingContext2 = null;
        }
        if ((n & 8) != 0) {
            lexicalScope = null;
        }
        return DescriptorUtilsKt.isVisible(declarationDescriptorWithVisibility, declarationDescriptor, ktExpression, bindingContext2, lexicalScope);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean compareDescriptorsText(Project project, DeclarationDescriptor d1, DeclarationDescriptor d2) {
        Collection<PsiElement> declarations2;
        String renderedD2;
        if (Intrinsics.areEqual((Object)d1, (Object)d2)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)d1.getName(), (Object)d2.getName()) ^ true) {
            return false;
        }
        String renderedD1 = IdeDescriptorRenderers.SOURCE_CODE.render(d1);
        if (Intrinsics.areEqual((Object)renderedD1, (Object)(renderedD2 = IdeDescriptorRenderers.SOURCE_CODE.render(d2)))) {
            return true;
        }
        Collection<PsiElement> declarations1 = DescriptorToSourceUtilsIde.INSTANCE.getAllDeclarations(project, d1);
        if (Intrinsics.areEqual(declarations1, declarations2 = DescriptorToSourceUtilsIde.INSTANCE.getAllDeclarations(project, d2))) {
            void $receiver$iv;
            Collection<PsiElement> collection = declarations1;
            if (!$receiver$iv.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean compareDescriptors(@NotNull Project project, @Nullable DeclarationDescriptor currentDescriptor, @Nullable DeclarationDescriptor originalDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)currentDescriptor, (Object)originalDescriptor)) {
            return true;
        }
        if (currentDescriptor == null || originalDescriptor == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)currentDescriptor.getName(), (Object)originalDescriptor.getName()) ^ true) {
            return false;
        }
        if (originalDescriptor instanceof SyntheticJavaPropertyDescriptor && currentDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return DescriptorUtilsKt.compareDescriptors(project, ((SyntheticJavaPropertyDescriptor)currentDescriptor).getGetMethod(), ((SyntheticJavaPropertyDescriptor)originalDescriptor).getGetMethod());
        }
        if (DescriptorUtilsKt.compareDescriptorsText(project, currentDescriptor, originalDescriptor)) {
            return true;
        }
        if (originalDescriptor instanceof CallableDescriptor && currentDescriptor instanceof CallableDescriptor) {
            boolean bl;
            block8: {
                void $receiver$iv;
                Set<CallableDescriptor> overriddenOriginalDescriptor = OverridingUtilsKt.findOriginalTopMostOverriddenDescriptors((CallableDescriptor)originalDescriptor);
                Set<CallableDescriptor> overriddenCurrentDescriptor = OverridingUtilsKt.findOriginalTopMostOverriddenDescriptors((CallableDescriptor)currentDescriptor);
                if (overriddenOriginalDescriptor.size() != overriddenCurrentDescriptor.size()) {
                    return false;
                }
                Iterable iterable = CollectionsKt.zip((Iterable)overriddenCurrentDescriptor, (Iterable)overriddenOriginalDescriptor);
                for (Object element$iv : $receiver$iv) {
                    Pair it = (Pair)element$iv;
                    if (DescriptorUtilsKt.compareDescriptorsText(project, (DeclarationDescriptor)it.getFirst(), (DeclarationDescriptor)it.getSecond())) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
            return bl;
        }
        return false;
    }

    @NotNull
    public static final KtModifierKeywordToken toKeywordToken(Visibility $receiver) {
        Visibility normalized;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Visibility visibility = normalized = $receiver.normalize();
        if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PUBLIC)) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PUBLIC_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PUBLIC_KEYWORD");
            return ktModifierKeywordToken;
        }
        if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PROTECTED)) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PROTECTED_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PROTECTED_KEYWORD");
            return ktModifierKeywordToken;
        }
        if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.INTERNAL)) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.INTERNAL_KEYWORD");
            return ktModifierKeywordToken;
        }
        if (Visibilities.isPrivate(normalized)) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PRIVATE_KEYWORD");
            return ktModifierKeywordToken;
        }
        String message$iv = "Unexpected visibility '" + normalized + "'";
        throw (Throwable)new IllegalStateException(message$iv.toString());
    }
}

