/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveUnnecessaryParenthesesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class RemoveUnnecessaryParenthesesIntention
extends SelfTargetingRangeIntention<KtParenthesizedExpression> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtParenthesizedExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2.getExpression() == null) {
            return null;
        }
        if (!KtPsiUtil.areParenthesesUseless(element2)) {
            return null;
        }
        return element2.getTextRange();
    }

    @Override
    public void applyTo(@NotNull KtParenthesizedExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement = (PsiElement)ktExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element.expression!!");
        element2.replace(psiElement);
    }

    public RemoveUnnecessaryParenthesesIntention() {
        super(KtParenthesizedExpression.class, "Remove unnecessary parentheses", null, 4, null);
    }
}

