/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u001b\u0010\u0015\u001a\u00020\n*\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u0017J\f\u0010\u0018\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\u0019\u001a\u00020\n*\u00020\u000bH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SimplifyBooleanWithConstantsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "areThereExpressionsToBeSimplified", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isApplicableTo", "simplifyExpression", "expression", "toSimplifiedBooleanBinaryExpressionWithConstantOperand", "constantOperand", "otherOperand", "operation", "Lcom/intellij/psi/tree/IElementType;", "toSimplifiedExpression", "canBeReducedToBooleanConstant", "constant", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/Boolean;)Z", "canBeReducedToFalse", "canBeReducedToTrue", "idea"})
public final class SimplifyBooleanWithConstantsIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)((PsiElement)element2), KtBinaryExpression.class);
        if (ktBinaryExpression == null) {
            ktBinaryExpression = element2;
        }
        KtBinaryExpression topBinary = ktBinaryExpression;
        return this.areThereExpressionsToBeSimplified(topBinary);
    }

    private final boolean areThereExpressionsToBeSimplified(KtExpression element2) {
        IElementType op;
        if (element2 == null) {
            return false;
        }
        KtExpression ktExpression = element2;
        if (ktExpression instanceof KtParenthesizedExpression) {
            return this.areThereExpressionsToBeSimplified(((KtParenthesizedExpression)element2).getExpression());
        }
        if (ktExpression instanceof KtBinaryExpression && (Intrinsics.areEqual((Object)(op = ((KtBinaryExpression)element2).getOperationToken()), (Object)((Object)KtTokens.ANDAND)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.OROR))) && (this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element2).getLeft()) || this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element2).getRight()))) {
            return true;
        }
        return this.canBeReducedToBooleanConstant(element2, null);
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)((PsiElement)element2), KtBinaryExpression.class);
        if (ktBinaryExpression == null) {
            ktBinaryExpression = element2;
        }
        KtBinaryExpression topBinary = ktBinaryExpression;
        KtExpression ktExpression = topBinary;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"topBinary");
        KtExpression simplified = this.toSimplifiedExpression(ktExpression);
        PsiElement psiElement = (PsiElement)KtPsiUtil.safeDeparenthesize(simplified);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"KtPsiUtil.safeDeparenthesize(simplified)");
        topBinary.replace(psiElement);
    }

    private final KtExpression toSimplifiedExpression(KtExpression expression2) {
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)expression2);
        if (this.canBeReducedToTrue(expression2)) {
            return psiFactory.createExpression("true");
        }
        if (this.canBeReducedToFalse(expression2)) {
            return psiFactory.createExpression("false");
        }
        if (expression2 instanceof KtParenthesizedExpression) {
            KtExpression expr = ((KtParenthesizedExpression)expression2).getExpression();
            if (expr != null) {
                KtExpression simplified = this.toSimplifiedExpression(expr);
                return simplified instanceof KtBinaryExpression ? CreateByPatternKt.createExpressionByPattern(psiFactory, "($0)", simplified) : simplified;
            }
        } else if (expression2 instanceof KtBinaryExpression) {
            KtExpression left = ((KtBinaryExpression)expression2).getLeft();
            KtExpression right = ((KtBinaryExpression)expression2).getRight();
            IElementType op = ((KtBinaryExpression)expression2).getOperationToken();
            if (left != null && right != null && (Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.ANDAND)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.OROR)))) {
                KtExpression ktExpression;
                KtExpression simpleLeft = this.simplifyExpression(left);
                KtExpression simpleRight = this.simplifyExpression(right);
                if (this.canBeReducedToTrue(simpleLeft)) {
                    IElementType iElementType = op;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"op");
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleRight, iElementType);
                } else if (this.canBeReducedToFalse(simpleLeft)) {
                    IElementType iElementType = op;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"op");
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleRight, iElementType);
                } else if (this.canBeReducedToTrue(simpleRight)) {
                    IElementType iElementType = op;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"op");
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleLeft, iElementType);
                } else if (this.canBeReducedToFalse(simpleRight)) {
                    IElementType iElementType = op;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"op");
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleLeft, iElementType);
                } else {
                    String opText = ((KtBinaryExpression)expression2).getOperationReference().getText();
                    ktExpression = CreateByPatternKt.createExpressionByPattern(psiFactory, "$" + "0 " + opText + " " + "$" + "1", simpleLeft, simpleRight);
                }
                return ktExpression;
            }
        }
        return (KtExpression)PsiModificationUtilsKt.copied((PsiElement)expression2);
    }

    private final KtExpression toSimplifiedBooleanBinaryExpressionWithConstantOperand(boolean constantOperand, KtExpression otherOperand, IElementType operation) {
        return constantOperand && Intrinsics.areEqual((Object)operation, (Object)((Object)KtTokens.OROR)) ? KtPsiFactoryKt.KtPsiFactory((PsiElement)otherOperand).createExpression("true") : (!constantOperand && Intrinsics.areEqual((Object)operation, (Object)((Object)KtTokens.ANDAND)) ? KtPsiFactoryKt.KtPsiFactory((PsiElement)otherOperand).createExpression("false") : this.toSimplifiedExpression(otherOperand));
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression simplifyExpression(KtExpression expression2) {
        Object object;
        void $receiver$iv;
        PsiElement psiElement = (PsiElement)expression2;
        PsiElement newElement$iv = (PsiElement)this.toSimplifiedExpression(expression2);
        PsiElement result$iv = $receiver$iv.replace(newElement$iv);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement2 = result$iv;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement2).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            object = ktExpression;
        }
        return (KtExpression)object;
    }

    private final boolean canBeReducedToBooleanConstant(KtExpression $receiver, Boolean constant) {
        return CompileTimeConstantUtils.canBeReducedToBooleanConstant($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null), constant);
    }

    private final boolean canBeReducedToTrue(KtExpression $receiver) {
        return this.canBeReducedToBooleanConstant($receiver, true);
    }

    private final boolean canBeReducedToFalse(KtExpression $receiver) {
        return this.canBeReducedToBooleanConstant($receiver, false);
    }

    public SimplifyBooleanWithConstantsIntention() {
        super(KtBinaryExpression.class, "Simplify boolean expression", null, 4, null);
    }
}

