/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ImportDescriptorResult;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.idea.util.ShortenReferences$ShortenQualifiedExpressionsVisitor$WhenMappings;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000  2\u00020\u0001:\t !\"#$%&'(B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0002J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0003H\u0007J&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0003H\u0007J\u001e\u0010\u0013\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ8\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0003H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences;", "", "options", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$Options;", "(Lkotlin/jvm/functions/Function1;)V", "getOptions", "()Lkotlin/jvm/functions/Function1;", "analyzeReferences", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "elements", "", "visitor", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$ShorteningVisitor;", "dropNestedElements", "Ljava/util/LinkedHashSet;", "", "process", "", "elementFilter", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$FilterResult;", "element", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffset", "", "endOffset", "shortenReferencesInFile", "Companion", "FilterResult", "Options", "QualifiedExpressionShorteningVisitor", "RemoveExplicitCompanionObjectReferenceVisitor", "ShortenQualifiedExpressionsVisitor", "ShortenThisExpressionsVisitor", "ShortenTypesVisitor", "ShorteningVisitor", "idea-analysis"})
public final class ShortenReferences {
    @NotNull
    private final Function1<KtElement, Options> options;
    @JvmField
    @NotNull
    public static final ShortenReferences DEFAULT;
    public static final Companion Companion;

    @JvmOverloads
    @NotNull
    public final KtElement process(@NotNull KtElement element2, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
        return (KtElement)CollectionsKt.single((Iterable)this.process(CollectionsKt.listOf((Object)element2), elementFilter));
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ KtElement process$default(ShortenReferences shortenReferences, KtElement ktElement, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: process");
        }
        if ((n & 2) != 0) {
            function1 = process.1.INSTANCE;
        }
        return shortenReferences.process(ktElement, (Function1<? super PsiElement, ? extends FilterResult>)function1);
    }

    @JvmOverloads
    @NotNull
    public KtElement process(@NotNull KtElement element2) {
        return ShortenReferences.process$default(this, element2, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(@NotNull KtFile file, int startOffset, int endOffset) {
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        Document document2 = file.getViewProvider().getDocument();
        if (document2 == null) {
            Intrinsics.throwNpe();
        }
        if (!documentManager.isCommitted(document = document2)) {
            throw (Throwable)new IllegalStateException("Document should be committed to shorten references in range");
        }
        RangeMarker rangeMarker = document.createRangeMarker(startOffset, endOffset);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        try {
            this.process(CollectionsKt.listOf((Object)file), (Function1<? super PsiElement, ? extends FilterResult>)((Function1)new Function1<PsiElement, FilterResult>(rangeMarker){
                final /* synthetic */ RangeMarker $rangeMarker;

                @NotNull
                public final FilterResult invoke(@NotNull PsiElement element2) {
                    FilterResult filterResult;
                    Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                    if (this.$rangeMarker.isValid()) {
                        TextRange elementRange;
                        TextRange range = new TextRange(this.$rangeMarker.getStartOffset(), this.$rangeMarker.getEndOffset());
                        TextRange textRange = element2.getTextRange();
                        if (textRange == null) {
                            Intrinsics.throwNpe();
                        }
                        if (range.contains(elementRange = textRange)) {
                            filterResult = FilterResult.PROCESS;
                        } else if (range.intersects(elementRange)) {
                            KtExpression calleeExpression;
                            PsiElement psiElement = element2;
                            if (!(psiElement instanceof KtDotQualifiedExpression)) {
                                psiElement = null;
                            }
                            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement;
                            KtExpression ktExpression = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getSelectorExpression() : null;
                            if (!(ktExpression instanceof KtCallExpression)) {
                                ktExpression = null;
                            }
                            KtCallExpression ktCallExpression = (KtCallExpression)ktExpression;
                            KtExpression ktExpression2 = calleeExpression = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
                            if (calleeExpression != null) {
                                TextRange rangeWithoutParenthesis;
                                int n = elementRange.getStartOffset();
                                TextRange textRange2 = calleeExpression.getTextRange();
                                if (textRange2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                filterResult = range.contains(rangeWithoutParenthesis = new TextRange(n, textRange2.getEndOffset())) ? FilterResult.PROCESS : FilterResult.GO_INSIDE;
                            } else {
                                filterResult = FilterResult.GO_INSIDE;
                            }
                        } else {
                            filterResult = FilterResult.SKIP;
                        }
                    } else {
                        filterResult = FilterResult.SKIP;
                    }
                    return filterResult;
                }
                {
                    this.$rangeMarker = rangeMarker;
                    super(1);
                }
            }));
        }
        finally {
            rangeMarker.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Collection<KtElement> process(@NotNull Iterable<? extends KtElement> elements, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter) {
        void $receiver$iv$iv$iv;
        Collection destination$iv$iv;
        Iterable<? extends KtElement> $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
        Iterable<? extends KtElement> $receiver$iv = elements;
        Iterable<? extends KtElement> iterable = $receiver$iv;
        Map map2 = new LinkedHashMap();
        for (Object iterator2 : $receiver$iv$iv) {
            Object object;
            void $receiver$iv$iv$iv2;
            KtElement element2 = (KtElement)iterator2;
            KtFile key$iv$iv = element2.getContainingKtFile();
            void var11_11 = destination$iv$iv;
            Object value$iv$iv$iv = $receiver$iv$iv$iv2.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(iterator2);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable<? extends KtElement> iterable2 = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            Iterable list$iv$iv = this.shortenReferencesInFile((KtFile)it.getKey(), (List)it.getValue(), elementFilter);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Collection process$default(ShortenReferences shortenReferences, Iterable iterable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: process");
        }
        if ((n & 2) != 0) {
            function1 = process.3.INSTANCE;
        }
        return shortenReferences.process(iterable, (Function1<? super PsiElement, ? extends FilterResult>)function1);
    }

    @JvmOverloads
    @NotNull
    public Collection<KtElement> process(@NotNull Iterable<? extends KtElement> elements) {
        return ShortenReferences.process$default(this, elements, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtElement> shortenReferencesInFile(KtFile file, List<? extends KtElement> elements, Function1<? super PsiElement, ? extends FilterResult> elementFilter) {
        boolean anyChange;
        LinkedHashSet<KtElement> elementsToUse = this.dropNestedElements(elements);
        Project project = file.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        ImportInsertHelper helper2 = ImportInsertHelper.Companion.getInstance(project);
        LinkedHashSet<DeclarationDescriptor> failedToImportDescriptors = new LinkedHashSet<DeclarationDescriptor>();
        do {
            void destination$iv$iv;
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv;
            List visitors = CollectionsKt.listOf((Object[])new ShorteningVisitor[]{new ShortenTypesVisitor(file, elementFilter, (Set<? extends DeclarationDescriptor>)failedToImportDescriptors), new ShortenThisExpressionsVisitor(file, elementFilter, (Set<? extends DeclarationDescriptor>)failedToImportDescriptors), new ShortenQualifiedExpressionsVisitor(file, elementFilter, (Set<? extends DeclarationDescriptor>)failedToImportDescriptors), new RemoveExplicitCompanionObjectReferenceVisitor(file, elementFilter, (Set<? extends DeclarationDescriptor>)failedToImportDescriptors)});
            Iterable iterable = visitors;
            void var10_11 = $receiver$iv;
            Collection collection = new ArrayList();
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                ShorteningVisitor it = (ShorteningVisitor)((Object)element$iv$iv);
                Iterable list$iv$iv = this.analyzeReferences((Iterable<? extends KtElement>)elementsToUse, it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Set descriptorsToImport = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $receiver$iv = visitors;
            $receiver$iv$iv = $receiver$iv.iterator();
            while ($receiver$iv$iv.hasNext()) {
                Object element$iv = $receiver$iv$iv.next();
                ShorteningVisitor it = (ShorteningVisitor)((Object)element$iv);
                it.shortenElements((Set<KtElement>)elementsToUse);
            }
            anyChange = false;
            for (DeclarationDescriptor descriptor2 : descriptorsToImport) {
                Unit unit;
                boolean it = failedToImportDescriptors.contains(descriptor2) ^ true;
                if (_Assertions.ENABLED) {
                    void value$iv;
                    if (value$iv == false) {
                        String message$iv$iv = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                ImportDescriptorResult result2 = ImportInsertHelper.importDescriptor$default(helper2, file, descriptor2, false, 4, null);
                if (Intrinsics.areEqual((Object)((Object)result2), (Object)((Object)ImportDescriptorResult.ALREADY_IMPORTED)) ^ true) {
                    anyChange = true;
                }
                if (!Intrinsics.areEqual((Object)((Object)result2), (Object)((Object)ImportDescriptorResult.FAIL))) continue;
                failedToImportDescriptors.add(descriptor2);
            }
        } while (anyChange);
        return elementsToUse;
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedHashSet<KtElement> dropNestedElements(List<? extends KtElement> elements) {
        Set elementSet = CollectionsKt.toSet((Iterable)elements);
        LinkedHashSet<KtElement> newElements2 = new LinkedHashSet<KtElement>(elementSet.size());
        for (KtElement element2 : elementSet) {
            boolean bl;
            block2: {
                void $receiver$iv;
                Sequence<PsiElement> sequence2 = PsiUtilsKt.getParents((PsiElement)element2);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!CollectionsKt.contains((Iterable)elementSet, (Object)it)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (bl) continue;
            newElements2.add(element2);
        }
        return newElements2;
    }

    private final Set<DeclarationDescriptor> analyzeReferences(Iterable<? extends KtElement> elements, ShorteningVisitor<?> visitor2) {
        for (KtElement ktElement : elements) {
            visitor2.setOptions((Options)this.options.invoke((Object)ktElement));
            ktElement.accept(visitor2);
        }
        return visitor2.getDescriptorsToImport();
    }

    @NotNull
    public final Function1<KtElement, Options> getOptions() {
        return this.options;
    }

    public ShortenReferences(@NotNull Function1<? super KtElement, Options> options) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        this.options = options;
    }

    public /* synthetic */ ShortenReferences(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Function1<? super KtElement, Options>)function1);
    }

    public ShortenReferences() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new ShortenReferences(null, 1, null);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences$Options;", "", "removeThisLabels", "", "removeThis", "(ZZ)V", "getRemoveThis", "()Z", "getRemoveThisLabels", "component1", "component2", "copy", "Companion", "idea-analysis"})
    public static final class Options {
        private final boolean removeThisLabels;
        private final boolean removeThis;
        @NotNull
        private static final Options DEFAULT;
        public static final Companion Companion;

        public final boolean getRemoveThisLabels() {
            return this.removeThisLabels;
        }

        public final boolean getRemoveThis() {
            return this.removeThis;
        }

        public Options(boolean removeThisLabels, boolean removeThis) {
            this.removeThisLabels = removeThisLabels;
            this.removeThis = removeThis;
        }

        public /* synthetic */ Options(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public Options() {
            this(false, false, 3, null);
        }

        static {
            Companion = new Companion(null);
            DEFAULT = new Options(false, false, 3, null);
        }

        public final boolean component1() {
            return this.removeThisLabels;
        }

        public final boolean component2() {
            return this.removeThis;
        }

        @NotNull
        public final Options copy(boolean removeThisLabels, boolean removeThis) {
            return new Options(removeThisLabels, removeThis);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Options copy$default(Options options, boolean bl, boolean bl2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                bl = options.removeThisLabels;
            }
            if ((n & 2) != 0) {
                bl2 = options.removeThis;
            }
            return options.copy(bl, bl2);
        }

        public String toString() {
            return "Options(removeThisLabels=" + this.removeThisLabels + ", removeThis=" + this.removeThis + ")";
        }

        public int hashCode() {
            int n = this.removeThisLabels ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.removeThis ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Options)) break block3;
                    Options options = (Options)object;
                    if (!(this.removeThisLabels == options.removeThisLabels) || !(this.removeThis == options.removeThis)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences$Options$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$Options;", "getDEFAULT", "()Lorg/jetbrains/kotlin/idea/util/ShortenReferences$Options;", "idea-analysis"})
        public static final class Companion {
            @NotNull
            public final Options getDEFAULT() {
                return DEFAULT;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences$FilterResult;", "", "(Ljava/lang/String;I)V", "SKIP", "GO_INSIDE", "PROCESS", "idea-analysis"})
    public static final class FilterResult
    extends Enum<FilterResult> {
        public static final /* enum */ FilterResult SKIP;
        public static final /* enum */ FilterResult GO_INSIDE;
        public static final /* enum */ FilterResult PROCESS;
        private static final /* synthetic */ FilterResult[] $VALUES;

        static {
            FilterResult[] filterResultArray = new FilterResult[3];
            FilterResult[] filterResultArray2 = filterResultArray;
            filterResultArray[0] = SKIP = new FilterResult();
            filterResultArray[1] = GO_INSIDE = new FilterResult();
            filterResultArray[2] = PROCESS = new FilterResult();
            $VALUES = filterResultArray;
        }

        public static FilterResult[] values() {
            return (FilterResult[])$VALUES.clone();
        }

        public static FilterResult valueOf(String string) {
            return Enum.valueOf(FilterResult.class, string);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0002\b\"\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0002H\u0004J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ'\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00028\u00002\b\u0010*\u001a\u0004\u0018\u00010\f2\u0006\u0010+\u001a\u00020,H\u0004\u00a2\u0006\u0002\u0010-J\u0015\u0010.\u001a\u00020\u00022\u0006\u0010$\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010/J\u0015\u00100\u001a\u00020\u00022\u0006\u0010$\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010/J\u0014\u00101\u001a\u00020#2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000203J\u0010\u00104\u001a\u00020#2\u0006\u0010$\u001a\u00020\bH\u0016R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences$ShorteningVisitor;", "T", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "descriptorsToImport", "Ljava/util/LinkedHashSet;", "getElementFilter", "()Lkotlin/jvm/functions/Function1;", "elementsToShorten", "Ljava/util/ArrayList;", "getFailedToImportDescriptors", "()Ljava/util/Set;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "options", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$Options;", "getOptions", "()Lorg/jetbrains/kotlin/idea/util/ShortenReferences$Options;", "setOptions", "(Lorg/jetbrains/kotlin/idea/util/ShortenReferences$Options;)V", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "getResolutionFacade", "()Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "addElementToShorten", "", "element", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "analyze", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDescriptorsToImport", "processQualifiedElement", "target", "canShortenNow", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Z)V", "qualifier", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/psi/KtElement;", "shortenElement", "shortenElements", "elementSetToUpdate", "", "visitElement", "idea-analysis"})
    private static abstract class ShorteningVisitor<T extends KtElement>
    extends KtVisitorVoid {
        @NotNull
        private Options options;
        private final ArrayList<T> elementsToShorten;
        private final LinkedHashSet<DeclarationDescriptor> descriptorsToImport;
        @NotNull
        private final ResolutionFacade resolutionFacade;
        @NotNull
        private final KtFile file;
        @NotNull
        private final Function1<PsiElement, FilterResult> elementFilter;
        @NotNull
        private final Set<DeclarationDescriptor> failedToImportDescriptors;

        @NotNull
        public final Options getOptions() {
            return this.options;
        }

        public final void setOptions(@NotNull Options options) {
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"<set-?>");
            this.options = options;
        }

        @NotNull
        protected final ResolutionFacade getResolutionFacade() {
            return this.resolutionFacade;
        }

        @NotNull
        protected final BindingContext analyze(@NotNull KtElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            return this.resolutionFacade.analyze(element2, BodyResolveMode.PARTIAL);
        }

        protected final void processQualifiedElement(@NotNull T element2, @Nullable DeclarationDescriptor target, boolean canShortenNow) {
            Intrinsics.checkParameterIsNotNull(element2, (String)"element");
            if (canShortenNow) {
                this.addElementToShorten(element2);
            } else if (target != null && this.failedToImportDescriptors.contains(target) ^ true && Companion.mayImport(target, this.file)) {
                this.descriptorsToImport.add(target);
            } else {
                this.qualifier(element2).accept(this);
            }
        }

        protected final void addElementToShorten(@NotNull T element2) {
            Intrinsics.checkParameterIsNotNull(element2, (String)"element");
            this.elementsToShorten.add(element2);
        }

        @NotNull
        protected abstract KtElement qualifier(@NotNull T var1);

        @NotNull
        protected abstract KtElement shortenElement(@NotNull T var1);

        public void visitElement(@NotNull PsiElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            if (Intrinsics.areEqual((Object)((Object)((FilterResult)((Object)this.elementFilter.invoke((Object)element2)))), (Object)((Object)FilterResult.SKIP)) ^ true) {
                element2.acceptChildren((PsiElementVisitor)this);
            }
        }

        public final void shortenElements(@NotNull Set<KtElement> elementSetToUpdate) {
            Intrinsics.checkParameterIsNotNull(elementSetToUpdate, (String)"elementSetToUpdate");
            for (KtElement element2 : this.elementsToShorten) {
                if (!element2.isValid()) continue;
                KtElement ktElement = element2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"element");
                KtElement newElement = this.shortenElement(ktElement);
                if (!elementSetToUpdate.contains(element2) || !(Intrinsics.areEqual((Object)newElement, (Object)element2) ^ true)) continue;
                elementSetToUpdate.remove(element2);
                elementSetToUpdate.add(newElement);
            }
        }

        @NotNull
        public final Set<DeclarationDescriptor> getDescriptorsToImport() {
            return this.descriptorsToImport;
        }

        @NotNull
        protected final KtFile getFile() {
            return this.file;
        }

        @NotNull
        protected final Function1<PsiElement, FilterResult> getElementFilter() {
            return this.elementFilter;
        }

        @NotNull
        protected final Set<DeclarationDescriptor> getFailedToImportDescriptors() {
            return this.failedToImportDescriptors;
        }

        public ShorteningVisitor(@NotNull KtFile file, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            this.file = file;
            this.elementFilter = elementFilter;
            this.failedToImportDescriptors = failedToImportDescriptors;
            this.options = Options.Companion.getDEFAULT();
            this.elementsToShorten = new ArrayList();
            this.descriptorsToImport = new LinkedHashSet();
            this.resolutionFacade = ResolutionUtils.getResolutionFacade(this.file);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0015\u0010\u0010\u001a\u00070\u0002\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences$ShortenTypesVisitor;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$ShorteningVisitor;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "processType", "", "type", "qualifier", "Lorg/jetbrains/annotations/Nullable;", "element", "shortenElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitUserType", "userType", "idea-analysis"})
    private static final class ShortenTypesVisitor
    extends ShorteningVisitor<KtUserType> {
        @Override
        public void visitUserType(@NotNull KtUserType userType) {
            Unit unit;
            Intrinsics.checkParameterIsNotNull((Object)userType, (String)"userType");
            FilterResult filterResult = (FilterResult)((Object)this.getElementFilter().invoke((Object)userType));
            if (Intrinsics.areEqual((Object)((Object)filterResult), (Object)((Object)FilterResult.SKIP))) {
                return;
            }
            KtTypeArgumentList ktTypeArgumentList = userType.getTypeArgumentList();
            if (ktTypeArgumentList != null) {
                ktTypeArgumentList.accept(this);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (Intrinsics.areEqual((Object)((Object)filterResult), (Object)((Object)FilterResult.PROCESS))) {
                this.processType(userType);
            } else {
                Unit unit2;
                KtUserType ktUserType = userType.getQualifier();
                if (ktUserType != null) {
                    ktUserType.accept(this);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
            }
        }

        private final void processType(KtUserType type2) {
            DeclarationDescriptor targetByName;
            DeclarationDescriptor declarationDescriptor;
            if (type2.getQualifier() == null) {
                return;
            }
            KtSimpleNameExpression ktSimpleNameExpression = type2.getReferenceExpression();
            if (ktSimpleNameExpression == null) {
                return;
            }
            KtSimpleNameExpression referenceExpression = ktSimpleNameExpression;
            KtElement ktElement = referenceExpression;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"referenceExpression");
            BindingContext bindingContext2 = this.analyze(ktElement);
            DeclarationDescriptor declarationDescriptor2 = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)Companion.targets(referenceExpression, bindingContext2));
            if (declarationDescriptor2 == null) {
                return;
            }
            DeclarationDescriptor target = declarationDescriptor2;
            LexicalScope scope2 = ScopeUtils.getResolutionScope((PsiElement)type2, bindingContext2, this.getResolutionFacade());
            Name name2 = target.getName();
            if (target instanceof ClassifierDescriptor) {
                HierarchicalScope hierarchicalScope = scope2;
                Name name3 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
                declarationDescriptor = ScopeUtilsKt.findClassifier(hierarchicalScope, name3, NoLookupLocation.FROM_IDE);
            } else {
                HierarchicalScope hierarchicalScope = scope2;
                Name name4 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"name");
                declarationDescriptor = ScopeUtilsKt.findPackage(hierarchicalScope, name4);
            }
            DeclarationDescriptor declarationDescriptor3 = targetByName = declarationDescriptor;
            boolean canShortenNow = Intrinsics.areEqual((Object)(declarationDescriptor3 != null ? Companion.asString(declarationDescriptor3) : null), (Object)Companion.asString(target));
            this.processQualifiedElement((KtElement)type2, target, canShortenNow);
        }

        @NotNull
        protected KtUserType qualifier(@NotNull KtUserType element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            KtUserType ktUserType = element2.getQualifier();
            if (ktUserType == null) {
                Intrinsics.throwNpe();
            }
            return ktUserType;
        }

        @Override
        @NotNull
        protected KtElement shortenElement(@NotNull KtUserType element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            element2.deleteQualifier();
            return element2;
        }

        public ShortenTypesVisitor(@NotNull KtFile file, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            super(file, elementFilter, failedToImportDescriptors);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\"\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H&J\u0015\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences$QualifiedExpressionShorteningVisitor;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$ShorteningVisitor;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "process", "", "qualifiedExpression", "qualifier", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/annotations/NotNull;", "element", "visitDotQualifiedExpression", "", "expression", "idea-analysis"})
    private static abstract class QualifiedExpressionShorteningVisitor
    extends ShorteningVisitor<KtDotQualifiedExpression> {
        @Override
        public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2) {
            Unit unit;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            FilterResult filterResult = (FilterResult)((Object)this.getElementFilter().invoke((Object)expression2));
            if (Intrinsics.areEqual((Object)((Object)filterResult), (Object)((Object)FilterResult.SKIP))) {
                return;
            }
            KtExpression ktExpression = expression2.getSelectorExpression();
            if (ktExpression != null) {
                ktExpression.acceptChildren(this);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (Intrinsics.areEqual((Object)((Object)filterResult), (Object)((Object)FilterResult.PROCESS)) && this.process(expression2)) {
                return;
            }
            expression2.getReceiverExpression().accept(this);
        }

        public abstract boolean process(@NotNull KtDotQualifiedExpression var1);

        @NotNull
        protected KtExpression qualifier(@NotNull KtDotQualifiedExpression element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            return element2.getReceiverExpression();
        }

        public QualifiedExpressionShorteningVisitor(@NotNull KtFile file, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            super(file, elementFilter, failedToImportDescriptors);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0014J$\u0010\u0013\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences$ShortenQualifiedExpressionsVisitor;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$QualifiedExpressionShorteningVisitor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "process", "", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "shortenElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "targetsMatch", "targets1", "", "targets2", "idea-analysis"})
    private static final class ShortenQualifiedExpressionsVisitor
    extends QualifiedExpressionShorteningVisitor {
        /*
         * WARNING - void declaration
         */
        @Override
        public boolean process(@NotNull KtDotQualifiedExpression qualifiedExpression) {
            Object originalCall;
            KtExpression receiver;
            Intrinsics.checkParameterIsNotNull((Object)qualifiedExpression, (String)"qualifiedExpression");
            BindingContext bindingContext2 = this.analyze(qualifiedExpression);
            KtExpression ktExpression = receiver = qualifiedExpression.getReceiverExpression();
            if (ktExpression instanceof KtThisExpression ? !this.getOptions().getRemoveThis() : bindingContext2.get(BindingContext.QUALIFIER, receiver) == null) {
                return false;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)qualifiedExpression), (Class[])new Class[]{KtImportDirective.class, KtPackageDirective.class}) != null) {
                return true;
            }
            KtExpression ktExpression2 = qualifiedExpression.getSelectorExpression();
            if (ktExpression2 == null) {
                return false;
            }
            KtExpression selector = ktExpression2;
            KtExpression ktExpression3 = CallUtilKt.getCalleeExpressionIfAny(selector);
            if (!(ktExpression3 instanceof KtReferenceExpression)) {
                ktExpression3 = null;
            }
            KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression3;
            if (ktReferenceExpression == null) {
                return false;
            }
            KtReferenceExpression callee = ktReferenceExpression;
            Collection targets = Companion.targets(callee, bindingContext2);
            if (targets.isEmpty()) {
                return false;
            }
            LexicalScope scope2 = ScopeUtils.getResolutionScope((PsiElement)qualifiedExpression, bindingContext2, this.getResolutionFacade());
            PsiElement psiElement = selector.copy();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
            }
            KtReferenceExpression selectorCopy = (KtReferenceExpression)psiElement;
            KtExpression ktExpression4 = selectorCopy;
            KtExpression ktExpression5 = selector;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"selector");
            BindingContext newContext = AnalyzerUtilKt.analyzeInContext$default(ktExpression4, scope2, ktExpression5, null, null, null, false, 60, null);
            KtExpression ktExpression6 = CallUtilKt.getCalleeExpressionIfAny(selectorCopy);
            if (ktExpression6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
            }
            Collection targetsWhenShort = Companion.targets((KtReferenceExpression)ktExpression6, newContext);
            boolean targetsMatch = this.targetsMatch(targets, targetsWhenShort);
            if (receiver instanceof KtThisExpression) {
                Receiver receiver2;
                if (!targetsMatch) {
                    return false;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(selector, bindingContext2);
                if (resolvedCall2 == null) {
                    return false;
                }
                originalCall = resolvedCall2;
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(selectorCopy, newContext);
                if (resolvedCall3 == null) {
                    return false;
                }
                ResolvedCall<? extends CallableDescriptor> newCall2 = resolvedCall3;
                ExplicitReceiverKind receiverKind = originalCall.getExplicitReceiverKind();
                switch (ShortenReferences$ShortenQualifiedExpressionsVisitor$WhenMappings.$EnumSwitchMapping$0[receiverKind.ordinal()]) {
                    case 1: 
                    case 2: {
                        receiver2 = newCall2.getExtensionReceiver();
                        break;
                    }
                    case 3: {
                        receiver2 = newCall2.getDispatchReceiver();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                Receiver receiver3 = receiver2;
                if (!(receiver2 instanceof ImplicitReceiver)) {
                    receiver3 = null;
                }
                ImplicitReceiver implicitReceiver = (ImplicitReceiver)receiver3;
                if (implicitReceiver == null) {
                    return false;
                }
                ImplicitReceiver newReceiver = implicitReceiver;
                DeclarationDescriptor thisTarget = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)Companion.targets(((KtThisExpression)receiver).getInstanceReference(), bindingContext2));
                DeclarationDescriptor declarationDescriptor = thisTarget;
                if (Intrinsics.areEqual((Object)Companion.asString(newReceiver.getDeclarationDescriptor()), (Object)(declarationDescriptor != null ? Companion.asString(declarationDescriptor) : null)) ^ true) {
                    return false;
                }
            }
            if (!targetsMatch) {
                boolean bl;
                block22: {
                    void $receiver$iv;
                    originalCall = targetsWhenShort;
                    for (Object element$iv : $receiver$iv) {
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                        if (!(!(it instanceof ClassDescriptor) && !(it instanceof PackageViewDescriptor))) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
                if (bl) {
                    return false;
                }
            }
            this.processQualifiedElement((KtElement)qualifiedExpression, (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)targets), targetsMatch);
            return true;
        }

        private final boolean targetsMatch(Collection<? extends DeclarationDescriptor> targets1, Collection<? extends DeclarationDescriptor> targets2) {
            Object object;
            DeclarationDescriptor it;
            Set set;
            Collection destination$iv$iv;
            Iterable $receiver$iv$iv;
            if (targets1.size() != targets2.size()) {
                return false;
            }
            if (targets1.size() == 1) {
                return Intrinsics.areEqual((Object)Companion.asString((DeclarationDescriptor)CollectionsKt.single((Iterable)targets1)), (Object)Companion.asString((DeclarationDescriptor)CollectionsKt.single((Iterable)targets2)));
            }
            Iterable $receiver$iv = targets1;
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)item$iv$iv;
                set = destination$iv$iv;
                object = Companion.asString(it);
                set.add(object);
            }
            $receiver$iv = targets2;
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (DeclarationDescriptor)item$iv$iv;
                object = destination$iv$iv;
                String string = Companion.asString(it);
                object.add(string);
            }
            object = (List)destination$iv$iv;
            return Intrinsics.areEqual((Object)set, (Object)CollectionsKt.toSet((Iterable)((Iterable)object)));
        }

        @Override
        @NotNull
        protected KtElement shortenElement(@NotNull KtDotQualifiedExpression element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            KtExpression ktExpression = element2.getSelectorExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement = element2.replace((PsiElement)ktExpression);
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            }
            return (KtElement)psiElement;
        }

        public ShortenQualifiedExpressionsVisitor(@NotNull KtFile file, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            super(file, elementFilter, failedToImportDescriptors);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u000e\u0010\r\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences$ShortenThisExpressionsVisitor;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$ShorteningVisitor;", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "simpleThis", "process", "", "thisExpression", "qualifier", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "shortenElement", "visitThisExpression", "expression", "idea-analysis"})
    private static final class ShortenThisExpressionsVisitor
    extends ShorteningVisitor<KtThisExpression> {
        private final KtThisExpression simpleThis;

        private final void process(KtThisExpression thisExpression) {
            if (!this.getOptions().getRemoveThisLabels() || thisExpression.getTargetLabel() == null) {
                return;
            }
            BindingContext bindingContext2 = this.analyze(thisExpression);
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)Companion.targets(thisExpression.getInstanceReference(), bindingContext2));
            if (declarationDescriptor == null) {
                return;
            }
            DeclarationDescriptor targetBefore = declarationDescriptor;
            LexicalScope scope2 = ScopeUtils.getResolutionScope((PsiElement)thisExpression, bindingContext2, this.getResolutionFacade());
            BindingContext newContext = AnalyzerUtilKt.analyzeInContext$default(this.simpleThis, scope2, thisExpression, null, null, null, false, 60, null);
            DeclarationDescriptor targetAfter = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)Companion.targets(this.simpleThis.getInstanceReference(), newContext));
            if (Intrinsics.areEqual((Object)targetBefore, (Object)targetAfter)) {
                this.addElementToShorten((KtElement)thisExpression);
            }
        }

        @Override
        public void visitThisExpression(@NotNull KtThisExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            if (Intrinsics.areEqual((Object)((Object)((FilterResult)((Object)this.getElementFilter().invoke((Object)expression2)))), (Object)((Object)FilterResult.PROCESS))) {
                this.process(expression2);
            }
        }

        @Override
        @NotNull
        protected KtElement qualifier(@NotNull KtThisExpression element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            throw (Throwable)((Object)new AssertionError((Object)("Qualifier requested: " + PsiUtilsKt.getElementTextWithContext((PsiElement)element2))));
        }

        @Override
        @NotNull
        protected KtElement shortenElement(@NotNull KtThisExpression element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            PsiElement psiElement = element2.replace((PsiElement)this.simpleThis);
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            }
            return (KtElement)psiElement;
        }

        public ShortenThisExpressionsVisitor(@NotNull KtFile file, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            super(file, elementFilter, failedToImportDescriptors);
            KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory((PsiElement)file).createExpression("this");
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThisExpression");
            }
            this.simpleThis = (KtThisExpression)ktExpression;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0014J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\n*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences$RemoveExplicitCompanionObjectReferenceVisitor;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$QualifiedExpressionShorteningVisitor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "process", "", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "shortenElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "singleTarget", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "idea-analysis"})
    private static final class RemoveExplicitCompanionObjectReferenceVisitor
    extends QualifiedExpressionShorteningVisitor {
        private final DeclarationDescriptor singleTarget(KtExpression $receiver, BindingContext context) {
            Object object;
            KtExpression ktExpression = CallUtilKt.getCalleeExpressionIfAny($receiver);
            if (!(ktExpression instanceof KtReferenceExpression)) {
                ktExpression = null;
            }
            return (object = (KtReferenceExpression)ktExpression) != null && (object = Companion.targets((KtReferenceExpression)object, context)) != null ? (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object)) : null;
        }

        @Override
        public boolean process(@NotNull KtDotQualifiedExpression qualifiedExpression) {
            KtExpression selectorsSelector;
            Intrinsics.checkParameterIsNotNull((Object)qualifiedExpression, (String)"qualifiedExpression");
            BindingContext bindingContext2 = this.analyze(qualifiedExpression);
            KtExpression receiver = qualifiedExpression.getReceiverExpression();
            if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)qualifiedExpression), (Class[])new Class[]{KtImportDirective.class, KtPackageDirective.class}) != null) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = this.singleTarget(receiver, bindingContext2);
            if (declarationDescriptor == null) {
                return false;
            }
            DeclarationDescriptor receiverTarget = declarationDescriptor;
            if (!(receiverTarget instanceof ClassDescriptor)) {
                return false;
            }
            KtExpression ktExpression = qualifiedExpression.getSelectorExpression();
            if (ktExpression == null) {
                return false;
            }
            KtExpression selectorExpression = ktExpression;
            DeclarationDescriptor declarationDescriptor2 = this.singleTarget(selectorExpression, bindingContext2);
            if (declarationDescriptor2 == null) {
                return false;
            }
            DeclarationDescriptor selectorTarget = declarationDescriptor2;
            if (Intrinsics.areEqual((Object)((ClassDescriptor)receiverTarget).getCompanionObjectDescriptor(), (Object)selectorTarget) ^ true) {
                return false;
            }
            PsiElement psiElement = qualifiedExpression.getParent();
            if (!(psiElement instanceof KtDotQualifiedExpression)) {
                psiElement = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement;
            KtExpression ktExpression2 = selectorsSelector = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getSelectorExpression() : null;
            if (selectorsSelector == null) {
                this.addElementToShorten((KtElement)qualifiedExpression);
                return true;
            }
            DeclarationDescriptor declarationDescriptor3 = this.singleTarget(selectorsSelector, bindingContext2);
            if (declarationDescriptor3 == null) {
                return false;
            }
            DeclarationDescriptor selectorsSelectorTarget = declarationDescriptor3;
            if (selectorsSelectorTarget instanceof ClassDescriptor) {
                return false;
            }
            this.addElementToShorten((KtElement)qualifiedExpression);
            return true;
        }

        @Override
        @NotNull
        protected KtElement shortenElement(@NotNull KtDotQualifiedExpression element2) {
            KtElement ktElement;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            KtExpression receiver = element2.getReceiverExpression();
            KtExpression ktExpression = element2.getSelectorExpression();
            if (ktExpression == null) {
                return element2;
            }
            KtExpression selector = ktExpression;
            KtExpression ktExpression2 = receiver;
            if (ktExpression2 instanceof KtSimpleNameExpression) {
                KtSimpleNameExpression ktSimpleNameExpression;
                PsiElement psiElement = ((KtSimpleNameExpression)receiver).getIdentifier();
                if (psiElement == null) {
                    return element2;
                }
                PsiElement identifier = psiElement;
                KtExpression ktExpression3 = CallUtilKt.getCalleeExpressionIfAny(selector);
                if (!(ktExpression3 instanceof KtSimpleNameExpression)) {
                    ktExpression3 = null;
                }
                PsiElement psiElement2 = (ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression3) != null && (ktSimpleNameExpression = ktSimpleNameExpression.getIdentifier()) != null ? ktSimpleNameExpression.replace(identifier) : null;
                PsiElement psiElement3 = element2.replace((PsiElement)selector);
                if (psiElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                ktElement = (KtExpression)psiElement3;
            } else if (ktExpression2 instanceof KtQualifiedExpression) {
                KtSimpleNameExpression ktSimpleNameExpression;
                KtSimpleNameExpression ktSimpleNameExpression2;
                KtExpression ktExpression4 = ((KtQualifiedExpression)receiver).getSelectorExpression();
                if (!(ktExpression4 instanceof KtSimpleNameExpression)) {
                    ktExpression4 = null;
                }
                if ((ktSimpleNameExpression2 = (KtSimpleNameExpression)ktExpression4) == null || (ktSimpleNameExpression2 = ktSimpleNameExpression2.getIdentifier()) == null) {
                    return element2;
                }
                KtSimpleNameExpression identifier = ktSimpleNameExpression2;
                KtExpression ktExpression5 = CallUtilKt.getCalleeExpressionIfAny(selector);
                if (!(ktExpression5 instanceof KtSimpleNameExpression)) {
                    ktExpression5 = null;
                }
                PsiElement psiElement = (ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression5) != null && (ktSimpleNameExpression = ktSimpleNameExpression.getIdentifier()) != null ? ktSimpleNameExpression.replace((PsiElement)identifier) : null;
                KtExpression ktExpression6 = ((KtQualifiedExpression)receiver).getSelectorExpression();
                PsiElement psiElement4 = ktExpression6 != null ? ktExpression6.replace((PsiElement)selector) : null;
                PsiElement psiElement5 = element2.replace((PsiElement)receiver);
                if (psiElement5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                ktElement = (KtExpression)psiElement5;
            } else {
                ktElement = element2;
            }
            return ktElement;
        }

        public RemoveExplicitCompanionObjectReferenceVisitor(@NotNull KtFile file, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            super(file, elementFilter, failedToImportDescriptors);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u000b\u001a\u00020\f*\u00020\bH\u0002J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/util/ShortenReferences$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/idea/util/ShortenReferences;", "mayImport", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "asString", "", "targets", "", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "idea-analysis"})
    public static final class Companion {
        private final String asString(DeclarationDescriptor $receiver) {
            return DescriptorRenderer.FQ_NAMES_IN_TYPES.render($receiver);
        }

        private final Collection<DeclarationDescriptor> targets(KtReferenceExpression $receiver, BindingContext context) {
            return ImportsUtils.getImportableTargets($receiver, context);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean mayImport(DeclarationDescriptor descriptor2, KtFile file) {
            if (!ImportsUtils.canBeReferencedViaImport(descriptor2)) return false;
            Project project = file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            if (!ImportInsertHelper.Companion.getInstance(project).mayImportOnShortenReferences(descriptor2)) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

