/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;

public class ScriptNameUtil {
    private ScriptNameUtil() {
    }

    @NotNull
    public static Name fileNameWithExtensionStripped(@NotNull KtScript script, @NotNull String extension) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/script/ScriptNameUtil", "fileNameWithExtensionStripped"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/script/ScriptNameUtil", "fileNameWithExtensionStripped"));
        }
        KtFile file = script.getContainingKtFile();
        Name name2 = Name.identifier(ScriptNameUtil.generateNameByFileName(file.getName(), extension));
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/script/ScriptNameUtil", "fileNameWithExtensionStripped"));
        }
        return name2;
    }

    @NotNull
    public static String generateNameByFileName(@NotNull String fileName, @NotNull String extension) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/script/ScriptNameUtil", "generateNameByFileName"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/script/ScriptNameUtil", "generateNameByFileName"));
        }
        int index2 = fileName.lastIndexOf(47);
        if (index2 != -1) {
            fileName = fileName.substring(index2 + 1);
        }
        if (fileName.endsWith(extension)) {
            fileName = fileName.substring(0, fileName.length() - extension.length());
        } else {
            index2 = fileName.indexOf(46);
            if (index2 != -1) {
                fileName = fileName.substring(0, index2);
            }
        }
        fileName = Character.toUpperCase(fileName.charAt(0)) + (fileName.length() == 0 ? "" : fileName.substring(1));
        String string = fileName = fileName.replace('.', '_');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/script/ScriptNameUtil", "generateNameByFileName"));
        }
        return string;
    }
}

