/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.AutoSyncManager;
import org.jetbrains.settingsRepository.CannotResolveConflictInTestMode;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.SyncKt;
import org.jetbrains.settingsRepository.SyncManager;
import org.jetbrains.settingsRepository.SyncManager$WhenMappings;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/settingsRepository/SyncManager;", "", "icsManager", "Lorg/jetbrains/settingsRepository/IcsManager;", "autoSyncManager", "Lorg/jetbrains/settingsRepository/AutoSyncManager;", "(Lorg/jetbrains/settingsRepository/IcsManager;Lorg/jetbrains/settingsRepository/AutoSyncManager;)V", "<set-?>", "", "writeAndDeleteProhibited", "getWriteAndDeleteProhibited", "()Z", "setWriteAndDeleteProhibited", "(Z)V", "sync", "Lorg/jetbrains/settingsRepository/UpdateResult;", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "project", "Lcom/intellij/openapi/project/Project;", "localRepositoryInitializer", "Lkotlin/Function0;", "", "settings-repository"})
public final class SyncManager {
    private volatile boolean writeAndDeleteProhibited;
    private final IcsManager icsManager;
    private final AutoSyncManager autoSyncManager;

    public final boolean getWriteAndDeleteProhibited() {
        return this.writeAndDeleteProhibited;
    }

    private final void setWriteAndDeleteProhibited(boolean bl) {
        this.writeAndDeleteProhibited = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final UpdateResult sync(@NotNull SyncType syncType, @Nullable Project project, @Nullable Function0<Unit> localRepositoryInitializer) {
        void restartApplication;
        void updateResult;
        void exception;
        Intrinsics.checkParameterIsNotNull((Object)((Object)syncType), (String)"syncType");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        this.icsManager.runInAutoCommitDisabledMode((Function0<Unit>)((Function0)new Function0<Unit>(this, localRepositoryInitializer, syncType, (Ref.ObjectRef)exception, (Ref.ObjectRef)updateResult, (Ref.BooleanRef)restartApplication, project){
            final /* synthetic */ SyncManager this$0;
            final /* synthetic */ Function0 $localRepositoryInitializer;
            final /* synthetic */ SyncType $syncType;
            final /* synthetic */ Ref.ObjectRef $exception;
            final /* synthetic */ Ref.ObjectRef $updateResult;
            final /* synthetic */ Ref.BooleanRef $restartApplication;
            final /* synthetic */ Project $project;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                UIUtil.invokeAndWaitIfNeeded((Runnable)sync.1.INSTANCE);
                try {
                    SyncManager.access$setWriteAndDeleteProhibited$p(this.this$0, true);
                    ProgressManager.getInstance().run((Task)new Task.Modal(this, this.$project, IcsBundleKt.icsMessage("task.sync.title", new Object[0]), true){
                        final /* synthetic */ sync.1 this$0;

                        public void run(@NotNull ProgressIndicator indicator) {
                            RepositoryManager repositoryManager;
                            block22: {
                                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                                indicator.setIndeterminate(true);
                                SyncManager.access$getAutoSyncManager$p(this.this$0.this$0).waitAutoSync(indicator);
                                repositoryManager = SyncManager.access$getIcsManager$p(this.this$0.this$0).getRepositoryManager();
                                if (this.this$0.$localRepositoryInitializer == null) {
                                    try {
                                        RepositoryManager.DefaultImpls.commit$default(repositoryManager, indicator, this.this$0.$syncType, false, 4, null);
                                    }
                                    catch (ProcessCanceledException e) {
                                        IcsManagerKt.getLOG().warn("Canceled");
                                        return;
                                    }
                                    catch (Throwable e) {
                                        IcsManagerKt.getLOG().error(e);
                                        if (!Intrinsics.areEqual((Object)((Object)this.this$0.$syncType), (Object)((Object)SyncType.MERGE))) break block22;
                                        this.this$0.$exception.element = e;
                                        return;
                                    }
                                }
                            }
                            if (indicator.isCanceled()) {
                                return;
                            }
                            try {
                                switch (SyncManager$WhenMappings.$EnumSwitchMapping$0[this.this$0.$syncType.ordinal()]) {
                                    case 1: {
                                        this.this$0.$updateResult.element = repositoryManager.pull(indicator);
                                        boolean doPush = true;
                                        if (this.this$0.$localRepositoryInitializer != null) {
                                            this.this$0.$localRepositoryInitializer.invoke();
                                            if (!RepositoryManager.DefaultImpls.commit$default(repositoryManager, indicator, this.this$0.$syncType, false, 4, null) || repositoryManager.getAheadCommitsCount() == 0) {
                                                doPush = false;
                                            }
                                        }
                                        if (doPush) {
                                            repositoryManager.push(indicator);
                                        }
                                        break;
                                    }
                                    case 2: {
                                        this.this$0.$updateResult.element = repositoryManager.resetToTheirs(indicator);
                                        break;
                                    }
                                    case 3: {
                                        this.this$0.$updateResult.element = repositoryManager.resetToMy(indicator, (Function0<Unit>)this.this$0.$localRepositoryInitializer);
                                        if (repositoryManager.getAheadCommitsCount() <= 0) break;
                                        repositoryManager.push(indicator);
                                    }
                                }
                            }
                            catch (ProcessCanceledException e) {
                                IcsManagerKt.getLOG().debug("Canceled");
                                return;
                            }
                            catch (Throwable e) {
                                if (!(e instanceof AuthenticationException || e instanceof NoRemoteRepositoryException || e instanceof CannotResolveConflictInTestMode)) {
                                    IcsManagerKt.getLOG().error(e);
                                }
                                this.this$0.$exception.element = e;
                                return;
                            }
                            SyncManager.access$getIcsManager$p(this.this$0.this$0).setRepositoryActive(true);
                            boolean isSmartSchemeReload = Intrinsics.areEqual((Object)((Object)this.this$0.$syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ^ true;
                            if ((UpdateResult)this.this$0.$updateResult.element != null) {
                                Application app = ApplicationManager.getApplication();
                                Ref.BooleanRef booleanRef = this.this$0.$restartApplication;
                                IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)app));
                                if (iComponentStore == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
                                }
                                ComponentStoreImpl componentStoreImpl = (ComponentStoreImpl)iComponentStore;
                                UpdateResult updateResult = (UpdateResult)this.this$0.$updateResult.element;
                                if (updateResult == null) {
                                    Intrinsics.throwNpe();
                                }
                                MessageBus messageBus = app.getMessageBus();
                                Intrinsics.checkExpressionValueIsNotNull((Object)messageBus, (String)"app.messageBus");
                                booleanRef.element = SyncKt.updateStoragesFromStreamProvider(componentStoreImpl, updateResult, messageBus, Intrinsics.areEqual((Object)((Object)this.this$0.$syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)));
                            }
                            if (!this.this$0.$restartApplication.element && !isSmartSchemeReload) {
                                SchemesManagerFactory schemesManagerFactory = SchemesManagerFactory.getInstance();
                                if (schemesManagerFactory == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.SchemeManagerFactoryBase");
                                }
                                ((SchemeManagerFactoryBase)schemesManagerFactory).process((Function1)sync.run.1.INSTANCE);
                            }
                        }
                        {
                            this.this$0 = $outer;
                            super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                        }
                    });
                }
                finally {
                    SyncManager.access$setWriteAndDeleteProhibited$p(this.this$0, false);
                }
            }
            {
                this.this$0 = syncManager;
                this.$localRepositoryInitializer = function0;
                this.$syncType = syncType;
                this.$exception = objectRef;
                this.$updateResult = objectRef2;
                this.$restartApplication = booleanRef;
                this.$project = project;
                super(0);
            }
        }));
        if (restartApplication.element) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
            }
            ((ApplicationImpl)application).exit(true, true, true, true);
        } else if ((Throwable)exception.element != null) {
            Throwable throwable = (Throwable)exception.element;
            if (throwable == null) {
                Intrinsics.throwNpe();
            }
            throw throwable;
        }
        return (UpdateResult)updateResult.element;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ UpdateResult sync$default(SyncManager syncManager, SyncType syncType, Project project, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sync");
        }
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        return syncManager.sync(syncType, project, (Function0<Unit>)function0);
    }

    public SyncManager(@NotNull IcsManager icsManager2, @NotNull AutoSyncManager autoSyncManager) {
        Intrinsics.checkParameterIsNotNull((Object)icsManager2, (String)"icsManager");
        Intrinsics.checkParameterIsNotNull((Object)autoSyncManager, (String)"autoSyncManager");
        this.icsManager = icsManager2;
        this.autoSyncManager = autoSyncManager;
    }

    public static final /* synthetic */ boolean access$getWriteAndDeleteProhibited$p(SyncManager $this) {
        return $this.writeAndDeleteProhibited;
    }

    public static final /* synthetic */ void access$setWriteAndDeleteProhibited$p(SyncManager $this, boolean bl) {
        $this.writeAndDeleteProhibited = bl;
    }

    @NotNull
    public static final /* synthetic */ AutoSyncManager access$getAutoSyncManager$p(SyncManager $this) {
        return $this.autoSyncManager;
    }

    @NotNull
    public static final /* synthetic */ IcsManager access$getIcsManager$p(SyncManager $this) {
        return $this.icsManager;
    }
}

