/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.updater;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.FullRevision;

@Deprecated
public class PkgItem
implements Comparable<PkgItem> {
    private final PkgState mState;
    private final Package mMainPkg;
    private Package mUpdatePkg;
    private boolean mChecked;

    public PkgItem(Package mainPkg, PkgState state) {
        this.mMainPkg = mainPkg;
        this.mState = state;
        assert (this.mMainPkg != null);
    }

    public boolean isObsolete() {
        return this.mMainPkg.isObsolete();
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
    }

    public Package getUpdatePkg() {
        return this.mUpdatePkg;
    }

    public boolean hasUpdatePkg() {
        return this.mUpdatePkg != null;
    }

    public String getName() {
        return this.mMainPkg.getListDescription();
    }

    public FullRevision getRevision() {
        return this.mMainPkg.getRevision();
    }

    @Deprecated
    public String getDescription() {
        return this.mMainPkg.getLongDescription();
    }

    public Package getMainPackage() {
        return this.mMainPkg;
    }

    public PkgState getState() {
        return this.mState;
    }

    public SdkSource getSource() {
        return this.mMainPkg.getParentSource();
    }

    public AndroidVersion getAndroidVersion() {
        return this.mMainPkg instanceof IAndroidVersionProvider ? ((IAndroidVersionProvider)((Object)this.mMainPkg)).getAndroidVersion() : null;
    }

    public Archive[] getArchives() {
        return this.mMainPkg.getArchives();
    }

    @Override
    public int compareTo(PkgItem pkg) {
        return this.getMainPackage().compareTo(pkg.getMainPackage());
    }

    public boolean hasArchive(Archive archive) {
        if (this.mMainPkg.hasArchive(archive)) {
            return true;
        }
        return this.mUpdatePkg != null && this.mUpdatePkg.hasArchive(archive);
    }

    public boolean hasCompatibleArchive() {
        return this.mMainPkg.hasCompatibleArchive();
    }

    public boolean isSameMainPackageAs(Package pkg) {
        if (this.mMainPkg.canBeUpdatedBy(pkg) == Package.UpdateInfo.NOT_UPDATE) {
            return this.mMainPkg.getRevision().equals(pkg.getRevision());
        }
        return false;
    }

    public boolean isSameUpdatePackageAs(Package pkg) {
        if (this.mUpdatePkg != null && this.mUpdatePkg.canBeUpdatedBy(pkg) == Package.UpdateInfo.NOT_UPDATE) {
            return this.mUpdatePkg.getRevision().equals(pkg.getRevision());
        }
        return false;
    }

    public boolean isSameItemAs(PkgItem item) {
        boolean same;
        if (this == item) {
            return true;
        }
        boolean bl = same = this.mState == item.mState;
        if (same) {
            same = this.isSameMainPackageAs(item.getMainPackage());
        }
        if (same) {
            Package p1 = this.mUpdatePkg;
            Package p2 = item.getUpdatePkg();
            boolean bl2 = same = p1 == p2 || p1 == null && p2 == null || p1 != null && p2 != null;
            if (same && p1 != null) {
                same = p1.canBeUpdatedBy(p2) == Package.UpdateInfo.NOT_UPDATE;
            }
        }
        return same;
    }

    public boolean equals(Object obj) {
        return obj instanceof PkgItem && this.isSameItemAs((PkgItem)obj);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mState == null ? 0 : this.mState.hashCode());
        result = 31 * result + (this.mMainPkg == null ? 0 : this.mMainPkg.hashCode());
        result = 31 * result + (this.mUpdatePkg == null ? 0 : this.mUpdatePkg.hashCode());
        return result;
    }

    public boolean mergeUpdate(Package pkg) {
        if (this.mUpdatePkg == pkg) {
            return true;
        }
        if (this.mMainPkg.canBeUpdatedBy(pkg) == Package.UpdateInfo.UPDATE) {
            if (this.mUpdatePkg == null) {
                this.mUpdatePkg = pkg;
            } else if (this.mUpdatePkg.canBeUpdatedBy(pkg) == Package.UpdateInfo.UPDATE) {
                this.mUpdatePkg = pkg;
            }
            return true;
        }
        return false;
    }

    public void removeUpdate() {
        this.mUpdatePkg = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        if (this.mChecked) {
            sb.append(" * ");
        }
        sb.append(this.mState.toString());
        if (this.mMainPkg != null) {
            sb.append(", pkg:");
            sb.append(this.mMainPkg.toString());
        }
        if (this.mUpdatePkg != null) {
            sb.append(", updated by:");
            sb.append(this.mUpdatePkg.toString());
        }
        sb.append('>');
        return sb.toString();
    }

    public static enum PkgState {
        INSTALLED,
        NEW;

    }
}

