/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntCreatePropertyFix
implements LocalQuickFix {
    private static final String PROPERTY = "property";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    private final String myCanonicalText;
    @Nullable
    private final PropertiesFile myPropFile;

    public AntCreatePropertyFix(String canonicalText, @Nullable PropertiesFile propertiesFile) {
        this.myCanonicalText = canonicalText;
        this.myPropFile = propertiesFile;
    }

    @NotNull
    public String getName() {
        if (this.myPropFile != null) {
            String string = AntBundle.message("create.property.in.file.quickfix.name", this.myCanonicalText, this.myPropFile.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/quickfix/AntCreatePropertyFix", "getName"));
            }
            return string;
        }
        String string = AntBundle.message("create.property.quickfix.name", this.myCanonicalText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/quickfix/AntCreatePropertyFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String i18nName = AntBundle.message("ant.intention.create.property.family.name", new Object[0]);
        String string = i18nName == null ? "Create property" : i18nName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/quickfix/AntCreatePropertyFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        XmlFile xmlFile;
        XmlTag rootTag;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ant/quickfix/AntCreatePropertyFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/ant/quickfix/AntCreatePropertyFix", "applyFix"));
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile containingFile = psiElement.getContainingFile();
        FileModificationService modificationService = FileModificationService.getInstance();
        IProperty result = null;
        if (this.myPropFile != null) {
            VirtualFile vFile = this.myPropFile.getVirtualFile();
            boolean canModify = true;
            if (this.myPropFile instanceof PsiFile) {
                canModify = modificationService.prepareFileForWrite((PsiFile)this.myPropFile);
            } else if (vFile != null) {
                canModify = modificationService.prepareVirtualFilesForWrite(project, Collections.singleton(vFile));
            }
            if (canModify) {
                IProperty generatedProperty = this.myPropFile.addProperty(this.myCanonicalText, "");
                result = vFile != null ? new OpenFileDescriptor(project, vFile, generatedProperty.getPsiElement().getTextRange().getEndOffset()) : generatedProperty;
            }
        } else if (containingFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)containingFile).getRootTag()) != null && modificationService.prepareFileForWrite((PsiFile)xmlFile)) {
            XmlAttributeValue valueElement;
            XmlAttribute valueAttrib;
            Object generated;
            XmlTag propTag = rootTag.createChildTag(PROPERTY, rootTag.getNamespace(), null, false);
            propTag.setAttribute(NAME_ATTR, this.myCanonicalText);
            propTag.setAttribute(VALUE_ATTR, "");
            DomElement contextElement = DomUtil.getDomElement((PsiElement)descriptor.getPsiElement());
            if (contextElement == null) {
                generated = rootTag.addSubTag(propTag, true);
            } else {
                AntDomTarget containingTarget = (AntDomTarget)contextElement.getParentOfType(AntDomTarget.class, false);
                AntDomTarget anchor = containingTarget != null ? containingTarget : contextElement;
                XmlTag tag = anchor.getXmlTag();
                generated = !rootTag.equals(tag) ? tag.getParent().addBefore((PsiElement)propTag, (PsiElement)tag) : rootTag.addSubTag(propTag, true);
            }
            if (generated instanceof XmlTag && (valueAttrib = generated.getAttribute(VALUE_ATTR)) != null && (valueElement = valueAttrib.getValueElement()) instanceof Navigatable) {
                result = (Navigatable)valueElement;
            }
            if (result == null && generated instanceof Navigatable) {
                result = (Navigatable)generated;
            }
        }
        if (result != null) {
            result.navigate(true);
        }
    }
}

