/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseOSProcessHandler
extends ProcessHandler
implements TaskExecutor {
    private static final Logger LOG = Logger.getInstance(BaseOSProcessHandler.class);
    protected final Process myProcess;
    protected final String myCommandLine;
    protected final Charset myCharset;
    protected final String myPresentableName;
    protected final ProcessWaitFor myWaitFor;

    public BaseOSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/BaseOSProcessHandler", "<init>"));
        }
        this.myProcess = process;
        this.myCommandLine = commandLine;
        this.myCharset = charset;
        if (StringUtil.isEmpty(commandLine)) {
            LOG.warn(new IllegalArgumentException("Must specify non-empty 'commandLine' parameter"));
        }
        this.myPresentableName = CommandLineUtil.extractPresentableName(StringUtil.notNullize(commandLine));
        this.myWaitFor = new ProcessWaitFor(process, this, this.myPresentableName);
    }

    @NotNull
    protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/execution/process/BaseOSProcessHandler", "executeOnPooledThread"));
        }
        Future<?> future = AppExecutorUtil.getAppExecutorService().submit(task);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "executeOnPooledThread"));
        }
        return future;
    }

    @Override
    @NotNull
    public Future<?> executeTask(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/execution/process/BaseOSProcessHandler", "executeTask"));
        }
        Future<?> future = this.executeOnPooledThread(task);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "executeTask"));
        }
        return future;
    }

    @NotNull
    public Process getProcess() {
        Process process = this.myProcess;
        if (process == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "getProcess"));
        }
        return process;
    }

    protected boolean useAdaptiveSleepingPolicyWhenReadingOutput() {
        return false;
    }

    protected boolean useNonBlockingRead() {
        return !Registry.is("output.reader.blocking.mode", false);
    }

    protected boolean processHasSeparateErrorStream() {
        return true;
    }

    @Override
    public void startNotify() {
        if (this.myCommandLine != null) {
            this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        }
        this.addProcessListener(new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startNotified(ProcessEvent event) {
                try {
                    final BaseDataReader stdOutReader = BaseOSProcessHandler.this.createOutputDataReader(BaseOSProcessHandler.this.getPolicy());
                    final BaseDataReader stdErrReader = BaseOSProcessHandler.this.processHasSeparateErrorStream() ? BaseOSProcessHandler.this.createErrorDataReader(BaseOSProcessHandler.this.getPolicy()) : null;
                    BaseOSProcessHandler.this.myWaitFor.setTerminationCallback(new Consumer<Integer>(){

                        @Override
                        public void consume(Integer exitCode) {
                            try {
                                if (stdErrReader != null) {
                                    stdErrReader.stop();
                                }
                                stdOutReader.stop();
                                try {
                                    if (stdErrReader != null) {
                                        stdErrReader.waitFor();
                                    }
                                    stdOutReader.waitFor();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            finally {
                                BaseOSProcessHandler.this.onOSProcessTerminated(exitCode);
                            }
                        }
                    });
                }
                finally {
                    BaseOSProcessHandler.this.removeProcessListener(this);
                }
            }
        });
        super.startNotify();
    }

    @NotNull
    private BaseDataReader.SleepingPolicy getPolicy() {
        if (this.useNonBlockingRead()) {
            BaseDataReader.SleepingPolicy sleepingPolicy = this.useAdaptiveSleepingPolicyWhenReadingOutput() ? new BaseDataReader.AdaptiveSleepingPolicy() : BaseDataReader.SleepingPolicy.SIMPLE;
            if (sleepingPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "getPolicy"));
            }
            return sleepingPolicy;
        }
        BaseDataReader.SleepingPolicy sleepingPolicy = BaseDataReader.SleepingPolicy.BLOCKING;
        if (sleepingPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "getPolicy"));
        }
        return sleepingPolicy;
    }

    @NotNull
    protected BaseDataReader createErrorDataReader(@NotNull BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (sleepingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sleepingPolicy", "com/intellij/execution/process/BaseOSProcessHandler", "createErrorDataReader"));
        }
        SimpleOutputReader simpleOutputReader = new SimpleOutputReader(this.createProcessErrReader(), ProcessOutputTypes.STDERR, sleepingPolicy, "error stream of " + this.myPresentableName);
        if (simpleOutputReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "createErrorDataReader"));
        }
        return simpleOutputReader;
    }

    @NotNull
    protected BaseDataReader createOutputDataReader(@NotNull BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (sleepingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sleepingPolicy", "com/intellij/execution/process/BaseOSProcessHandler", "createOutputDataReader"));
        }
        SimpleOutputReader simpleOutputReader = new SimpleOutputReader(this.createProcessOutReader(), ProcessOutputTypes.STDOUT, sleepingPolicy, "output stream of " + this.myPresentableName);
        if (simpleOutputReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "createOutputDataReader"));
        }
        return simpleOutputReader;
    }

    protected void onOSProcessTerminated(int exitCode) {
        this.notifyProcessTerminated(exitCode);
    }

    @NotNull
    protected Reader createProcessOutReader() {
        Reader reader = this.createInputStreamReader(this.myProcess.getInputStream());
        if (reader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "createProcessOutReader"));
        }
        return reader;
    }

    @NotNull
    protected Reader createProcessErrReader() {
        Reader reader = this.createInputStreamReader(this.myProcess.getErrorStream());
        if (reader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "createProcessErrReader"));
        }
        return reader;
    }

    @NotNull
    private Reader createInputStreamReader(@NotNull InputStream streamToRead) {
        if (streamToRead == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamToRead", "com/intellij/execution/process/BaseOSProcessHandler", "createInputStreamReader"));
        }
        Charset charset = this.charsetNotNull();
        BaseInputStreamReader baseInputStreamReader = new BaseInputStreamReader(streamToRead, charset);
        if (baseInputStreamReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "createInputStreamReader"));
        }
        return baseInputStreamReader;
    }

    @NotNull
    private Charset charsetNotNull() {
        Charset charset = this.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        Charset charset2 = charset;
        if (charset2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler", "charsetNotNull"));
        }
        return charset2;
    }

    @Override
    protected void destroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void doDestroyProcess() {
        this.getProcess().destroy();
    }

    @Override
    protected void detachProcessImpl() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BaseOSProcessHandler.this.closeStreams();
                BaseOSProcessHandler.this.myWaitFor.detach();
                BaseOSProcessHandler.this.notifyProcessDetached();
            }
        };
        this.executeOnPooledThread(runnable);
    }

    protected void closeStreams() {
        try {
            this.myProcess.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }

    @Override
    public boolean detachIsDefault() {
        return false;
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcess.getOutputStream();
    }

    public String getCommandLine() {
        return this.myCommandLine;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    public String toString() {
        return this.myCommandLine;
    }

    @Override
    public boolean waitFor() {
        boolean result = super.waitFor();
        try {
            this.myWaitFor.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private class SimpleOutputReader
    extends BaseOutputReader {
        private final Key myProcessOutputType;

        private SimpleOutputReader(@NotNull Reader reader, Key processOutputType, @NotNull BaseDataReader.SleepingPolicy sleepingPolicy, String presentableName) {
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader", "<init>"));
            }
            if (processOutputType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutputType", "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader", "<init>"));
            }
            if (presentableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader", "<init>"));
            }
            super(reader, sleepingPolicy);
            this.myProcessOutputType = processOutputType;
            this.start(presentableName);
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader", "executeOnPooledThread"));
            }
            Future<?> future = BaseOSProcessHandler.this.executeOnPooledThread(runnable);
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader", "executeOnPooledThread"));
            }
            return future;
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader", "onTextAvailable"));
            }
            BaseOSProcessHandler.this.notifyTextAvailable(text, this.myProcessOutputType);
        }
    }

    public static class ExecutorServiceHolder {
        @Deprecated
        public static Future<?> submit(@NotNull Runnable task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/execution/process/BaseOSProcessHandler$ExecutorServiceHolder", "submit"));
            }
            LOG.warn("Deprecated method. Please use com.intellij.execution.process.BaseOSProcessHandler.executeTask() instead", new Throwable());
            return AppExecutorUtil.getAppExecutorService().submit(task);
        }
    }
}

