/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.util.ReflectionUtil;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;

public class WinProcessManager {
    private WinProcessManager() {
    }

    public static int getProcessPid(Process process) {
        if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                long handle = ReflectionUtil.getField(process.getClass(), process, Long.TYPE, "handle");
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE winHandle = new WinNT.HANDLE();
                winHandle.setPointer(Pointer.createConstant((long)handle));
                return kernel.GetProcessId(winHandle);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException("Unknown Process implementation");
    }
}

