/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.codeInspection.utils.SideEffectChecker;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyAssignmentCanBeOperatorAssignmentInspection
extends BaseInspection {
    public boolean ignoreLazyOperators = true;
    public boolean ignoreObscureOperators = false;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Assignment issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection", "getGroupDisplayName"));
        }
        return "Assignment issues";
    }

    @NotNull
    public String getDisplayName() {
        if ("Assignment replaceable with operator assignment" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection", "getDisplayName"));
        }
        return "Assignment replaceable with operator assignment";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)infos[0];
        String string = "<code>#ref</code> could be simplified to '" + GroovyAssignmentCanBeOperatorAssignmentInspection.calculateReplacementExpression(assignmentExpression) + "' #loc";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox("Ignore conditional operators", "ignoreLazyOperators");
        optionsPanel.addCheckbox("Ignore obscure operators", "ignoreObscureOperators");
        return optionsPanel;
    }

    static String calculateReplacementExpression(GrAssignmentExpression expression) {
        GrExpression rhs = expression.getRValue();
        GrBinaryExpression binaryExpression = (GrBinaryExpression)PsiUtil.skipParentheses(rhs, false);
        GrExpression lhs = expression.getLValue();
        assert (binaryExpression != null);
        IElementType sign = binaryExpression.getOperationTokenType();
        GrExpression rhsRhs = binaryExpression.getRightOperand();
        assert (rhsRhs != null);
        String signText = GroovyAssignmentCanBeOperatorAssignmentInspection.getTextForOperator(sign);
        if ("&&".equals(signText)) {
            signText = "&";
        } else if ("||".equals(signText)) {
            signText = "|";
        }
        return lhs.getText() + ' ' + signText + "= " + rhsRhs.getText();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        ReplaceAssignmentWithOperatorAssignmentVisitor replaceAssignmentWithOperatorAssignmentVisitor = new ReplaceAssignmentWithOperatorAssignmentVisitor();
        if (replaceAssignmentWithOperatorAssignmentVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection", "buildVisitor"));
        }
        return replaceAssignmentWithOperatorAssignmentVisitor;
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection", "buildFix"));
        }
        return new ReplaceAssignmentWithOperatorAssignmentFix((GrAssignmentExpression)location);
    }

    @Nullable
    @NonNls
    private static String getTextForOperator(IElementType operator) {
        if (operator == null) {
            return null;
        }
        if (operator.equals(GroovyTokenTypes.mPLUS)) {
            return "+";
        }
        if (operator.equals(GroovyTokenTypes.mMINUS)) {
            return "-";
        }
        if (operator.equals(GroovyTokenTypes.mSTAR)) {
            return "*";
        }
        if (operator.equals(GroovyTokenTypes.mDIV)) {
            return "/";
        }
        if (operator.equals(GroovyTokenTypes.mMOD)) {
            return "%";
        }
        if (operator.equals(GroovyTokenTypes.mBXOR)) {
            return "^";
        }
        if (operator.equals(GroovyTokenTypes.mLAND)) {
            return "&&";
        }
        if (operator.equals(GroovyTokenTypes.mLOR)) {
            return "||";
        }
        if (operator.equals(GroovyTokenTypes.mBAND)) {
            return "&";
        }
        if (operator.equals(GroovyTokenTypes.mBOR)) {
            return "|";
        }
        return null;
    }

    private class ReplaceAssignmentWithOperatorAssignmentVisitor
    extends BaseInspectionVisitor {
        private ReplaceAssignmentWithOperatorAssignmentVisitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(assignment);
            IElementType assignmentTokenType = assignment.getOperationTokenType();
            if (!assignmentTokenType.equals(GroovyTokenTypes.mASSIGN)) {
                return;
            }
            GrExpression lhs = assignment.getLValue();
            GrExpression rhs = (GrExpression)PsiUtil.skipParentheses(assignment.getRValue(), false);
            if (!(rhs instanceof GrBinaryExpression)) {
                return;
            }
            GrBinaryExpression binaryRhs = (GrBinaryExpression)rhs;
            if (binaryRhs.getRightOperand() == null) {
                return;
            }
            IElementType expressionTokenType = binaryRhs.getOperationTokenType();
            if (GroovyAssignmentCanBeOperatorAssignmentInspection.getTextForOperator(expressionTokenType) == null) {
                return;
            }
            if (JavaTokenType.EQEQ.equals(expressionTokenType)) {
                return;
            }
            if (GroovyAssignmentCanBeOperatorAssignmentInspection.this.ignoreLazyOperators && (GroovyTokenTypes.mLAND.equals(expressionTokenType) || GroovyTokenTypes.mLOR.equals(expressionTokenType))) {
                return;
            }
            if (GroovyAssignmentCanBeOperatorAssignmentInspection.this.ignoreObscureOperators && (GroovyTokenTypes.mBXOR.equals(expressionTokenType) || GroovyTokenTypes.mMOD.equals(expressionTokenType))) {
                return;
            }
            GrExpression lOperand = binaryRhs.getLeftOperand();
            if (SideEffectChecker.mayHaveSideEffects(lhs)) {
                return;
            }
            if (!EquivalenceChecker.expressionsAreEquivalent(lhs, lOperand)) {
                return;
            }
            this.registerError((PsiElement)assignment, assignment);
        }
    }

    private static class ReplaceAssignmentWithOperatorAssignmentFix
    extends GroovyFix {
        private final String m_name;

        private ReplaceAssignmentWithOperatorAssignmentFix(GrAssignmentExpression expression) {
            GrExpression rhs = expression.getRValue();
            GrBinaryExpression binaryExpression = (GrBinaryExpression)PsiUtil.skipParentheses(rhs, false);
            assert (binaryExpression != null);
            IElementType sign = binaryExpression.getOperationTokenType();
            String signText = GroovyAssignmentCanBeOperatorAssignmentInspection.getTextForOperator(sign);
            if ("&&".equals(signText)) {
                signText = "&";
            } else if ("||".equals(signText)) {
                signText = "|";
            }
            this.m_name = "Replace '=' with '" + signText + "='";
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentCanBeOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix", "doFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof GrAssignmentExpression)) {
                return;
            }
            GrAssignmentExpression expression = (GrAssignmentExpression)element;
            String newExpression = GroovyAssignmentCanBeOperatorAssignmentInspection.calculateReplacementExpression(expression);
            ReplaceAssignmentWithOperatorAssignmentFix.replaceExpression(expression, newExpression);
        }
    }
}

