/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class RemoveParenthesesFromMethodPredicate
implements PsiElementPredicate {
    RemoveParenthesesFromMethodPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        GrCommandArgumentList newArgList;
        GrStatement newStatement;
        GroovyPsiElement[] allArguments;
        if (!(element instanceof GrMethodCallExpression)) {
            return false;
        }
        if (!PsiUtil.isExpressionStatement(element)) {
            return false;
        }
        GrMethodCallExpression expression = (GrMethodCallExpression)element;
        if (PsiImplUtil.hasClosureArguments(expression)) {
            return false;
        }
        StringBuilder newStatementText = new StringBuilder();
        newStatementText.append(expression.getInvokedExpression().getText()).append(' ');
        GrArgumentList argumentList = expression.getArgumentList();
        GroovyPsiElement[] groovyPsiElementArray = allArguments = argumentList != null ? argumentList.getAllArguments() : GroovyPsiElement.EMPTY_ARRAY;
        if (argumentList != null) {
            argumentList = (GrArgumentList)argumentList.copy();
            PsiElement leftParen = argumentList.getLeftParen();
            PsiElement rightParen = argumentList.getRightParen();
            if (leftParen != null) {
                leftParen.delete();
            }
            if (rightParen != null) {
                rightParen.delete();
            }
            newStatementText.append(argumentList.getText());
        }
        try {
            newStatement = GroovyPsiElementFactory.getInstance(element.getProject()).createStatementFromText(newStatementText.toString());
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return newStatement instanceof GrApplicationStatement && ((newArgList = ((GrApplicationStatement)newStatement).getArgumentList()) == null && argumentList == null || newArgList != null && newArgList.getAllArguments().length == allArguments.length);
    }
}

