/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.spock;

import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.spock.SpockUtils;
import org.jetbrains.plugins.groovy.spock.SpockVariableDescriptor;

public class SpockPomDeclarationSearcher
extends PomDeclarationSearcher {
    public void findDeclarationsAt(@NotNull PsiElement element, int offsetInElement, Consumer<PomTarget> consumer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/spock/SpockPomDeclarationSearcher", "findDeclarationsAt"));
        }
        String name = SpockUtils.getNameByReference(element);
        if (name == null) {
            return;
        }
        GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
        if (method == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (!GroovyPsiManager.isInheritorCached(containingClass, "spock.lang.Specification")) {
            return;
        }
        Map<String, SpockVariableDescriptor> cachedValue = SpockUtils.getVariableMap(method);
        SpockVariableDescriptor descriptor = cachedValue.get(name);
        if (descriptor == null) {
            return;
        }
        if (descriptor.getNavigationElement() == element) {
            consumer.consume((Object)descriptor.getVariable());
        }
    }
}

