/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;

public class NotNullCachedComputableWrapper<T>
implements NotNullComputable<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)NotNullCachedComputableWrapper.class.getName());
    private NotNullComputable<T> myComputable;
    private volatile T myValue;

    public NotNullCachedComputableWrapper(@NotNull NotNullComputable<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/plugins/groovy/util/NotNullCachedComputableWrapper", "<init>"));
        }
        this.myComputable = computable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public T compute() {
        Object result = this.myValue;
        if (result != null) {
            T t = result;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/NotNullCachedComputableWrapper", "compute"));
            }
            return t;
        }
        NotNullCachedComputableWrapper notNullCachedComputableWrapper = this;
        synchronized (notNullCachedComputableWrapper) {
            result = this.myValue;
            if (result == null) {
                RecursionGuard.StackStamp stamp = ourGuard.markStack();
                result = this.myComputable.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = result;
                    this.myComputable = null;
                }
            }
        }
        T t = result;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/NotNullCachedComputableWrapper", "compute"));
        }
        return t;
    }

    public boolean isComputed() {
        return this.myValue != null;
    }
}

