/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class CapturingProcessAdapter
extends ProcessAdapter {
    private final ProcessOutput myOutput;

    public CapturingProcessAdapter() {
        this(new ProcessOutput());
    }

    public CapturingProcessAdapter(@NotNull ProcessOutput output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/execution/process/CapturingProcessAdapter", "<init>"));
        }
        this.myOutput = output;
    }

    public void onTextAvailable(ProcessEvent event, Key outputType) {
        this.addToOutput(event.getText(), outputType);
    }

    protected void addToOutput(String text, Key outputType) {
        if (outputType == ProcessOutputTypes.STDOUT) {
            this.myOutput.appendStdout(text);
        } else if (outputType == ProcessOutputTypes.STDERR) {
            this.myOutput.appendStderr(text);
        }
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/process/CapturingProcessAdapter", "processTerminated"));
        }
        this.myOutput.setExitCode(event.getExitCode());
    }

    public ProcessOutput getOutput() {
        return this.myOutput;
    }
}

