/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebBrowserUrlProvider {
    public static final ExtensionPointName<WebBrowserUrlProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.webBrowserUrlProvider");

    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ide/browsers/WebBrowserUrlProvider", "canHandleElement"));
        }
        try {
            Collection<Url> urls = this.getUrls(request);
            if (!urls.isEmpty()) {
                request.setResult(urls);
                return true;
            }
        }
        catch (BrowserException browserException) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file) throws BrowserException {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrl"));
        }
        return null;
    }

    @NotNull
    public Collection<Url> getUrls(@NotNull OpenInBrowserRequest request) throws BrowserException {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrls"));
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.getUrl(request, request.getVirtualFile()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrls"));
        }
        return list;
    }

    @Deprecated
    @Nullable
    public String getOpenInBrowserActionDescription(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getOpenInBrowserActionDescription"));
        }
        return null;
    }

    public static class BrowserException
    extends Exception {
        public BrowserException(String message) {
            super(message);
        }
    }
}

