/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import java.awt.image.RGBImageFilter;

abstract class WeightFilter
extends RGBImageFilter {
    private final Double myWeight;

    WeightFilter(Double weight) {
        if (weight != null && (weight < 0.0 || 1.0 < weight)) {
            throw new IllegalArgumentException("weight " + weight + " out of [0..1]");
        }
        this.myWeight = weight;
        this.canFilterIndexColorModel = true;
    }

    @Override
    public final int filterRGB(int x, int y, int rgb) {
        return 0xFF000000 & rgb | this.toRGB(0xFF & rgb >> 16, 0xFF & rgb >> 8, 0xFF & rgb);
    }

    abstract int toRGB(int var1, int var2, int var3);

    final int toRGB(int srcR, int srcG, int srcB, double dstR, double dstG, double dstB) {
        if (Double.isNaN(dstR)) {
            dstR = 0.0;
        }
        if (Double.isNaN(dstG)) {
            dstG = 0.0;
        }
        if (Double.isNaN(dstB)) {
            dstB = 0.0;
        }
        if (this.myWeight != null) {
            dstR = dstR * this.myWeight + (double)srcR * (1.0 - this.myWeight);
            dstG = dstG * this.myWeight + (double)srcG * (1.0 - this.myWeight);
            dstB = dstB * this.myWeight + (double)srcB * (1.0 - this.myWeight);
        }
        srcR = (int)dstR;
        srcG = (int)dstG;
        srcB = (int)dstB;
        return srcR << 16 | srcG << 8 | srcB;
    }
}

