/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Notification {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.Notification");
    private final String myGroupId;
    private Icon myIcon;
    private final NotificationType myType;
    private String myTitle;
    private String mySubtitle;
    private String myContent;
    private NotificationListener myListener;
    private String myDropDownText;
    private List<AnAction> myActions;
    private boolean myExpired;
    private Runnable myWhenExpired;
    private Boolean myImportant;
    private WeakReference<Balloon> myBalloonRef;
    private final long myTimestamp;

    public Notification(@NotNull String groupDisplayId, @NotNull Icon icon, @NotNull NotificationType type) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/intellij/notification/Notification", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/notification/Notification", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/notification/Notification", "<init>"));
        }
        this(groupDisplayId, icon, null, null, null, type, null);
    }

    public Notification(@NotNull String groupDisplayId, @NotNull Icon icon, @Nullable String title, @Nullable String subtitle, @Nullable String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/intellij/notification/Notification", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/notification/Notification", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/notification/Notification", "<init>"));
        }
        this.myGroupId = groupDisplayId;
        this.myTitle = StringUtil.notNullize((String)title);
        this.myContent = StringUtil.notNullize((String)content);
        this.myType = type;
        this.myListener = listener;
        this.myTimestamp = System.currentTimeMillis();
        this.myIcon = icon;
        this.mySubtitle = subtitle;
        LOG.assertTrue(this.isTitle() || this.isContent(), (Object)("Notification should have title: " + title + " and/or subtitle and/or content groupId: " + this.myGroupId));
    }

    public Notification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/intellij/notification/Notification", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/notification/Notification", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/Notification", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/notification/Notification", "<init>"));
        }
        this(groupDisplayId, title, content, type, null);
    }

    public Notification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/intellij/notification/Notification", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/notification/Notification", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/Notification", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/notification/Notification", "<init>"));
        }
        this.myGroupId = groupDisplayId;
        this.myTitle = title;
        this.myContent = content;
        this.myType = type;
        this.myListener = listener;
        this.myTimestamp = System.currentTimeMillis();
        LOG.assertTrue(this.isContent(), (Object)("Notification should have content, title: " + title + ", groupId: " + this.myGroupId));
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Notification setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
        Notification notification = this;
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "setIcon"));
        }
        return notification;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "getGroupId"));
        }
        return string;
    }

    public boolean isTitle() {
        return !StringUtil.isEmptyOrSpaces((String)this.myTitle) || !StringUtil.isEmptyOrSpaces((String)this.mySubtitle);
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "getTitle"));
        }
        return string;
    }

    @NotNull
    public Notification setTitle(@Nullable String title) {
        this.myTitle = StringUtil.notNullize((String)title);
        Notification notification = this;
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "setTitle"));
        }
        return notification;
    }

    @NotNull
    public Notification setTitle(@Nullable String title, @Nullable String subtitle) {
        Notification notification = this.setTitle(title).setSubtitle(subtitle);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "setTitle"));
        }
        return notification;
    }

    @Nullable
    public String getSubtitle() {
        return this.mySubtitle;
    }

    @NotNull
    public Notification setSubtitle(@Nullable String subtitle) {
        this.mySubtitle = subtitle;
        Notification notification = this;
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "setSubtitle"));
        }
        return notification;
    }

    public boolean isContent() {
        return !StringUtil.isEmptyOrSpaces((String)this.myContent);
    }

    @NotNull
    public String getContent() {
        String string = this.myContent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "getContent"));
        }
        return string;
    }

    @NotNull
    public Notification setContent(@Nullable String content) {
        this.myContent = StringUtil.notNullize((String)content);
        Notification notification = this;
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "setContent"));
        }
        return notification;
    }

    @Nullable
    public NotificationListener getListener() {
        return this.myListener;
    }

    @NotNull
    public Notification setListener(@NotNull NotificationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/notification/Notification", "setListener"));
        }
        this.myListener = listener;
        Notification notification = this;
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "setListener"));
        }
        return notification;
    }

    @NotNull
    public List<AnAction> getActions() {
        List list = ContainerUtil.notNullize(this.myActions);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "getActions"));
        }
        return list;
    }

    public static void fire(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/notification/Notification", "fire"));
        }
        AnActionEvent event = AnActionEvent.createFromAnAction(action, null, "unknown", DataContext.EMPTY_CONTEXT);
        if (ActionUtil.lastUpdateAndCheckDumb(action, event, false)) {
            ActionUtil.performActionDumbAware(action, event);
        }
    }

    @NotNull
    public String getDropDownText() {
        if (this.myDropDownText == null) {
            this.myDropDownText = "Actions";
        }
        String string = this.myDropDownText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "getDropDownText"));
        }
        return string;
    }

    @NotNull
    public Notification setDropDownText(@NotNull String dropDownText) {
        if (dropDownText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dropDownText", "com/intellij/notification/Notification", "setDropDownText"));
        }
        this.myDropDownText = dropDownText;
        Notification notification = this;
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "setDropDownText"));
        }
        return notification;
    }

    @NotNull
    public Notification addAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/notification/Notification", "addAction"));
        }
        if (this.myActions == null) {
            this.myActions = new ArrayList<AnAction>();
        }
        this.myActions.add(action);
        Notification notification = this;
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "addAction"));
        }
        return notification;
    }

    @NotNull
    public NotificationType getType() {
        NotificationType notificationType = this.myType;
        if (notificationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "getType"));
        }
        return notificationType;
    }

    public boolean isExpired() {
        return this.myExpired;
    }

    public void expire() {
        NotificationsManager.getNotificationsManager().expire(this);
        this.hideBalloon();
        this.myExpired = true;
        Runnable whenExpired = this.myWhenExpired;
        if (whenExpired != null) {
            whenExpired.run();
        }
    }

    public Notification whenExpired(@Nullable Runnable whenExpired) {
        this.myWhenExpired = whenExpired;
        return this;
    }

    public void hideBalloon() {
        if (this.myBalloonRef != null) {
            Balloon balloon = (Balloon)this.myBalloonRef.get();
            if (balloon != null) {
                balloon.hide();
            }
            this.myBalloonRef = null;
        }
    }

    public void setBalloon(final @NotNull Balloon balloon) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/notification/Notification", "setBalloon"));
        }
        this.hideBalloon();
        this.myBalloonRef = new WeakReference<Balloon>(balloon);
        balloon.addListener(new JBPopupAdapter(){

            @Override
            public void onClosed(LightweightWindowEvent event) {
                if (SoftReference.dereference((Reference)Notification.this.myBalloonRef) == balloon) {
                    Notification.this.myBalloonRef = null;
                }
            }
        });
    }

    @Nullable
    public Balloon getBalloon() {
        return (Balloon)SoftReference.dereference(this.myBalloonRef);
    }

    public void notify(@Nullable Project project) {
        Notifications.Bus.notify(this, project);
    }

    public Notification setImportant(boolean important) {
        this.myImportant = important;
        return this;
    }

    public boolean isImportant() {
        if (this.myImportant != null) {
            return this.myImportant;
        }
        return this.getListener() != null;
    }
}

