/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.processor;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.values.ClassSerializer;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CodeStyleDeriveProcessor {
    protected final LangCodeStyleExtractor myLangExtractor;

    protected CodeStyleDeriveProcessor(LangCodeStyleExtractor langExtractor) {
        this.myLangExtractor = langExtractor;
    }

    public abstract ValuesExtractionResult runWithProgress(Project var1, CodeStyleSettings var2, PsiFile var3, ProgressIndicator var4);

    public Map<Value, Object> backupValues(CodeStyleSettings settings, Language language) {
        List<Value> baseValues = this.getFormattingValues(settings, language);
        HashMap res = ContainerUtil.newHashMap();
        for (Value baseValue : baseValues) {
            res.put(baseValue, baseValue.value);
        }
        return res;
    }

    @NotNull
    private Collection<Value.VAR_KIND> getVarKinds() {
        LinkedList<Value.VAR_KIND> varKinds = new LinkedList<Value.VAR_KIND>();
        varKinds.addAll(this.myLangExtractor.getCustomVarKinds());
        varKinds.addAll(Arrays.asList(Value.VAR_KIND.defaultKinds));
        LinkedList<Value.VAR_KIND> linkedList = varKinds;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "getVarKinds"));
        }
        return linkedList;
    }

    @NotNull
    private Value.VAR_KIND getVarKind(@NotNull String name, @NotNull Object value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "getVarKind"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "getVarKind"));
        }
        for (Value.VAR_KIND varKind : this.getVarKinds()) {
            if (!varKind.accepts(name, value)) continue;
            Value.VAR_KIND vAR_KIND = varKind;
            if (vAR_KIND == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "getVarKind"));
            }
            return vAR_KIND;
        }
        Value.VAR_KIND vAR_KIND = Value.VAR_KIND.NOTHING;
        if (vAR_KIND == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "getVarKind"));
        }
        return vAR_KIND;
    }

    @NotNull
    private List<Value> readAll(@NotNull String instanceName, @NotNull Object instance) {
        if (instanceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceName", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "readAll"));
        }
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "readAll"));
        }
        Class<?> cls = instance.getClass();
        ArrayList<Value> ret = new ArrayList<Value>();
        ClassSerializer serializer = new ClassSerializer(instanceName, instance);
        for (Field field : cls.getDeclaredFields()) {
            if ((field = ClassSerializer.getPreparedField(field)) == null || field.getName().endsWith("_FORCE")) continue;
            try {
                ret.add(this.buildFValue(field, instance, serializer));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        ArrayList<Value> arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "readAll"));
        }
        return arrayList;
    }

    @NotNull
    private Value buildFValue(@NotNull Field field, @NotNull Object instance, @NotNull ClassSerializer serializer) throws IllegalAccessException {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "buildFValue"));
        }
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "buildFValue"));
        }
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "buildFValue"));
        }
        String name = field.getName();
        Object value = field.get(instance);
        Value.VAR_KIND varKind = this.getVarKind(name, value);
        Value value2 = new Value(name, value, serializer, varKind);
        if (value2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "buildFValue"));
        }
        return value2;
    }

    @NotNull
    protected List<Value> getFormattingValues(CodeStyleSettings settings, Language language) {
        LanguageCodeStyleSettingsProvider provider;
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            Utils.logError("IndentOptions from common settings are null; using indent options from settings.");
            indentOptions = settings.getIndentOptions();
        }
        CustomCodeStyleSettings languageSettings = Utils.getLanguageSettings(settings, language);
        List<Value> values = this.readAll("commonSettings", commonSettings);
        if (languageSettings != null) {
            values.addAll(this.readAll("ocSettings", languageSettings));
        }
        if ((provider = LanguageCodeStyleSettingsProvider.forLanguage(language)) != null) {
            Set<String> supportedFields = provider.getSupportedFields();
            ArrayList<Value> cvalues = new ArrayList<Value>(values.size());
            for (Value value : values) {
                if (!supportedFields.contains(value.name)) continue;
                cvalues.add(value);
            }
            values = cvalues;
        }
        if (indentOptions != null) {
            List<Value> valuesOrder = this.readAll("indentOptions", indentOptions);
            valuesOrder.addAll(values);
            List<Value> list = valuesOrder;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "getFormattingValues"));
            }
            return list;
        }
        Utils.logError("Not indent options detected.");
        List<Value> list = values;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor", "getFormattingValues"));
        }
        return list;
    }
}

