/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QueryFactory<Result, Parameters> {
    private final List<QueryExecutor<Result, Parameters>> myExecutors = ContainerUtil.createLockFreeCopyOnWriteList();

    public void registerExecutor(@NotNull QueryExecutor<Result, Parameters> executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/util/QueryFactory", "registerExecutor"));
        }
        this.myExecutors.add(executor);
    }

    public void unregisterExecutor(@NotNull QueryExecutor<Result, Parameters> executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/util/QueryFactory", "unregisterExecutor"));
        }
        this.myExecutors.remove(executor);
    }

    @NotNull
    public final Query<Result> createQuery(@NotNull Parameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/QueryFactory", "createQuery"));
        }
        ExecutorsQuery executorsQuery = new ExecutorsQuery(parameters, this.getExecutors());
        if (executorsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/QueryFactory", "createQuery"));
        }
        return executorsQuery;
    }

    @NotNull
    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        List<QueryExecutor<Result, Parameters>> list = this.myExecutors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/QueryFactory", "getExecutors"));
        }
        return list;
    }

    public boolean hasAnyExecutors() {
        return !this.getExecutors().isEmpty();
    }

    @NotNull
    public final Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        UniqueResultsQuery uniqueResultsQuery = new UniqueResultsQuery(this.createQuery(parameters));
        if (uniqueResultsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        return uniqueResultsQuery;
    }

    @NotNull
    public final Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters, @NotNull TObjectHashingStrategy<Result> hashingStrategy) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        UniqueResultsQuery<Result, Result> uniqueResultsQuery = new UniqueResultsQuery<Result, Result>(this.createQuery(parameters), hashingStrategy);
        if (uniqueResultsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        return uniqueResultsQuery;
    }

    @NotNull
    public final <T> Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters, @NotNull TObjectHashingStrategy<T> hashingStrategy, @NotNull Function<Result, T> mapper) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        UniqueResultsQuery<Result, T> uniqueResultsQuery = new UniqueResultsQuery<Result, T>(this.createQuery(parameters), hashingStrategy, mapper);
        if (uniqueResultsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/QueryFactory", "createUniqueResultsQuery"));
        }
        return uniqueResultsQuery;
    }
}

