/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsContent;

import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContent;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

class DirectoryContentListener {
    private String myModulePath;
    private final DirectoryContent myDirectoryContent = new DirectoryContent();
    @NonNls
    private static final String FILE_MESSAGE_PREFIX = "fname ";
    @NonNls
    private static final String MODULE_MESSAGE_PREFIX = "cvs server: ignoring module ";
    @NonNls
    private static final String MODULE_MESSAGE_PREFIX_2 = "cvs server: Updating ";
    @NonNls
    private static final Pattern NEW_DIRECTORY_PATTERN = Pattern.compile("cvs .*: New directory.*-- ignored");
    private String myModuleName;

    DirectoryContentListener() {
    }

    public void messageSent(String message) {
        if (DirectoryContentListener.directoryMessage(message)) {
            String directoryName = DirectoryContentListener.directoryNameFromMessage(message);
            if (this.myModulePath != null) {
                directoryName = this.myModulePath + "/" + new File(directoryName).getName();
            }
            this.myDirectoryContent.addSubDirectory(directoryName);
        } else if (DirectoryContentListener.fileMessage(message)) {
            int slashPos;
            String fileName = DirectoryContentListener.fileNameFromMessage(message);
            if (this.myModuleName != null && StringUtil.startsWithConcatenation((String)fileName, (String[])new String[]{this.myModuleName, "/"})) {
                fileName = fileName.substring(this.myModuleName.length() + 1);
            }
            if ((slashPos = fileName.indexOf(47)) > 0) {
                String directoryName = fileName.substring(0, slashPos);
                this.myDirectoryContent.addSubDirectory(directoryName);
            } else {
                if (this.myModulePath != null) {
                    fileName = this.myModulePath + "/" + new File(fileName).getName();
                }
                this.myDirectoryContent.addFile(fileName);
            }
        } else if (DirectoryContentListener.moduleMessage_ver1(message)) {
            String moduleName = DirectoryContentListener.moduleNameFromMessage_ver1(message);
            this.myDirectoryContent.addModule(moduleName);
        } else if (this.moduleMessage_ver2(message)) {
            String moduleName = this.moduleNameFromMessage_ver2(message);
            this.myDirectoryContent.addModule(moduleName);
        }
    }

    private String moduleNameFromMessage_ver2(String message) {
        String prefix = this.updatingModulePrefix2();
        return message.substring(prefix.length());
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    private static String moduleNameFromMessage_ver1(String message) {
        return message.substring(MODULE_MESSAGE_PREFIX.length());
    }

    public static boolean moduleMessage_ver1(String message) {
        return message.startsWith(MODULE_MESSAGE_PREFIX);
    }

    public boolean moduleMessage_ver2(String message) {
        if (this.myModuleName == null) {
            return false;
        }
        return message.startsWith(this.updatingModulePrefix2());
    }

    private String updatingModulePrefix2() {
        return MODULE_MESSAGE_PREFIX_2 + this.myModuleName + "/";
    }

    public static String fileNameFromMessage(String message) {
        return message.substring(FILE_MESSAGE_PREFIX.length());
    }

    public void setModulePath(String modulePath) {
        this.myModulePath = modulePath;
    }

    public static boolean fileMessage(String message) {
        return message.startsWith(FILE_MESSAGE_PREFIX);
    }

    public static boolean directoryMessage(String message) {
        return NEW_DIRECTORY_PATTERN.matcher(message).matches();
    }

    public static String directoryNameFromMessage(String message) {
        int directoryNameBeginMarker = 96;
        int directoryNameEndMarker = 39;
        int beginIndex = message.indexOf(96) + 1;
        int endIndex = message.indexOf(39);
        return message.substring(beginIndex, endIndex);
    }

    public DirectoryContent getDirectoryContent() {
        return this.myDirectoryContent;
    }

    public void setModuleName(String moduleLocation) {
        this.myModuleName = moduleLocation;
    }
}

