/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class YAMLElementGenerator {
    private final Project myProject;

    public YAMLElementGenerator(Project project) {
        this.myProject = project;
    }

    public static YAMLElementGenerator getInstance(Project project) {
        return (YAMLElementGenerator)ServiceManager.getService((Project)project, YAMLElementGenerator.class);
    }

    @NotNull
    public static String createChainedKey(@NotNull List<String> keyComponents, int indentAddition) {
        if (keyComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyComponents", "org/jetbrains/yaml/YAMLElementGenerator", "createChainedKey"));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyComponents.size(); ++i) {
            if (i > 0) {
                sb.append(StringUtil.repeatSymbol((char)' ', (int)(indentAddition + 2 * i)));
            }
            sb.append(keyComponents.get(i)).append(":");
            if (i + 1 >= keyComponents.size()) continue;
            sb.append('\n');
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLElementGenerator", "createChainedKey"));
        }
        return string;
    }

    @NotNull
    public YAMLKeyValue createYamlKeyValue(@NotNull String keyName, @NotNull String valueText) {
        if (keyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyName", "org/jetbrains/yaml/YAMLElementGenerator", "createYamlKeyValue"));
        }
        if (valueText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueText", "org/jetbrains/yaml/YAMLElementGenerator", "createYamlKeyValue"));
        }
        YAMLFile tempFile = this.createDummyYamlWithText(keyName + ": " + valueText);
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{YAMLKeyValue.class}).iterator().next();
        if (yAMLKeyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLElementGenerator", "createYamlKeyValue"));
        }
        return yAMLKeyValue;
    }

    @NotNull
    public YAMLFile createDummyYamlWithText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/yaml/YAMLElementGenerator", "createDummyYamlWithText"));
        }
        YAMLFile yAMLFile = (YAMLFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("temp." + YAMLFileType.YML.getDefaultExtension(), (FileType)YAMLFileType.YML, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        if (yAMLFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLElementGenerator", "createDummyYamlWithText"));
        }
        return yAMLFile;
    }

    @NotNull
    public PsiElement createEol() {
        YAMLFile file = this.createDummyYamlWithText("\n");
        PsiElement psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)file);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLElementGenerator", "createEol"));
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createSpace() {
        YAMLKeyValue keyValue = this.createYamlKeyValue("foo", "bar");
        ASTNode whitespaceNode = keyValue.getNode().findChildByType(TokenType.WHITE_SPACE);
        assert (whitespaceNode != null);
        PsiElement psiElement = whitespaceNode.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLElementGenerator", "createSpace"));
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createIndent(int size) {
        YAMLFile file = this.createDummyYamlWithText(StringUtil.repeatSymbol((char)' ', (int)size));
        PsiElement psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)file);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLElementGenerator", "createIndent"));
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createColon() {
        YAMLFile file = this.createDummyYamlWithText("? foo : bar");
        PsiElement at = file.findElementAt("? foo ".length());
        assert (at != null && at.getNode().getElementType() == YAMLTokenTypes.COLON);
        PsiElement psiElement = at;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLElementGenerator", "createColon"));
        }
        return psiElement;
    }
}

