/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.modules.KotlinModuleXmlBuilder;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.FunctionsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J4\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator;", "", "()V", "getRelatedProductionModule", "Lkotlin/Function1;", "Lorg/jetbrains/jps/model/module/JpsModule;", "findClassPathRoots", "", "Ljava/io/File;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "findSourceRoots", "", "Lorg/jetbrains/kotlin/build/JvmSourceRoot;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "generateModuleDescription", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "sourceFiles", "Lcom/intellij/util/containers/MultiMap;", "hasRemovedFiles", "", "getAdditionalOutputDirsWhereInternalsAreVisible", "getOutputDirSafe", "jps-plugin"})
public final class KotlinBuilderModuleScriptGenerator {
    private static final Function1<JpsModule, JpsModule> getRelatedProductionModule;
    public static final KotlinBuilderModuleScriptGenerator INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final File generateModuleDescription(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull MultiMap<ModuleBuildTarget, File> sourceFiles, boolean hasRemovedFiles) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        KotlinModuleXmlBuilder builder = new KotlinModuleXmlBuilder();
        boolean noSources = true;
        HashSet<File> outputDirs = new HashSet<File>();
        Iterator iterator2 = chunk.getTargets().iterator();
        while (iterator2.hasNext()) {
            ModuleBuildTarget target;
            ModuleBuildTarget moduleBuildTarget = target = (ModuleBuildTarget)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            outputDirs.add(this.getOutputDirSafe(moduleBuildTarget));
        }
        ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
        Iterator iterator3 = chunk.getTargets().iterator();
        while (iterator3.hasNext()) {
            Unit unit;
            Collection collection;
            ModuleBuildTarget target;
            ModuleBuildTarget moduleBuildTarget = target = (ModuleBuildTarget)iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            File outputDir2 = this.getOutputDirSafe(moduleBuildTarget);
            ModuleBuildTarget moduleBuildTarget2 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"target");
            List<File> friendDirs = this.getAdditionalOutputDirsWhereInternalsAreVisible(moduleBuildTarget2);
            if (IncrementalCompilation.isEnabled()) {
                Collection collection2 = sourceFiles.get((Object)target);
                collection = collection2;
                Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"sourceFiles.get(target)");
            } else {
                Collection collection3 = KotlinSourceFileCollector.getAllKotlinSourceFiles(target);
                collection = collection3;
                Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"KotlinSourceFileCollecto\u2026KotlinSourceFiles(target)");
            }
            ArrayList moduleSources = new ArrayList(collection);
            if (moduleSources.size() > 0 || hasRemovedFiles) {
                noSources = false;
                if (logger.isEnabled()) {
                    logger.logCompiledFiles((Collection)moduleSources, KotlinBuilder.KOTLIN_BUILDER_NAME, "Compiling files:");
                }
            }
            BuildTargetType targetType = target.getTargetType();
            boolean bl = targetType instanceof JavaModuleBuildTargetType;
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv$iv = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            String string = target.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.id");
            String string2 = outputDir2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"outputDir.absolutePath");
            Iterable iterable = moduleSources;
            ModuleBuildTarget moduleBuildTarget3 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget3, (String)"target");
            Iterable iterable2 = this.findSourceRoots(context, moduleBuildTarget3);
            ModuleBuildTarget moduleBuildTarget4 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget4, (String)"target");
            Iterable iterable3 = this.findClassPathRoots(moduleBuildTarget4);
            BuildTargetType buildTargetType = targetType;
            if (buildTargetType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.jps.builders.java.JavaModuleBuildTargetType");
            }
            String string3 = ((JavaModuleBuildTargetType)buildTargetType).getTypeId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(targetType as JavaModuleBuildTargetType).typeId");
            builder.addModule(string, string2, iterable, iterable2, iterable3, string3, ((JavaModuleBuildTargetType)targetType).isTests(), (Set<? extends File>)outputDirs, (Iterable<? extends File>)friendDirs);
        }
        if (noSources) {
            return null;
        }
        File scriptFile = File.createTempFile("kjps", StringUtil.sanitizeJavaIdentifier((String)chunk.getName()) + ".script.xml");
        FileUtil.writeToFile((File)scriptFile, (String)((Object)builder.asText()).toString());
        return scriptFile;
    }

    @NotNull
    public final File getOutputDirSafe(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        File file = target.getOutputDir();
        if (file == null) {
            throw (Throwable)new ProjectBuildException("No output directory found for " + target);
        }
        return file;
    }

    private final List<File> getAdditionalOutputDirsWhereInternalsAreVisible(ModuleBuildTarget target) {
        Unit unit;
        if (!target.isTests()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        SmartList result = new SmartList();
        CollectionsKt.addIfNotNull((Collection)result, JpsJavaExtensionService.getInstance().getOutputDirectory(target.getModule(), false));
        JpsModule jpsModule = target.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"target.module");
        JpsModule jpsModule2 = (JpsModule)getRelatedProductionModule.invoke((Object)jpsModule);
        if (jpsModule2 != null) {
            JpsModule $receiver$iv = jpsModule2;
            JpsModule it = $receiver$iv;
            CollectionsKt.addIfNotNull((Collection)result, JpsJavaExtensionService.getInstance().getOutputDirectory(it, false));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return (List)result;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<File> findClassPathRoots(ModuleBuildTarget target) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = JpsUtils.getAllDependencies(target).classes().getRoots();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String extension;
            File file = (File)element$iv$iv;
            if (!(file.exists() || Intrinsics.areEqual((Object)(extension = FilesKt.getExtension((File)file)), (Object)"class") || Intrinsics.areEqual((Object)extension, (Object)"jar"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JvmSourceRoot> findSourceRoots(CompileContext context, ModuleBuildTarget target) {
        List roots = context.getProjectDescriptor().getBuildRootIndex().getTargetRoots((BuildTarget)target, context);
        ArrayList result = ContainerUtil.newArrayList();
        for (JavaSourceRootDescriptor root : roots) {
            File file;
            void $receiver$iv;
            JvmSourceRoot jvmSourceRoot;
            File file2 = root.getRootFile();
            String prefix = root.getPackagePrefix();
            if (!file2.exists()) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            CharSequence charSequence = prefix;
            JvmSourceRoot jvmSourceRoot2 = jvmSourceRoot;
            JvmSourceRoot jvmSourceRoot3 = jvmSourceRoot;
            ArrayList arrayList = result;
            boolean bl = $receiver$iv.length() == 0;
            jvmSourceRoot2(file, bl ? (String)null : prefix);
            arrayList.add(jvmSourceRoot3);
        }
        List list = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"result");
        return list;
    }

    private KotlinBuilderModuleScriptGenerator() {
        Function1 function1;
        block4: {
            Method getProductionModuleMethod;
            Method getTestModulePropertiesMethod;
            Class<?> clazz;
            INSTANCE = this;
            KotlinBuilderModuleScriptGenerator $receiver$iv = this;
            KotlinBuilderModuleScriptGenerator $receiver = $receiver$iv;
            try {
                clazz = Class.forName("org.jetbrains.jps.model.module.JpsTestModuleProperties");
            }
            catch (ClassNotFoundException e) {
                function1 = FunctionsKt.alwaysNull();
                break block4;
            }
            Class<?> klass = clazz;
            try {
                Method method = JpsJavaExtensionService.class.getDeclaredMethod("getTestModuleProperties", JpsModule.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"JpsJavaExtensionService:\u2026\", JpsModule::class.java)");
                getTestModulePropertiesMethod = method;
                Method method2 = klass.getDeclaredMethod("getProductionModule", new Class[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"klass.getDeclaredMethod(\"getProductionModule\")");
                getProductionModuleMethod = method2;
            }
            catch (NoSuchMethodException e) {
                function1 = FunctionsKt.alwaysNull();
                break block4;
            }
            function1 = (Function1)new Function1<JpsModule, JpsModule>(getTestModulePropertiesMethod, getProductionModuleMethod){
                final /* synthetic */ Method $getTestModulePropertiesMethod;
                final /* synthetic */ Method $getProductionModuleMethod;

                @Nullable
                public final JpsModule invoke(@NotNull JpsModule module) {
                    JpsModule jpsModule;
                    Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                    Object object = this.$getTestModulePropertiesMethod.invoke((Object)JpsJavaExtensionService.getInstance(), module);
                    if (object != null) {
                        Object $receiver$iv = object;
                        Object it = $receiver$iv;
                        jpsModule = (JpsModule)this.$getProductionModuleMethod.invoke(it, new Object[0]);
                    } else {
                        jpsModule = null;
                    }
                    return jpsModule;
                }
                {
                    this.$getTestModulePropertiesMethod = method;
                    this.$getProductionModuleMethod = method2;
                    super(1);
                }
            };
        }
        getRelatedProductionModule = function1;
    }

    static {
        new KotlinBuilderModuleScriptGenerator();
    }
}

